;MASTMIND.ASM from MastMind.Z80 by Doug Cox, April 17, 1987

code segment
 assume cs:code
 org 100h
start:
 jmp begin

mode db 0
esc db 'ESC$'
banner db 020h, 011h,011h,011h,'MAST MIND',010h,010h,010h,020h,24h
row1 db 201,205,205,205,203,205,205,205,203,205,205,205
     db 203,205,205,205,187,24h
row2 db 186,32,219,32,186,32,219,32,186,32,219,32
     db 186,32,219,32,186,24h
row3 db 204,205,205,205,206,205,205,205,206,205,205,205
     db 206,205,205,205,185,24h
row4 db 186,32,32,32,186,32,32,32,186,32,32,32
     db 186,32,32,32,186,24h
row5 db 200,205,205,205,202,205,205,205,202,205,205,205
     db 202,205,205,205,188,24h
alph db ' A  B  C  D  E  F$'
choice db 'ABCDEF$'
boxes db 4 dup(?)
temp db 4 dup(?)
loc db 0
let db 0
bxcnt dw 0
cxcnt dw 0
loctns db ' Location$'
letrs db ' Letter$'
quit db 'Do you want to play again (Y/N)?$'

begin:
 mov ah,2ch ;get time (seconds in dh & hundreths in dl)
 int 21h

;get random number
 lea di,boxes
 mov bx,4 ;for four loop
four:
 mov cx,8 ;for random loop
random: ;a well-know random routine
 mov al,dh
 rcr al,1
 xor al,dh
 rcr al,1
 rcr al,1
 xor al,dh
 rcr al,1
 xor al,dl
 rcr al,1
 rcr al,1
 rcr al,1
 and al,1
 add dx,dx
 add al,dl
 mov dl,al
 loop random

 add al,6
subtract:
 sub al,6
 cmp al,6
 jnc subtract;make number 0 to 5

 add al,41h
 stosb ;save it in [boxes]
 dec bx
 jnz four

 mov ah,0fh ;get video mode function
 int 10h ;bios call
 mov [mode],al ;save video mode

 mov bh,0 ;screen page
 mov al,2 ;80x25 B&W on color screen
 mov ah,0 ;set mode function
 int 10h ;clear screen by changing modes

 mov dx,0 ;row & column
 mov ah,2 ;move cursor function
 int 10h
 lea dx,esc
 mov ah,9 ;write string function
 int 21h

 mov dx,031fh
 mov ah,2 ;move cursor function
 int 10h
 lea dx,banner
 mov ah,9
 int 21h

 mov dx,051fh
 mov ah,2
 int 10h
 lea dx,row1
 mov ah,9
 int 21h

 mov dx,061fh
 mov ah,2
 int 10h
 lea dx,row2
 mov ah,9
 int 21h

 mov dx,071fh
 mov si,dx ;for temp storage
 mov cx,7
loopx:
 mov ah,2
 int 10h
 lea dx,row3
 mov ah,9
 int 21h

 mov dx,si
 inc dh
 mov si,dx
 mov ah,2
 int 10h
 lea dx,row4
 mov ah,9
 int 21h

 mov dx,si
 inc dh
 mov si,dx
 loop loopx

 mov ah,2
 int 10h
 lea dx,row5
 mov ah,9
 int 21h

 mov dx,171fh
 mov ah,2
 int 10h
 lea dx,alph
 mov ah,9
 int 21h

;start playing...
 mov dx,1421h ;first cursor position
 mov ah,2
 int 10h

 mov cx,7 ;rows
prekbd:
 mov [cxcnt],cx ;save it
 mov [loc],'0'
 mov [let],'0'
 lea si,boxes
 lea di,temp
 mov cx,4
 cld
 rep movsb ;put [boxes] in [temp]

 lea si,boxes
 mov bx,4 ;boxes per row
kbd:
 mov [bxcnt],bx
kbd2:
 mov ah,0
 int 16h ;read keyboard

 and al,0dfh ;make uppercase
 lea bx,choice
 mov cx,6
input:
 cmp al,[bx]
 jz  good ;if in [ABCDEF]
 inc bx
 loop input

 cmp al,3 ;^C
 jz input2
 cmp al,1bh ;ESC
 jnz kbd2
input2:
 jmp preans

good:
 push ax
 mov ah,0eh
 int 10h
 add dx,4
 mov bh,0
 mov ah,2
 int 10h
 pop ax
 cmp al,[si]
 jnz locskp
 inc loc
locskp:
 inc si ;pointer to boxes
 lea bx,temp
 mov cx,4
letlop:
 cmp al,[bx]
 jnz letskp
 mov al,[let]
 inc al ;also takes letter out of al
 mov [let],al
 mov [bx],al ;so that box won't be counted again
letskp:
 inc bx
 loop letlop

 mov bx,[bxcnt]
 dec bx
 jnz kbd ;do 4 boxes

lets: ;write no. of correct letters
 mov al,let
 mov ah,0eh
 int 10h
 xchg dx,cx ;save dx
 lea dx,letrs
 mov ah,9
 int 21h
 xchg dx,cx
 cmp al,'1'
 jz  locs
 mov al,'s'
 mov ah,0eh
 int 10h

locs: ;write no. of correct locations
 sub dl,30
 mov bh,0
 mov ah,2
 int 10h
 mov al,loc
 mov ah,0eh
 int 10h
 xchg dx,cx
 lea dx,loctns
 mov ah,9
 int 21h
 xchg dx,cx
 mov al,loc
 cmp al,'1'
 jz  nextrow
 mov al,'s'
 mov ah,0eh
 int 10h

nextrow:
 mov al,'4'
 cmp al,[loc]
 jz  preans
 mov cx,[cxcnt]
 dec cx
 jz preans
 sub dh,2
 add dl,14
 mov bh,0
 mov ah,2
 int 10h
 jmp prekbd

preans:
 mov cx,4
 mov dx,0621h
 lea si,boxes
answer:
 mov bh,0
 mov ah,2
 int 10h
 lodsb
 mov ah,0eh
 int 10h
 add dx,4
 loop answer

 mov dx,0318h
 mov ah,2
 int 10h
 lea dx,quit
 mov ah,9
 int 21h

 mov ah,0
 int 16h
 and al,0dfh ;make uppercase
 cmp al,'Y'
 jnz return
 jmp start

return:
 mov bh,0 ;screen page
 mov ah,0 ;mode function
 mov al,[mode] ;screen mode before this program was run
 int 10h ;return to that mode

 int 20h ;return to DOS

code ends
 end start
