;GETDPF.ASM
;
;       Get drive\path\filename from command line
;
;6.13.85
;6.12.85
;4.30.85
;4.29.85
;hack of code from LIST547 by Vern Buerg
;
comment ~

On entry:

        command line tail in DTA (80H)

On exit:

        dta2                    copy of original DTA for Get First/Get Next
        dpathfilenm             d:\path\fname,0 ASCIIZ string, w/*.* if any
        dpathfilenm_len         ASCIIZ string length, net of trailing zero


Uses, requires:

	psp_dta
~

;----------------------------------------------------------
;		constants, messages
;

help            db      'Syntax:  STUFIT filename.ext ',cr,lf
                db      cr,lf
                db      '         [\][path\]*.*  OK',cr,lf
		db	cr,lf
		db	'Path, but no drive: files must be on default drive. ',cr,lf,eos

;----------------------------------------------------------
;		data storage

dta2            db      32 dup ('dta2')         ;copy of DTA (128 bytes)
dpathfilenm     db      16 dup('filename')      ;length = 128 bytes
dpathfilenm_len dw      0
fileptr         dw      offset dpathfilenm      ;ptr to filename part of string
blank           db      ' '

;----------------------------------------------------------
;		main code

getdpath	proc	near

GETDPATHFNAME:
		xor	ax,ax			;zero AX
		xor	cx,cx			;zero CX
	        mov     al,byte ptr ds:[80H]
		or	cx,ax			;non-zero?
	        je      showhelp        	;show syntax and exit
	        mov     di,offset dta2          ;copy original line first
		mov	cl,al			;lngth of input line, net of cr
		push	cx			;save input length
	        mov     si,offset psp_dta+1
	        rep     movsb

;now copy to work area:
	        mov     si,offset dta2
        	mov     di,offset dpathfilenm   ;full d:\p\*.* form
		pop	cx			;restore input line length


blanks:		lodsb
	        cmp     al,blank		;skip leading blanks
		je	skipit
		cmp	al,cr			;ending cr?
		je	gotparm
		stosb
skipit:		loop	blanks


Gotparm:
;(How get to the following condition?  Already kicked out the zero-length cmd.)
;Still have to check for empty line (with blanks only)--VB checking to see if
;  his initial area load (zeroes) has been overlaid or not.
;       Cmp     Filenm,0                ;Any command line parameter?
;       Je      GetFile                 ; nope, ask for one
;Foregoing code depends on initial load, which is not reusable if we want to
;reinvoke this section for multiple files on the command line.
;Instead, test for length of command line as zero to kick out the help msg
;punch in a zero at the end of the string to make it ASCIIZ string
	        mov     byte ptr [di],0
;get string length if needed later for debug purposes:
	        mov     ax,di
        	sub     ax,offset dpathfilenm
	        mov     dpathfilenm_len,ax      ;length net of ASCIIZ "0" at end
;Check if zero--and send help if it is:
	        cmp     ax,0
        	je      showhelp
	        clc                             ;clear carry--OK return
		ret

showhelp:
	        mov     dx,offset help
		mov	ah,9h
		int	21h
	        stc                             ;set carry for error return
	        ret

getdpath	endp
