;************************************************************
;*                                                          *
;*	SPEED.ASM                                           *
;*                                                          *
;*	INCREASES SPEED OF DIRECT CONSOLE I/O               *
;*                                                          *
;*	BY M. REIMER, BERLIN 1986                           *
;*                                                          *
;*	TESTED ON OSBORNE 1 / CO-POWER 88                   *
;*	BY ROMANUS WILLE, PRISDORF 1986                     *
;*                                                          *
;************************************************************
;
X	EQU	30			;ASK FOR KEY INPUT
CR	EQU	13
LF	EQU	10
;
DOS	EQU	21H			;DOS INTERRUPT
GINTV	EQU	35H			;GET INTERRUPT VECTOR
SINTV	EQU	25H			;SET INTERRUPT VECTOR
EXIT	EQU	4CH			;TERMINATE PROGRAM
PRINT	EQU	09H			;PRINT MESSAGE
;
CSEG	SEGMENT	'CODE'
	ASSUME	DS:CSEG,CS:CSEG
;
	ORG	100H			;MUST BE FOR *.COM FILES
START:	JMP	INIT
;************************************************************
;
;	ASK FOR INTERRUPT 021H
;
;************************************************************
INT21S:	CMP	AH,6			;ASK FOR FUNCTION 6
	JNZ	GODOS			;NO, GO TO DOS
	CMP	DL,0FFH			;ANY CONSOLE INPUT
	JZ	CONIN
	MOV	AL,DL			;DIRECT CONSOLE OUT
	DB	0EAH			;JMP VIDEO DRIVER
COJMP:	DW	0,0
;
CONIN:	PUSH	DS			;CONSOLE INPUT
	PUSH	CS
	POP	DS
	MOV	BX,OFFSET COUNT
	DEC	BYTE PTR [BX]		;COUNTER = 0?
	JZ	ECHT			;IF ANY
	XOR	AL,AL			;OTHERWISE RETURN
	POP	DS
	IRET
;
ECHT:	MOV	BYTE PTR [BX],X		;LOAD COUNTER
	POP	DS			;
;
GODOS:	DB	0EAH			;JMP	DOS
DOSJMP:	DW	0,0			;
;
COUNT:	DB	X			;COUNTER
;************************************************************
;
;	INIT LOADS OR UNLOADS SPEED
;
;************************************************************
INIT:	PUSH	ES		
	MOV	AX,256*GINTV+29H	;PUT INT29 VECTOR IN ES:BX
	INT	DOS
	MOV	WORD PTR COJMP,BX
	MOV	AX,ES
	MOV	WORD PTR COJMP+2,AX	;LOAD COUNT VECTOR
;
	MOV	AX,256*GINTV+21H	;PUT INT21 VECTOR IN ES:BX
	INT	DOS
	CMP	BX,OFFSET INT21S	;ALLREADY DONE
	JNZ	INSTAL			;NO, DO IT
;************************************************************
;
;	REMOVE SPEED; RESTORE OLD INT21H VECTOR
;
;************************************************************
	PUSH	DS
	PUSH	ES
	POP	DS			;DS = SEGMENT OF RESIDENT PART
	MOV	DX,WORD PTR DOSJMP
	MOV	AX,WORD PTR DOSJMP+2
	MOV	DS,AX
	MOV	AX,256*SINTV+21H
	INT	DOS			;RESTORE OLD INT21H VECTOR
	POP	DS
	POP	ES
;
	MOV	DX,OFFSET SIGNOF
	MOV	AH,PRINT
	INT	DOS			;PRINT MESSAGE
	MOV	AX,256*EXIT+0
	INT	DOS
;************************************************************
;
;	INSTALL SPEED
;
;************************************************************
INSTAL:	MOV	WORD PTR DOSJMP,BX
	MOV	AX,ES
	MOV	WORD PTR DOSJMP+2,AX	;SAVE OLD INT21H VECTOR
	POP	ES
;
	MOV	DX,OFFSET INT21S
	MOV	AX,256*SINTV+21H
	INT	DOS			;POINT TO INT21S
;
	MOV	DX,OFFSET SIGNON
	MOV	AH,PRINT
	INT	DOS			;PRINT MESSAGE
	MOV	DX,OFFSET INIT
	INT	27H			;TERMINATE BAT STAY RESIDENT
;
SIGNON:	DB	CR,LF,'SPEED                   VERSION 1.0$'
SIGNOF:	DB	CR,LF,'SPEED OFF$'
;
CSEG	ENDS
	END	START
;	
;************************************************************
;	END OF PROGRAM