	PAGE	60,132
	TITLE	PTRACE internal DOS Trace
	COMMENT * DJOHNSON 07/21/85 *

;
; PTRACE adds an internal trace table to PC DOS. You must be running
; DOS 2.0 or later to use it. This routine, PTRACE, loads itself
; into memory, steals software interrupt vectors, and then terminates
; and stays resident. After that, all DOS INT 21H, INT 13H(diskette),
; and printer INT 17H calls are recorded in the circular trace buffer
; maintained by this program. The trace table may be displayed by
; invoking the PCT command.
;
; Dick Johnson SLA
;
;
;
;			DISCLAIMER NOTICE
;
;  This  document and/or  portions  of	the material  and  data
;  furnished herewith,	was developed  under sponsorship of the
;  U.S.  Government.  Neither the U.S.	nor the U.S.D.O.E., nor
;  the Leland Stanford Junior University,  nor their employees,
;  nor their respective contractors,  subcontractors,  or their
;  employees,	makes any  warranty,  express  or implied,   or
;  assumes  any  liability  or	 responsibility  for  accuracy,
;  completeness or  usefulness of any  information,  apparatus,
;  product or  process disclosed,  or  represents that	its use
;  will not  infringe privately-owned  rights.	Mention  of any
;  product, its manufacturer, or suppliers shall not, nor is it
;  intended to, imply approval, disapproval, or fitness for any
;  particular use.   The U.S.  and  the University at all times
;  retain the right to use and disseminate same for any purpose
;  whatsoever.
;
;
;================================================================
CSEG	 SEGMENT PARA
;
START	 PROC	 FAR		       ;Main Procedure
;
;================================================================
ASSUME CS:CSEG,DS:CSEG,SS:CSEG,ES:NOTHING
;================================================================
; MACRO DEFINITIONS
STEAL	 MACRO	 N	     ; STEAL INT N
	 MOV	 INTNUM,N
	 MOV	 AL,INTNUM   ; ASK DOS FOR CURRENT VECTOR
	 MOV	 AH,035H
	 INT	 DOSINT      ; ANSWER IN ES:BX
	 MOV	 OLDIP&N,BX  ; SAVE OLD IP VALUE
	 MOV	 AX,ES	     ; AND OLD ES VALUE
	 MOV	 OLDCS&N,AX  ; ...
;
	 LEA	 DX,INTEXIT&N  ; NOW SET INTERRUPT VECTOR
	 MOV	 AL,INTNUM   ; VIA DOS CALL
	 MOV	 AH,025H
	 INT	 DOSINT      ; NEW VECTOR IS DS:DX
;
	 JMP	 CONT&N      ; JMP AROUND THE EXIT ITSELF
INTEXIT&N: PUSHF	     ; SAVE STATE OF FLAGS
	 INC	 CS:COUNT&N  ; COUNT THIS INT
	 MOV	 CS:INTNUM,N ; SET INT NUMBER
	 PUSH	 AX	     ; REG SAVE
	 MOV	 AX,CS:OLDIP&N ; SET UP FOR RETURN LATER
	 MOV	 CS:OLDIP,AX ; ...
	 MOV	 AX,CS:OLDCS&N ; ...
	 MOV	 CS:OLDCS,AX ; ...
	 POP	 AX	     ; RESTORE REG
	 JMP	 INTEXIT     ; JOIN COMMON EXIT
OLDIP&N  DW	 ?	     ; PREVIOUS IP
OLDCS&N  DW	 ?	     ; PREVIOUS CS
COUNT&N  DW	 0	     ; COUNT FOR THIS INT
CONT&N:  NOP		     ; CONTINUE
	 ENDM
;
BLANKS	 MACRO	 A,N
;; MOVE 'N' BLANKS TO AREA 'A'
	 CLD		    ; SET FORWARD DIRECTION
	 PUSH	 DS	    ; MAKE ES=DS
	 POP	 ES
	 LEA	 DI,A	    ; A=DESTINATION
	 MOV	 AL,20H     ; BLANK IN AL
	 IFNB	 <&N>
	 MOV	 CX,N	    ; LENGTH TO SET
	 ELSE
	 MOV	 CX,LENGTH A
	 ENDIF
REP	 STOSB		    ; MOVE THE BLANKS
	 ENDM
MVCLIT	 MACRO	 A,B,N
	 LOCAL	 SKIP,DATA
;; MOVE LITERAL B TO AREA A WITH LENGTH N.
	 CLD		    ; SET FORWARD DIRECTION
	 PUSH	 DS	    ; MAKE ES=DS
	 POP	 ES
	 LEA	 DI,A	    ; A=DESTINATION
	 JMP	 SKIP	    ; JUMP AROUND LITERAL
DATA	 DB	 B	    ; LITERAL
SKIP:	 LEA	 SI,DATA    ; MOVE FROM LITERAL
	 IFNB	 <&N>
	 MOV	 CX,N	    ; LENGTH TO MOVE
	 ELSE
	 MOV	 CX,LENGTH A
	 ENDIF
REP	 MOVSB		    ; MOVE A->B (N CHARACTERS)
	 ENDM
MVC	 MACRO	 A,B,N
;; MOVE STRING B TO AREA A WITH LENGTH N.
	 CLD		    ; SET FORWARD DIRECTION
	 PUSH	 DS	    ; MAKE ES=DS
	 POP	 ES
	 LEA	 DI,A	    ; A=DESTINATION
	 IFNB	 <&B>
	 LEA	 SI,B	    ; MOVE FROM B
	 ENDIF
	 IFNB	 <&N>
	 MOV	 CX,N	    ; LENGTH TO MOVE
	 ELSE
	 MOV	 CX,LENGTH A
	 ENDIF
REP	 MOVSB		    ; MOVE A->B (N CHARACTERS)
	 ENDM
MASCIIZ  MACRO	 A,S1,R1,N
	 LOCAL	 CLOOP,CLOOPX
;; MOVE ASCIIZ STRING S1:R1 INTO A.
;; STOP WHEN LENGTH N REACHED OR ON '00'X IN DATA
	 MOV	 AX,CALL&S1 ; SET ES FOR MOVE
	 MOV	 ES,AX
	 MOV	 SI,CALL&R1 ; SET SI FOR MOVE
	 MOV	 CX,N	    ; SET MAX MOVE LENGTH
	 LEA	 DI,A	    ; POINT TO DESTINATION
CLOOP:	 MOV	 AL,BYTE PTR ES:[SI] ; NEXT CHAR IN AL
	 INC	 SI
	 CMP	 AL,0	    ; IS IT A NULL?
	 JE	 CLOOPX     ; YES, EXIT
	 MOV	 BYTE PTR [DI],AL ; NO, STORE IT
	 INC	 DI
	 LOOP	 CLOOP	    ; GET NEXT CHARACTER
CLOOPX:  NOP
	 ENDM
;
;
	 ORG	 100H	    ; THIS IS A .COM FILE
BEGCODE: JMP	 CODE_START ; JMP AROUND DATA AREA
;
;================================================================
;
; DATA and STACK areas
;
;================================================================
	 DB	 64 DUP('**Stack*')
BEGSTACK DB	 ?
INTNUM	 DB	 ?	     ; INT to be intercepted
BFOUR	 DB	 4	     ; CONSTANT 4
SIGNON	 DB	 'PTRACE loaded at '
LOADCS	 DB	 '1234'
	 DB	 ':'
LOADIP	 DB	 '5678'
	 DB	 0AH,0DH,'$'
SIGNOFF  DB	 'PTRACE is already active'
	 DB	 0AH,0DH,'$'
;
YES	 DB	 'Y'
NO	 DB	 'N'
TFLAG	 DB	 'Y'        ; CONTROLS STORING OF TRACE ENTRIES
WRAP	 DB	 'N'        ; HAS TRACE TABLE WRAPPED YET?
POINT	 DW	 ?	    ; TRACE TABLE POINTER
OPTR	 DW	 ?	    ; USED WHEN TYPING TRACE TABLE
;
; DEFINITION OF A SINGLE TRACE ENTRY
;
TCS	 DB	 '1234'     ; CALLER CS
	 DB	 ':'
TIP	 DB	 '5678'     ; CALLER IP
TCINT	 DB	 ' INT '
LBLIP	 EQU	 $-TCS-1    ; WHERE TO PUT BLIP CHAR
TINT	 DB	 '00'       ; INT NUMBER
	 DB	 ' '
TDESC	 DB	 8 DUP('?')
	 DB	 ' '
TCHARS	 DB	 'AX='
TAX	 DB	 'AXAX'
	 DB	 ' '
TTEXT	 DB	 'BX='
TBX	 DB	 'BXBX'
	 DB	 ' CX='
TCX	 DB	 'CXCX'
	 DB	 ' '
TXTWFD	 DB	 'DX='
TDX	 DB	 'DXDX'
	 DB	 ' DS='
TDS	 DB	 'DSDS'
	 DB	 ' ES='
TES	 DB	 'ESES'
LL	 EQU	 $-TCS	    ; LENGTH OF AN ENTRY
LCHARS	 EQU	 $-TCHARS   ; LENGTH OF MASK AREA
LTEXT	 EQU	 $-TTEXT    ; LENGTH OF TEXT AREA
LWFD	 EQU	 $-TXTWFD   ; LENGTH OF 40H TEXT AREA
;
TMASK	 DB	 'AX='      ; MASK FOR AN ENTRY
	 DB	 'AXAX'
	 DB	 ' BX='
	 DB	 'BXBX'
	 DB	 ' CX='
	 DB	 'CXCX'
	 DB	 ' DX='
	 DB	 'DXDX'
	 DB	 ' DS='
	 DB	 'DSDS'
	 DB	 ' ES='
	 DB	 'ESES'
;
DMASK	 DB	 'FN='      ; MASK FOR INT 13H ENTRY
	 DB	 'AXAX'
	 DB	 ' BX='
	 DB	 'BXBX'
	 DB	 ' TS='
	 DB	 'CXCX'
	 DB	 ' HD='
	 DB	 'DXDX'
	 DB	 ' DS='
	 DB	 'DSDS'
	 DB	 ' ES='
	 DB	 'ESES'
;
; TRACE LINE OUTPUT BUFFER
;
OCS	 DB	 LL DUP(' ')
	 DB	 0AH,0DH    ; CR/LF
;
	 DB	 '>BEG>'    ; eyecatcher
BEGTRACE LABEL	 BYTE	    ; START OF TRACE TABLE
	 DB	 600 DUP (LL DUP(' '))
ENDTRACE DB	 '<END<'
OUTINT	 EQU	 7FH	    ; INT TO PRODUCE OUTPUT
DOSINT	 EQU	 21H	    ; DOS FUNCTION CALL INT
; DOS FUNCTIONS THAT POINT AT ASCIIZ WITH DS:DX
LSTASC	 DB	 09H,39H,3AH,3BH,3CH,3DH,41H,43H,4BH
	 DB	 4EH,4FH,56H,5AH,5BH
LLSTASC  EQU	 $-LSTASC
; DOS FUNCTIONS THAT POINT AT AN FCB VIA DS:DX
LSTFCB	 DB	 0FH,10H,11H,12H,13H,14H,15H,16H,17H
	 DB	 21H,22H,23H,24H,27H,28H
LLSTFCB  EQU	 $-LSTFCB
; DOS FUNCTIONS THAT OUTPUT A CHAR IN DL
LSTCDL	 DB	 02H,04H,05H,06H
LLSTCDL  EQU	 $-LSTCDL
;
DSKTAB	 DB	 00H,'DSK RST ' ; DISKETTE FUNCTIONS
	 DB	 01H,'DSK STAT'
	 DB	 02H,'DSK READ'
	 DB	 03H,'DSK WRIT'
	 DB	 04H,'DSK VERF'
	 DB	 05H,'DSK FMT '
	 DB	 9 DUP(0FFH)	  ; END OF TABLE
DOSTAB	 DB	 00H,'PGM TERM' ; DOS FUNCTION DESCRIPTIONS
LDT	 EQU	 $-DOSTAB	; length of an entry
	 DB	 01H,'KBD INPT'
	 DB	 02H,'DISP OUT'
	 DB	 03H,'AUX INPT'
	 DB	 04H,'AUX OUT '
	 DB	 05H,'PRT OUT '
	 DB	 06H,'CON ECHO'
	 DB	 07H,'CON READ'
	 DB	 08H,'CON-ECHO'
	 DB	 09H,'PRT STRG'
	 DB	 0AH,'KBD BUFD'
	 DB	 0BH,'CHK INPT'
	 DB	 0CH,'CLR&READ'
	 DB	 0DH,'DISK RST'
	 DB	 0EH,'SEL DISK'
	 DB	 0FH,'OPENFILE'
	 DB	 10H,'CLOSFILE'
	 DB	 11H,'SRCHFRST'
	 DB	 12H,'SRCHNEXT'
	 DB	 13H,'DELTFILE'
	 DB	 14H,'SEQ READ'
	 DB	 15H,'SEQ WRIT'
	 DB	 16H,'CREATE  '
	 DB	 17H,'RENAME  '
	 DB	 19H,'CUR DISK'
	 DB	 1AH,'SET DTA '
	 DB	 1BH,'ALLOINFO'
	 DB	 1CH,'ALLODRV '
	 DB	 21H,'RND READ'
	 DB	 22H,'RND WRIT'
	 DB	 23H,'FILESIZE'
	 DB	 24H,'SET RNDF'
	 DB	 25H,'SET VECT'
	 DB	 26H,'PGM SEGM'
	 DB	 27H,'RNDBREAD'
	 DB	 28H,'RNDBWRIT'
	 DB	 29H,'PARSENAM'
	 DB	 2AH,'GET DATE'
	 DB	 2BH,'SET DATE'
	 DB	 2CH,'GET TIME'
	 DB	 2DH,'SET TIME'
	 DB	 2EH,'VER SWCH'
	 DB	 2FH,'GET DTA '
	 DB	 30H,'DOS VER '
	 DB	 31H,'TERMKEEP'
	 DB	 33H,'CTLBRKCH'
	 DB	 35H,'GET VECT'
	 DB	 36H,'DISK SPC'
	 DB	 38H,'CNTRINFO'
	 DB	 39H,'MKDIR   '
	 DB	 3AH,'RMDIR   '
	 DB	 3BH,'CHDIR   '
	 DB	 3CH,'CREAT   '
	 DB	 3DH,'OPENFILE'
	 DB	 3EH,'CLOSHAND'
	 DB	 3FH,'RDFILDEV'
	 DB	 40H,'WRFILDEV'
	 DB	 41H,'UNLINK  '
	 DB	 42H,'LSEEK   '
	 DB	 43H,'CHMOD   '
	 DB	 44H,'IOCTL   '
	 DB	 45H,'DUP HAND'
	 DB	 46H,'FORCEDUP'
	 DB	 47H,'GET DIR '
	 DB	 48H,'GET MEM '
	 DB	 49H,'FREE MEM'
	 DB	 4AH,'SETBLOCK'
	 DB	 4BH,'EXEC PGM'
	 DB	 4CH,'EXIT RC '
	 DB	 4DH,'GET RC  '
	 DB	 4EH,'FINDFRST'
	 DB	 4FH,'FINDNEXT'
	 DB	 54H,'VERSTATE'
	 DB	 56H,'RENAMEF '
	 DB	 57H,'FILE TOD'
	 DB	 59H,'GETEXERR'
	 DB	 5AH,'TEMPFILE'
	 DB	 5BH,'CREATNEW'
	 DB	 5CH,'LOCKUNLK'
	 DB	 62H,'GET PSP '
	 DB	 9 DUP(0FFH)	  ; END OF TABLE
;================================================================
;
CODE_START:
; BASIC INITIALIZATION STUFF
	 MOV	 AX,CS	     ; FIX UP DS
	 MOV	 DS,AX	     ; ...
	 MOV	 SS,AX	     ; AND SS ALSO
	 LEA	 AX,BEGSTACK ; SET SP
	 MOV	 SP,AX	     ; ...
;
	 MOV	 AL,OUTINT   ; TRACING ALREADY ACTIVE?
	 MOV	 AH,35H      ; GET CURRENT VECTOR
	 INT	 DOSINT
	 MOV	 AX,ES	     ; POINT ANYWHERE?
	 CMP	 AX,0
	 JE	 TSTART
	 CMP	 BX,0
	 JE	 TSTART
;
	 LEA	 DX,SIGNOFF  ; TYPE ABORT MESSAGE
	 MOV	 AH,9
	 INT	 DOSINT
	 MOV	 AL,16	     ; SET NON-ZERO RC
	 MOV	 AH,4CH      ; TERMINATE PROCESS
	 INT	 DOSINT
;
TSTART:  LEA	 AX,BEGTRACE ; INIT TRACE TABLE POINTER
	 MOV	 POINT,AX
	 MOV	 AL,YES      ; TURN ON TRACING
	 MOV	 TFLAG,AL
	 MOV	 AL,NO	     ; NOT WRAPPED YET
	 MOV	 WRAP,AL
;
	 MOV	 AX,CS	     ; CONVERT LOAD ADDR FOR PRINTING
	 LEA	 SI,LOADCS
	 CALL	 HEXPRT
	 MOV	 AX,100H
	 LEA	 SI,LOADIP
	 CALL	 HEXPRT
;
	 LEA	 DX,SIGNON   ; TYPE SIGNON MESSAGE
	 MOV	 AH,9
	 INT	 DOSINT
;
; SET INT FOR PRODUCING OUTPUT
;
	 LEA	 DX,OUTPUT   ; ADDRESS OF ROUTINE
	 MOV	 AL,OUTINT   ; INT NUMBER
	 MOV	 AH,25H      ; SET INTERRUPT VECTOR
	 INT	 DOSINT      ; HAVE DOS PLACE IT
;
; Set INT intercepts
;
	 STEAL	 13H	     ; DISKETTE I/O CALL
	 STEAL	 17H	     ; PRINTER	I/O CALL
	 STEAL	 DOSINT      ; DOS FUNCTIONS
;
; NOW RETURN TO DOS WITH INTERCEPT IN PLACE
;
	 LEA	 DX,ENDOFME  ; DX=LAST ADDR+1
	 INT	 27H	     ; TERMINATE AND STAY RESIDENT
;
; OUTPUT TRACE TABLE TO SCREEN
; WHEN WE GET AN INT CALL
;
OUTPUT:
	 PUSH	 AX	     ; SAVE REGS
	 PUSH	 BX
	 PUSH	 CX
	 PUSH	 DX
	 PUSH	 ES
	 PUSH	 DS
	 MOV	 AX,CS	     ; SET DS=CS
	 MOV	 DS,AX
	 MOV	 AL,NO	     ; TURN OFF TRACING FOR NOW
	 MOV	 TFLAG,AL
	 LEA	 SI,BEGTRACE ; POINT AT START OF THINGS TO TYPE OUT
	 MOV	 AL,WRAP     ; WRAP YET?
	 CMP	 AL,NO	     ; NO, CONTINUE
	 JE	 NOWRAP
	 MOV	 SI,POINT    ; YES, POINT TO OLDEST ENTRY
NOWRAP:  NOP
TLOOP:	 LEA	 DI,OCS      ; POINT TO OUTPUT BUFFER
	 MOV	 OPTR,SI     ; SAVE CURRENT OUTPUT POINTER
	 MOV	 AX,DS	     ; MAKE ES=DS
	 MOV	 ES,AX
	 MOV	 CX,LL	     ; LENGTH OF AN ENTRY
REP	 MOVSB		     ; MOVE ENTRY TO BUFFER
;
	 MOV	 CX,LL	     ; MAKE IT PRINTABLE
	 LEA	 SI,OCS
XLAT:	 MOV	 AL,BYTE PTR [SI]
	 CMP	 AL,31	     ; LESS THAN BLANK?
	 JNLE	 XLAT2
XLATF:	 MOV	 BYTE PTR [SI],64 ; '@'
	 JMP	 XLATN
XLAT2:	 CMP	 AL,127      ; IN ASCII RANGE?
	 JA	 XLATF
XLATN:	 INC	 SI
	 LOOP	 XLAT
;
	 LEA	 DX,OCS      ; TYPE OUT BUFFER
	 MOV	 BX,1	     ; STANDARD OUTPUT
	 MOV	 CX,LL	     ; TRACE ENTRY LENGTH
	 INC	 CX	     ; LENGTH OF CRLF
	 INC	 CX
	 MOV	 AH,40H      ; WRITE FILE/DEVICE
	 INT	 DOSINT      ; ...
;
	 MOV	 AX,OPTR     ; NOW ADVANCE POINTER IN TABLE
	 ADD	 AX,LL	     ; BY LENGTH OF AN ENTRY
	 MOV	 SI,AX	     ; PLACE IN SOURCE POINTER REG
	 LEA	 BX,ENDTRACE ; AT END OF TABLE YET?
	 CMP	 SI,BX	     ; ...
	 JE	 SETTOP      ; YES, POINT BACK TO TOP
	 JMP	 ETEST
SETTOP:  LEA	 AX,BEGTRACE ; POINT BACK TO TOP OF TRACE TABLE
	 MOV	 SI,AX
ETEST:	 CMP	 SI,POINT    ; DONE YET?
	 JE	 OUTPUTX     ; YES, EXIT
	 JMP	 TLOOP	     ; NO, NEXT ENTRY TYPED OUT
OUTPUTX: MOV	 AL,YES      ; TURN TRACING BACK ON
	 MOV	 TFLAG,AL
	 POP	 DS
	 POP	 ES	     ; RESTORE REGS
	 POP	 DX
	 POP	 CX
	 POP	 BX
	 POP	 AX
	 IRET		     ; RETURN FROM INT
;
START	 ENDP
DUMMY	 PROC	 FAR
;
; COMMON INTERCEPT FOR ALL INTS WE STEAL
;
INTEXIT:
	 MOV	 CS:CALLAX,AX ; CALLER REGS TO DISPLAY
	 MOV	 CS:CALLBX,BX
	 MOV	 CS:CALLCX,CX
	 MOV	 CS:CALLDX,DX
	 MOV	 CS:CALLSI,SI
	 MOV	 CS:CALLDI,DI
	 PUSH	 DS	     ; SAVE REGS
	 PUSH	 ES
	 PUSH	 BP
	 PUSH	 AX
	 MOV	 AX,DS
	 MOV	 CS:CALLDS,AX
	 MOV	 AX,ES
	 MOV	 CS:CALLES,AX
	 PUSH	 BX
	 PUSH	 CX
	 PUSH	 DX
	 PUSH	 SI
	 PUSH	 DI
	 MOV	 BP,SP
	 MOV	 AX,CS
	 MOV	 DS,AX	     ; MAKE DS=CS
;
	 STI		     ; ALLOW HARDWARE INTERRUPTS
;
	 MOV	 AX,[BP+22]
	 MOV	 CALLCS,AX   ; CS WE WERE CALLED FROM
	 MOV	 AX,[BP+20]
	 MOV	 CALLIP,AX   ; IP WE WERE CALLED FROM
	 MOV	 AX,CALLIP
	 LEA	 SI,TIP      ; FORMAT IT
	 CALL	 HEXPRT
	 MOV	 AX,CALLCS
	 LEA	 SI,TCS      ; FORMAT IT
	 CALL	 HEXPRT
	 MOV	 AH,0
	 MOV	 AL,INTNUM   ; FORMAT INT NUMBER
	 LEA	 SI,TCINT+3
	 CALL	 HEXPRT
	 MVCLIT  TCINT,' INT ',5 ; IDENTIFY INT
	 MVC	 TCHARS,TMASK,LCHARS ; FILL IN CONSTANT THINGS
; FILL IN DESCRIPTION FIELD
	 MVCLIT  TDESC,'        ' ; UNKNOWN DESCRIPTION
	 CMP	 INTNUM,13H  ; DISKETTE?
	 JNE	 NOTDISK
;
	 MVC	 TCHARS,DMASK,LCHARS ; TAILOR FOR DISKETTE
	 MVCLIT  TDESC,'DISK I/O'
	 MOV	 AX,CALLAX   ; TRY TO MATCH FUNCTION IN AH
	 LEA	 SI,DSKTAB   ; TO GET DESCRIPTION
LOOPDD:  CMP	 AH,BYTE PTR [SI] ; MATCH?
	 JNE	 NOMATCHD    ; NO, LOOK AT NEXT ONE
	 INC	 SI	     ; YES, POINT AT DESCRIPTION
	 MVC	 TDESC,,8    ; MOVE IN DESC.
	 JMP	 ENDDESC     ; LEAVE LOOP
NOMATCHD: ADD	 SI,LDT      ; POINT AT NEXT TABLE ENTRY
	 MOV	 BL,0FFH     ; CHECK FOR END OF TABLE
	 CMP	 BL,BYTE PTR [SI]
	 JE	 END13H      ; YES, GIVE UP
	 JMP	 LOOPDD      ; NO, KEEP LOOKING
END13H:  JMP	 ENDDESC
;
NOTDISK: CMP	 INTNUM,17H  ; PRINTER?
	 JNE	 NOTPRNT
	 MVCLIT  TDESC,'PRNT I/O'
	 JMP	 ENDDESC
NOTPRNT: CMP	 INTNUM,20H  ; DOS TERMINATE?
	 JNE	 NOT20H
	 MVCLIT  TDESC,'DOS TERM'
	 JMP	 ENDDESC
NOT20H:  CMP	 INTNUM,DOSINT	; DOS FUNCTION?
	 JE	 SETDOSD
	 JMP	 NOTDOSF
SETDOSD: MVCLIT  TDESC,'DOS FUNC'
	 MOV	 AX,CALLAX   ; SHOW AX VALUE
	 LEA	 SI,TAX
	 CALL	 HEXPRT
	 MOV	 AX,CALLAX   ; TRY TO MATCH FUNCTION IN AH
	 LEA	 SI,DOSTAB   ; TO GET DESCRIPTION
LOOPD:	 CMP	 AH,BYTE PTR [SI] ; MATCH?
	 JNE	 NOMATCH     ; NO, LOOK AT NEXT ONE
	 INC	 SI	     ; YES, POINT AT DESCRIPTION
	 MVC	 TDESC,,8    ; MOVE IN DESC.
	 JMP	 DOSFMTCK    ; LEAVE LOOP
NOMATCH: ADD	 SI,LDT      ; POINT AT NEXT TABLE ENTRY
	 MOV	 BL,0FFH     ; CHECK FOR END OF TABLE
	 CMP	 BL,BYTE PTR [SI]
	 JE	 DOSFMTCK    ; YES, GIVE UP
	 JMP	 LOOPD	     ; NO, KEEP LOOKING
;
DOSFMTCK: MOV	 AX,CALLAX   ; CHECK FOR SPECIAL FORMATTING
	 MOV	 CX,LLSTASC  ; THOSE THAT HAVE ASCIIZ STRING
	 LEA	 SI,LSTASC   ; LIST OF WINNERS
ASCLOOP: CMP	 AH,BYTE PTR [SI] ; MATCH?
	 JE	 FMTASCI     ; YES, FORMAT IT
	 INC	 SI	     ; NEXT ENTRY
	 LOOP	 ASCLOOP
;
	 MOV	 AX,CALLAX   ; CHECK FOR SPECIAL FORMATTING
	 MOV	 CX,LLSTFCB  ; THOSE THAT HAVE AN FCB
	 LEA	 SI,LSTFCB   ; LIST OF WINNERS
FCBLOOP: CMP	 AH,BYTE PTR [SI] ; MATCH?
	 JNE	 FCBLOPX     ; NO, CONTINUE
	 JMP	 FMTFCB      ; YES, FORMAT IT
FCBLOPX: INC	 SI	     ; NEXT ENTRY
	 LOOP	 FCBLOOP
;
	 CMP	 AH,29H      ; PARSE FILENAME?
	 JE	 FMTPARS     ; YES, FORMAT COMMAND LINE
;
	 MOV	 AX,CALLAX   ; CHECK FOR SPECIAL FORMATTING
	 MOV	 CX,LLSTCDL  ; THOSE THAT HAVE CHAR IN DL
	 LEA	 SI,LSTCDL   ; LIST OF WINNERS
CDLLOOP: CMP	 AH,BYTE PTR [SI] ; MATCH?
	 JE	 FMTCDL      ; YES, FORMAT IT
	 INC	 SI	     ; NEXT ENTRY
	 LOOP	 CDLLOOP
;
	 JMP	 ENDDESC     ; USE DEFAULT FORMAT
;
FMTCDL:  BLANKS  TTEXT,LTEXT ; BLANK OUT AREA
	 MOV	 DX,CALLDX   ; GET THE CHARACTER
	 LEA	 DI,TTEXT    ; WHERE IT GOES
	 MOV	 BYTE PTR [DI],DL ; STORE THE CHARACTER
	 JMP	 STORTRC     ; OUTPUT LINE
;
FMTPARS: BLANKS  TTEXT,LTEXT ; BLANK OUT AREA
	 MOV	 AX,CALLDS   ; SET UP DS:SI POINTER
	 MOV	 ES,AX
	 MOV	 SI,CALLSI
	 LEA	 DI,TTEXT    ; WHERE TO PUT DATA
	 MOV	 CX,LTEXT
MVCPAR:  MOV	 AL,BYTE PTR ES:[SI] ; GET A BYTE
	 MOV	 BYTE PTR [DI],AL ; STORE IT
	 INC	 SI	     ; NEXT BYTE
	 INC	 DI
	 LOOP	 MVCPAR
	 JMP	 STORTRC     ; ADD TO TRACE TABLE
;
FMTASCI: BLANKS  TTEXT,LTEXT ; BLANK OUT AREA
	 MASCIIZ TTEXT,DS,DX,LTEXT ; FILL IN PLIST
	 JMP	 STORTRC     ; ADD TO TRACE TABLE
;
FMTFCB:  BLANKS  TTEXT,LTEXT ; BLANK OUT AREA
	 MOV	 AX,CALLDS   ; SET UP DS:DX POINTER
	 MOV	 ES,AX
	 MOV	 SI,CALLDX
	 LEA	 DI,TTEXT    ; WHERE TO PUT FCB
	 INC	 SI	     ; SKIP OVER DRIVE FIELD
	 MOV	 CX,11	     ; FILENAME+EXTENSION
MVCFCB:  MOV	 AL,BYTE PTR ES:[SI] ; GET A BYTE
	 MOV	 BYTE PTR [DI],AL ; STORE IT
	 INC	 SI	     ; NEXT BYTE
	 INC	 DI
	 LOOP	 MVCFCB
	 JMP	 STORTRC     ; ADD TO TRACE TABLE
;
NOTDOSF:
;
ENDDESC: MOV	 AX,CALLAX
	 LEA	 SI,TAX
	 CALL	 HEXPRT
	 MOV	 AX,CALLBX
	 LEA	 SI,TBX
	 CALL	 HEXPRT
	 MOV	 AX,CALLCX
	 LEA	 SI,TCX
	 CALL	 HEXPRT
	 MOV	 AX,CALLDX
	 LEA	 SI,TDX
	 CALL	 HEXPRT
	 MOV	 AX,CALLDS
	 LEA	 SI,TDS
	 CALL	 HEXPRT
	 MOV	 AX,CALLES
	 LEA	 SI,TES
	 CALL	 HEXPRT
	 MOV	 AX,DS	     ; MAKE ES=DS
	 MOV	 ES,AX
;
	 MOV	 AL,INTNUM   ; INT 21H?
	 CMP	 AL,DOSINT
	 JE	 TEST40H     ; YES, TEST FOR 40H(WRITE FILE/DEVICE)
	 JMP	 STORTRC
TEST40H: MOV	 AX,CALLAX   ; FUNCTION 40H?
	 CMP	 AH,40H
	 JE	 FMT40H
	 JMP	 STORTRC
FMT40H:  MOV	 AX,CALLDS   ; POINT AT DATA STRING
	 MOV	 ES,AX
	 MOV	 SI,CALLDX
	 LEA	 DI,TXTWFD   ; WHERE TEXT GOES
	 MOV	 CX,LWFD     ; LENGTH OF TEXT AREA
MFMT40H: MOV	 AL,BYTE PTR ES:[SI] ; GET A BYTE
	 MOV	 BYTE PTR [DI],AL ; AND STORE IT
	 INC	 SI
	 INC	 DI
	 LOOP	 MFMT40H     ; LOOP UNTIL DONE
;
; MOVE THIS ENTRY TO THE TRACE TABLE
;
STORTRC: MOV	 AL,TFLAG    ; ARE WE TRACING?
	 CMP	 AL,YES      ; ...
	 JE	 NXSTUF      ; YES, STORE IT
	 JMP	 GOBACK      ; NO, SKIP NEXT STUFF
;
NXSTUF:  MOV	 AL,LASTINT  ; CHECK FOR A DUPLICATE TRACE ENTRY
	 CMP	 AL,INTNUM
	 JNE	 NOTDUP
	 CMP	 AL,DOSINT   ; DOS INT?
	 JNE	 NOTDUP
	 MOV	 AX,LASTAX   ; DOS FUNCTION 2CH LAST TIME?
	 CMP	 AH,2CH
	 JNE	 NOTDUP2C
	 MOV	 AX,CALLAX   ; SAME THING THIS TIME ALSO?
	 CMP	 AH,2CH
	 JNE	 NOTDUP
	 JMP	 MARKDUP
NOTDUP2C:
	 CMP	 AH,0BH      ; CHECK INPUT LAST TIME?
	 JNE	 NOTDUP
	 MOV	 AX,CALLAX   ; SAME THING THIS TIME ALSO?
	 CMP	 AH,0BH      ; CHECK INPUT LAST TIME?
	 JNE	 NOTDUP
	 JMP	 MARKDUP
;
MARKDUP: MOV	 DI,LASTPTR  ; FLAG ENTRY AS A DUPLICATE
	 ADD	 DI,LBLIP
	 MOV	 BYTE PTR [DI],42 ; '*'
	 JMP	 GOBACK
;
NOTDUP:  MOV	 AL,INTNUM   ; REMEMBER LATEST TRACE DATA
	 MOV	 LASTINT,AL  ; SO WE CAN COMPARE NEXT TIME
	 MOV	 AX,CALLCS
	 MOV	 LASTCS,AX
	 MOV	 AX,CALLIP
	 MOV	 LASTIP,AX
	 MOV	 AX,CALLAX
	 MOV	 LASTAX,AX
;
	 MOV	 AX,DS	     ; MAKE ES=DS
	 MOV	 ES,AX	     ; ...
	 MOV	 DI,POINT    ; CURRENT PLACE IN TABLE
	 MOV	 LASTPTR,DI  ; REMEMBER
	 LEA	 SI,TCS      ; LATEST TRACE ENTRY
	 MOV	 CX,LL	     ; LENGTH OF AN ENTRY
REP	 MOVSB		     ; MOVE THE STRING
; COMPUTE ADDRESS OF NEXT ENTRY
	 LEA	 BP,ENDTRACE ; END OF TABLE
	 MOV	 AX,POINT    ; CURRENT POINTER
	 ADD	 AX,LL	     ; NEXT POINTER
	 CMP	 AX,BP	     ; REACH END YET?
	 JB	 MIDDLE      ; NO, STORE NEW PLACE
	 LEA	 AX,BEGTRACE ; YES, START OVER AT TOP
	 MOV	 BL,YES      ; SET WRAP FLAG
	 MOV	 WRAP,BL     ; ...
MIDDLE:  MOV	 POINT,AX
; RESTORE REGS
GOBACK:  POP	 DI
	 POP	 SI
	 POP	 DX
	 POP	 CX
	 POP	 BX
	 POP	 AX
	 POP	 BP
	 POP	 ES
	 POP	 DS	     ; DS NO LONGER USEABLE BY ME!
	 POPF		     ; RESTORE CALLER FLAGS
;
	 PUSH	 CS:OLDCS    ; NOW RETURN TO REAL EXIT
	 PUSH	 CS:OLDIP
	 RET
;
OLDVEC	 LABEL	 DWORD
OLDIP	 DW	 ?	     ; original INT IP values
OLDCS	 DW	 ?	     ; original INT CS values
CALLIP	 DW	 ?	     ; IP WE RETURN TO
CALLCS	 DW	 ?	     ; CS WE RETURN TO
CALLAX	 DW	 ?	     ; CALLER AX
CALLBX	 DW	 ?
CALLCX	 DW	 ?
CALLDX	 DW	 ?
CALLSI	 DW	 ?
CALLDI	 DW	 ?
CALLDS	 DW	 ?
CALLES	 DW	 ?
LASTINT  DB	 0	     ; LAST INT TRACED
LASTCS	 DW	 0	     ; CS FROM LAST INT TRACED
LASTIP	 DW	 0	     ; IP FROM LAST INT TRACED
LASTAX	 DW	 0	     ; AX FROM LAST INT TRACED
LASTPTR  DW	 0	     ; ADDRESS OF LAST TRACE ENTRY
DUMMY	 ENDP
;
;
; Hexprt - convert binary word to 2 hex words for printing
;
; Call with:	 AX = binary word
;	  SI - points to a 4 byte buffer to contain result
;
; Returns   SI = SI + 4
;
; Other registers unchanged
;
HEXPRT	 PROC NEAR
    PUSH CX   ;SAVE REGISTERS
    PUSH BX
;
    MOV  CX,4 ;SETUP FOR ROTATES, THRU LOOP 4 TIMES
    ROR  AX,CL	   ;INITIALIZE
ROLL:
    PUSH CX   ;SAVE LOOP COUNTER
    MOV  CL,4 ;SETUP FOR SHIFTS
    ROL  AX,CL	   ;GET NEXT CHAR
    MOV  BH,AH	   ;MOVE TO BH
    SHR  BH,CL	   ;GET HIGH-ORDER CHAR OF THIS BYTE
    POP  CX   ;RESTORE LOOP COUNTER
    CMP  BH,9 ;IS IT GT 9
    JG	 LTR  ;YES, JUMP TO LTR
    ADD  BH,048    ;MAKE IT ASCII
    MOV  [SI],BH   ;STORE THIS CHAR
    INC  SI
    LOOP ROLL ;GET NEXT CHAR
    JMP  HEXIT
LTR:	 ADD  BH,065	;MAKE IT ASCII
    SUB  BH,10
    MOV  [SI],BH   ;STORE THIS CHAR
    INC  SI
    LOOP ROLL ;GET NEXT CHAR
;
HEXIT:
    MOV  CL,4 ;RESTORE AX
    ROL  AX,CL	   ; TO ORIGINAL FORM
    POP  BX   ;RESTORE REGISTERS
    POP  CX
    RET       ;AND RETURN TO CALLER
HEXPRT	 ENDP
ENDOFME: NOP		     ; USED FOR INT 27H CALL
CSEG	 ENDS
	 END BEGCODE
