PROGRAM LillieforsGraphs;
{    This program does two things. It prints a graph that can be used to hand
  plot a sample CDF to perform the Lilliefors test for normality. It also
  reads data from disk or keyboard and performs the Lilliefors test, both
  graphically and algebraically. To do the test, there must be between 4
  and 255 pieces of data. See LILFOR.DOC for more information. }

{ This program is placed in the public domain by Joseph C. Hudson }

{$C-}
  CONST
    Limit = 255;

  TYPE
    Teen4 = STRING[14];
    InSet = SET OF CHAR;
    Three = STRING[3];
    Indices = ARRAY[1..15] OF Three;
    GridSize = ARRAY[0..719,0..49] OF BYTE;
    DataType = ARRAY[1..Limit] OF REAL;

  VAR
    Special, Op1, Op2, N : INTEGER;
    Key : CHAR;
    Index : Array[1..15] Of Three ;
    Grid : GridSize;
    Quantile : ARRAY[1..15] OF Real;
    Data: DataType;
    DCrit, ErrTol, S2Pi, DMax, WMax, XMax : Real ;
    Reject, DoneAlready : Boolean ;
    Y : Array[1..718] Of Real ;
    Digit : Array[0..9,1..5] Of Integer ;

Procedure SetUp ;
Var
   I, J, Code : Integer ;
   Dig1, Dig2 : String[50] ;
Begin
DoneAlready := False ;
N := 0 ; S2Pi := Sqrt(2.0 * Pi) ;
ErrTol := 0.5 * Exp( -4.0 * Ln(10.0)) * S2Pi ;
Dig1 := '06090909061404040604150204091407080608070404150505' ;
Dig2 := '07080701150609070106040404091406090609060608140906' ;
For I := 0 To 4 Do
   For J := 1 To 5 Do
   Begin
      Val(Copy(Dig1,10*I+2*J-1,2),Digit[I,J],Code) ;
      Val(Copy(Dig2,10*I+2*J-1,2),Digit[I+5,J],Code) ;
   End ; { For J }
End ; { SetUp }

Procedure Exchange (Var X1, X2 : Real) ;
Var Temp : Real ;
Begin
   Temp := X1 ;
   X1 := X2 ;
   X2 := Temp ;
End ; { Exchange }

Procedure Heap(I, N : Integer) ;
Begin
   While ( 2 * I + 1 <= N ) And
      ( ( Data[I] < Data[2*I] ) Or ( Data[I] < Data[2*I+1] ) ) Do
   Begin
      If Data[2*I] > Data[2*I+1] Then
      Begin
         Exchange(Data[I],Data[2*I]) ;
         I := 2 * I ;
      End  { Then }
      Else Begin
         Exchange(Data[I],Data[2*I+1]) ;
         I := 2 * I + 1 ;
      End ; { Else }
   End ; { While }
   If ( ( 2 * I = N ) And ( Data[I] < Data[2*I] ) )
      Then Exchange(Data[I],Data[2*I]) ;
End ; { Heap }

Procedure SortData ;
Var
   I, M : Integer ;
Begin
   ClrScr ; GoToXY(30,12) ;
   Write(Con,'<<< Sorting Data >>>') ;
   I := Trunc ( ( N / 2.0 ) + 0.1 ) ;
   While I >= 1 Do
   Begin
      Heap(I,N) ;
      I := I - 1 ;
   End ; { While }
   M := N ;
   While M > 1 Do
   Begin
      Exchange(Data[1],Data[M]) ;
      M := M - 1 ;
      Heap(1,M) ;
   End ; { While }
ClrScr ;
End ; { SortData }

  FUNCTION InKey(ValCar: InSet): CHAR;
    VAR
      Key: CHAR;
    BEGIN
      REPEAT
        READ(Kbd, Key);
        Key := UpCase(Key);
      UNTIL
        Key IN ValCar;
      IF Key = #8 THEN
        BEGIN
          Key := #255;
          WRITE(#8#32#8);
        END;
      InKey := Key;
    END;

  PROCEDURE InputLn(VAR Line: Teen4; VAR Count: INTEGER; Max: INTEGER; ValCar,Term: InSet; VAR Key: CHAR);
    BEGIN
      REPEAT
        READ(Kbd, Key);
        Key := UPCASE(Key);
        IF (Key IN ValCar) AND (Count < Max) THEN
          BEGIN
            WRITE(Key);
            Line := Line + Key;
            Count := Count + 1;
          END;
        IF (Key = #8) AND (Count >= 0) THEN
          BEGIN
            WRITE(#8#32#8);
            Delete(Line,LENGTH(Line),1);
            Count := Count - 1;
          END;
      UNTIL
        (Key IN Term) OR (Key = #13) OR ((Key = #8) AND (Count = -1));
      IF Count = -1 THEN
        Key := #255;
    END;

  PROCEDURE GetNum(VAR Number: REAL; VAR Key: CHAR);
    VAR
      Decimal: BOOLEAN;
      NumStr: STRING[14];
      Size,Count: INTEGER;
    BEGIN
      GotoXY(32,22); WRITE('X =             ');
      GotoXY(36,22); NumStr := '';
      Decimal := FALSE;
      Size := 0; Count := 0;
      REPEAT
        IF Size > 0 THEN
          Key := InKey(['0'..'9','.','-',#13,#8,#5,#27])
        ELSE
          Key := InKey(['0'..'9','.','-',#13,#5,#27]);
        CASE Key OF
              #255: BEGIN
                      Key := NumStr[LENGTH(NumStr)];
                      IF Key = '.' THEN
                        Decimal := FALSE
                      ELSE
                        IF Key IN ['0'..'9'] THEN
                          Count := Count - 1;
                      Delete(NumStr,LENGTH(NumStr),1);
                      Size := Size - 1;
                      Key := '@';
                    END;
               '.': IF NOT Decimal THEN
                      BEGIN
                        WRITE(Key);
                        NumStr := NumStr + Key;
                        Size := Size + 1;
                        Decimal := TRUE;
                      END;
               '-': IF Size = 0 THEN
                      BEGIN
                        WRITE(Key);
                        NumStr := NumStr + Key;
                        Size := Size + 1;
                      END;
          '0'..'9': IF Count < 10 THEN
                      BEGIN
                        WRITE(Key);
                        Size := Size + 1;
                        NumStr := NumStr + Key;
                        Count := Count + 1;
                      END
        END;
      UNTIL
        (Key IN [#5,#27]) OR ((Key = #13) AND (Count > 0));
      IF Key = #13 THEN
        Val(NumStr,Number,Size);
    END;

       PROCEDURE InputFile(VAR FileName: Teen4; VAR Key: CHAR);
         LABEL
           Jump1,Jump2,Jump3,Jump4;
         VAR
           I,J,K: INTEGER;
           Flag: BOOLEAN;
         BEGIN
Jump1:     GotoXY(28,10);
           WRITE('File name: ');
           Key := InKey(['A'..'Z',#27]);
           IF Key = #27 THEN
             Exit;
           FileName := Key;
           WRITE(FileName);
           K := 0;
Jump2:     InputLn(FileName,K,7,['0'..'9','A'..'Z'],['.',':',#27],Key);
           IF Key = #27 THEN
             Exit;
           IF Key = #255 THEN
             Goto Jump1;
             Flag := FALSE;
             IF Key = ':' THEN
             BEGIN
               WRITE(':');
               FileName := FileName + ':';
Jump3:         Key := InKey(['A'..'Z',#8,#27]);
               IF Key = #27 THEN
                 Exit;
               IF Key = #255 THEN
                 Goto Jump2;
               WRITE(Key);
               FileName := FileName + Key;
               I := 0;
Jump4:         InputLn(FileName,I,7,['0'..'9','A'..'Z'],['.',#27],Key);
               IF Key = #27 THEN
                 Exit;
               IF Key = #255 THEN
                 Goto Jump3;
                 Flag := TRUE;
             END;
             IF Key = '.' THEN
               BEGIN
                 WRITE('.');
                 FileName := FileName + '.';
                 J := 0;
                 InputLn(FileName,J,3,['0'..'9','A'..'Z'],[#27],Key);
                 IF Key = #27 THEN
                   Exit;
                 IF Key = #255 THEN
                   IF Flag THEN
                     Goto Jump4
                   ELSE
                     Goto Jump2;
               END;
         END;

     PROCEDURE InputNumber(VAR Number: INTEGER; VAR Key: CHAR);
       LABEL
         Back1, Back2, Back3;
       VAR
         NumStr: STRING[3];
         Code: INTEGER;
       BEGIN
Back1:   NumStr := '   ';
         NumStr[1] := InKey(['1'..'9',#27]);
         IF NumStr[1] <> #27 THEN
           BEGIN
             WRITE(NumStr[1]);
Back2:       IF NumStr[1] IN ['1'..'3'] THEN
               NumStr[2] := InKey(['0'..'9',#27,#8])
             ELSE
               NumStr[2] := InKey(['0'..'9',#27,#13,#8]);
             CASE NumStr[2] OF
                #27: Key := '@';
               #255: Goto Back1;
             ELSE
               WRITE(NumStr[2]);
             END;
Back3:       IF NOT (NumStr[2] IN [#13,#27]) THEN
               BEGIN
                 NumStr[3] := InKey(['0'..'9',#27,#13,#8]);
                 CASE NumStr[3] OF
                    #27: Key := '@';
                   #255: Goto Back2;
                 ELSE
                   BEGIN
                     WRITE(NumStr[3]);
                     Key := InKey([#13,#27,#8]);
                     CASE Key OF
                        #27: Key := '@';
                       #255: Goto Back3;
                     END;
                   END;
                 END;
               END;
           END
         ELSE
           Key := '@';
         Val(NumStr,Number,Code)
       END;

  FUNCTION Up2(Power: INTEGER): BYTE;
    VAR
      I: INTEGER;
      Result: BYTE;
    BEGIN
      Result := 1;
      I := 0;
      WHILE Power > I DO
        BEGIN
          Result := Result * 2;
          I := I + 1;
        END;
      Up2 := Result;
    END;

  PROCEDURE SaveData(VAR X: DataType; N: INTEGER);
    VAR
      Key: CHAR;
      I: INTEGER;
      OutFile: TEXT;
      FileName: Teen4;
    BEGIN
      ClrScr;
      GotoXY(26,12);
      IF N > 0 THEN
        BEGIN
          InputFile(FileName,Key);
          IF Key = #27 THEN
            Exit;
          ClrScr;
          GotoXY(26,12);
          WRITE('<<< Writing Data to Disk >>>');
          ASSIGN(OutFile, FileName);
          REWRITE(OutFile);
          FOR I := 1 TO N DO
          WRITELN(OutFile, X[I]:15:8);
          CLOSE(OutFile);
        END
      ELSE
        BEGIN
          WRITE('<<< Insufficent Data >>>');
          Delay(1000);
        END;
      ClrScr;
    END;

FUNCTION ConFrac(X: REAL): REAL;
    VAR
      X2, Term, Sum, ETol, Beta : REAL;
      Kount: INTEGER;
    BEGIN
      X2 := X * X ;
      Etol := ErrTol * X * Exp(X2/2.0) ;
      Term := 1.0 ;
      Sum := 1.0 ;
      Kount := 1;
      Beta := 1;
      WHILE ABS(Term) > Etol DO
        BEGIN
          Beta := 1.0 / (1.0 + Kount * Beta / X2);
          Term := (Beta - 1) * Term;
          Sum := Sum + Term;
          Kount := Kount + 1;
        END;
      ConFrac := 1 - Sum * Exp(-X2/2.0) / ( S2Pi * X );
    END;

  FUNCTION MacLauren(X: REAL): REAL;
    VAR
      X2, Term, Sum : REAL;
      Kount: INTEGER;
    BEGIN
      X2 := X * X;
      Term := X ;
      Sum := Term;
      Kount := 1;
      WHILE ABS(Term) > Errtol DO
        BEGIN
          Term := -Term * X2 * (2 * Kount - 1) / (2 * Kount * (2 * Kount + 1));
          Sum := Sum + Term;
          Kount := Kount + 1;
        END;
      MacLauren := 0.5 + Sum / S2Pi ;
    END;

FUNCTION Convert(St: Three): INTEGER;
  VAR
    Number, Code: INTEGER;
  BEGIN
    Val(St, Number, Code);
    Convert := Number;
  END;

  FUNCTION SampleSize(Number: INTEGER): REAL;
      VAR
        Table: ARRAY[1..4] OF STRING[81];
        Result: REAL;
      BEGIN
        IF Number < 31 THEN
          BEGIN
            Table[4] := '319299277258244233224217212202194187182177' +
                        '173169166163159155151147143139138137136';
            Table[3] := '352315294276261249239230223214207201195189' +
                        '184179174170166163160158156155152149144';
            Table[2] := '381337319300285271258249242234227220213206' +
                        '200195190186182179176173171168166164161';
            Table[1] := '417405364348331311294284275268261257250245' +
                        '239235231227222215208200197194191189187';
            Result := Convert(Copy(Table[Op1],1+3*(Number-4),3))/1000;
          END
        ELSE
          CASE Op1 OF
            1: Result := 0.768 / SQRT(Number);
            2: Result := 0.805 / SQRT(Number);
            3: Result := 0.886 / SQRT(Number);
          ELSE
             Result := 1.031 / SQRT(Number);
          END;
        SampleSize := Result;
      END;


  PROCEDURE PlotX(VAR X: DataType; N: INTEGER);
    VAR
      Lv, Lz, Z, V, I, J, K,Correct: INTEGER;
      StanDev, Xbar, X2sum, F, D : REAL;
      W: DataType;
      M: ARRAY[0..719] OF INTEGER;
    BEGIN
      Xbar := 0;
      X2sum := 0;
      Lv := 0;
      FOR I := 1 TO N DO
        BEGIN
          Xbar := Xbar + X[I];
          X2sum := X2sum + X[I] * X[I];
        END;
      Xbar := 1 / N * Xbar;
      StanDev := SQRT((X2sum - Xbar * Xbar * N) / (N - 1));
      FOR I := 1 TO N DO
        IF StanDev = 0 THEN
          W[I] := 0
        ELSE
          W[I] := (X[I] - Xbar) / StanDev;
      DMax := 0.0 ;
      For I := 1 To N Do
         Begin
         If Abs(W[I]) > 2.25
            Then F := ConFrac(Abs(W[I]))
            Else F := Maclauren(Abs(W[I])) ;
         If W[I] < 0.0 Then F := 1.0 - F ;
         D := Abs(F-(I-1)/N) ;
         If Abs(F-I/N) > D Then D := Abs(F-I/N) ;
         If D > DMax Then
            Begin
            DMax := D ;
            WMax := W[I] ;
            XMax := X[I] ;
            End ; { If }
      End ; { For }
      DCrit := SampleSize(N) ;
      If DMax > DCrit Then Reject := True Else Reject := False ;
      I := 1 ; J := 0 ; K := 0 ;
      Repeat
         While ((W[I]=W[I+1]) And (I<N)) Do I := I + 1 ;
         While (((-3.0+K/120.0)<W[I]) And (K<720)) Do
         Begin
            M[K] := J ;
            K := K + 1 ;
         End ; { While }
         J := I ; I := I + 1 ;
      Until ((I>N) Or (K=720)) ;
      If K <= 719 Then For J := K To 719 Do M[J] := N ;
      FOR I := 1 TO 718 DO
        BEGIN
          V := TRUNC(400 * (M[I] / N) + 0.5);
          Z := 1;
          FOR K := 1 TO (V MOD 8) DO
            Z := 2 * Z;
          IF V > Lv THEN
            FOR K := Lv TO V DO
              BEGIN
                Correct := (K DIV 8) MOD 50;
                IF Correct < 0 THEN
                  Correct := 0;
                Grid[I-1,Correct] := Grid[I-1,Correct] OR Up2(K MOD 8);
              END;
          Correct := (V DIV 8) MOD 50;
          IF Correct < 0 THEN
            Correct := 0;
          Grid[I,Correct] := Grid[I,Correct] OR Z;
          Lv := V;
        END;
    END;

  PROCEDURE DataEntry(VAR Data: DataType; VAR N: INTEGER);
    LABEL
      Jmp;
    VAR
      NextNum: BOOLEAN;
      Key: CHAR;
      Col,Row,J,I,K: INTEGER;
      FileName: Teen4;
      InFile: TEXT;
    BEGIN
Jmp:  ClrScr;
      GotoXY(35,10); WRITE('<1> Keyboard');
      GotoXY(35,12); WRITE('<2> Disk');
      GotoXY(35,14); WRITE('Input from: ');
      Key := InKey(['1','2',#27]); WRITE(Key);
      IF Key = #27 THEN
        Exit;
      ClrScr;
      IF Key = '2' THEN
        BEGIN
          InputFile(FileName,Key);
          IF Key = #27 THEN
            Goto Jmp;
          ASSIGN(InFile,FileName);
          {$I-} RESET(InFile); {$I+}
          IF IOResult <> 0 THEN
            BEGIN
              GotoXY(28-LENGTH(FileName) DIV 2,12);
              WRITELN(#7+'File ',FileName,' Can Not Be Located');
              Delay(4000);
              Exit;
            END;
          NextNum := TRUE;
          Col := 0;
          WHILE NOT EOLN(InFile) DO
            BEGIN
              READ(InFile,Key);
              IF (Key IN [#45,#46,#48..#57]) AND NextNum THEN
                BEGIN
                  Col := Col + 1;
                  NextNum := FALSE;
                END;
              IF NOT (Key IN [#45,#46,#48..#57]) THEN
                NextNum := TRUE;
            END;
          GotoXY(28,12); WRITELN('File contains ',Col,' column(s)');
          Row := 0;
          RESET(InFile);
          WHILE NOT EOF(InFile) DO
            BEGIN
              READLN(InFile,Key);
              Row := Row + 1;
            END;
          GotoXY(28,14); WRITELN('File contains ',Row,' row(s)');
          IF Col > 1 THEN
            BEGIN
              GotoXY(28,16);
              WRITE('Enter column containing X: ');
              READLN(Row);
            END
          ELSE
            BEGIN
              Row := 1;
              Delay(2000);
            END;
          ClrScr;
          N := 1;
          RESET(InFile);
          WHILE (NOT EOF(InFile)) AND (N <= Limit) DO
            BEGIN
              GotoXY(32,22); WRITE('                   ');
              GotoXY(32,22); WRITE('X = ');
              IF Row > 1 THEN
                FOR I := 1 TO (Row - 1) DO
{$I-}             READ(InFile, Data[N]);
{$I+}         IF NOT EOLN(InFile) THEN
                REPEAT
{$I-}             READLN(InFile, Data[N]);
{$I+}           UNTIL
                  IOResult = 0;
              WRITELN(Data[N]:-8:4);
              GotoXY(4+25*(((N - 1) DIV 20) MOD 3),1 + (N - 1) MOD 20);
              WRITE(N:3,'. ',Data[N]:16:4);
              N := N + 1;
            END;
          CLOSE(InFile);
          N := N - 1;
        END
      ELSE
        BEGIN
          N := 0;
          GotoXY(30,24); WRITE('Type Ctrl-E to Exit');
          REPEAT
            N := N + 1;
            GetNum(Data[N], Key);
            GotoXY(4+25*(((N - 1) DIV 20) MOD 3),1 + (N - 1) MOD 20);
            WRITE(N:3,'. ',Data[N]:16:4);
          UNTIL
            (Key IN [#5,#27]) OR (N = Limit);
          N := N - 1;
        END;
      IF N > (Limit - 1) THEN
        BEGIN
          GotoXY(25,22); WRITE('Maximum Amount of Data Entered');
          Delay(2000);
        END;
    END;

    PROCEDURE MiniMenu(VAR Op1,Op2: INTEGER);
      LABEL
        Bran1, Bran2;
      BEGIN
Bran1:  ClrScr;
        GotoXY(37,8);  WRITE('<1> 99%');
        GotoXY(37,10); WRITE('<2> 95%');
        GotoXY(37,12); WRITE('<3> 90%');
        GotoXY(37,14); WRITE('<4> 85%');
        GotoXY(30,16); WRITE('Select confidence level: ');
        Key := InKey(['1'..'4',#27]);
        IF Key = #27 THEN
          Exit;
        WRITELN(Key);
        Op1 := ORD(Key) - ORD('0');
Bran2:  IF N > 3 THEN
          BEGIN
            ClrScr;
            GotoXY(26,10); WRITE('<1> 5, 10, 15, 20, 30, 50, 100');
            GotoXY(26,12); WRITE('<2> ',N);
            GotoXY(25,14); WRITE('Plot confidence bound curve(s): ');
            Key := InKey(['1','2',#27]); WRITELN(Key);
            IF Key = #27 THEN
              Goto Bran1;
            Op2 := ORD(Key) - ORD('1');
            Key := '@';
          END
        ELSE
          BEGIN
            ClrScr;
            GotoXY(26,10); WRITE('<1> 5, 10, 15, 20, 30, 50, 100');
            GotoXY(26,12); WRITE('<2> N');
            GotoXY(25,14); WRITE('Plot confidence bound curve(s): ');
            Key := InKey(['1','2',#27]); WRITELN(Key);
            IF Key = #27 THEN
              Goto Bran1;
            IF Key = '2' THEN
              BEGIN
                GotoXY(25,16); WRITE('Enter N value: ');
                InputNumber(Special,Key);
                IF Key = '@' THEN
                  Goto Bran2;
              END;
            Op2 := ORD(Key) - ORD('1');
            Key := '@';
          END;
      END;

  PROCEDURE ScreenMenu;
    BEGIN
      ClrScr;
      GotoXY(20,4);  WRITE('LILLIEFORS TEST FOR NORMALITY');
      GotoXY(29,8);  WRITE('<A> Enter data');
      GotoXY(29,10); WRITE('<B> Save data to disk');
      GotoXY(29,12); WRITE('<C> Print graph');
      GotoXY(29,14); WRITE('<D> Exit program');
      GotoXY(29,16); WRITE('Selection: ');
      Key := InKey(['A'..'D']); WRITELN(Key);
      CASE Key OF
        'A': Begin DataEntry(Data, N); SortData ; End ;
        'B': SaveData(Data, N);
        'C': IF (N = 0) OR (N > 3) THEN
               MiniMenu(Op1,Op2)
             ELSE
               BEGIN
                 ClrScr;
                 GotoXY(30,12);
                 WRITE('Insufficent Data to Plot');
                 Delay(2000);
                 Key := 'B';
               END;
      END;
    END;

  PROCEDURE FillIndex ;
    VAR
      I: INTEGER;
    BEGIN
      IF Op2 = 0 THEN
          BEGIN
            Index[01] := '5';     Index[02] := '10';
            Index[03] := '15';    Index[04] := '20';
            Index[05] := '30';    Index[06] := '50';
            Index[07] := '100';
          END
      ELSE
        BEGIN
          FOR I := 1 TO 6 DO
            Index[I] := '';
          IF N > 3 THEN
            Str(N,Index[7])
          ELSE
            Str(Special,Index[7]);
        END;
      FOR I := 1 TO 7 DO
        Index[16 - I] := Index[I];
    END;

  PROCEDURE PlotGrid ;
    VAR
      I,X,Y: INTEGER;
    BEGIN
      FOR Y := 0 TO 49 DO
        Grid[0,Y] := 0;
      FOR X := 1 TO 719 DO
        Grid[X] := Grid[0];
      FOR Y := 0 TO 49 DO
        BEGIN
          Grid[0,Y]   := 255;
          Grid[719,Y] := 255;
        END;
      FOR I := 1 TO 11 DO
        FOR Y := 0 TO 49 DO
          Grid[I*60,Y] := 17;
      FOR X := 0 TO 719 DO
        BEGIN
          Grid[X,49] := Grid [X,49] OR 128;
          Grid[X,0] := Grid[X,0] OR 1;
        END;
      FOR Y := 1 TO 9 DO
        FOR X := 0 TO 143 DO
          Grid[X*5,Y*5] := Grid[X*5,Y*5] OR 1;
    END;

   Procedure PlotPoint(I,U : Integer ; Var V : Integer) ;
   Var
      J, W, Z, Z2 : Integer ;
      PlotY : Real ;
   Begin
   PlotY := Y[U] + Quantile[I];
   If ((PlotY > 0.0) AND (PlotY < 1.0)) Then
       BEGIN
       V := TRUNC(400.0 * PlotY + 0.5);
       W := (V DIV 8) MOD 50;
       Z := 1;
       Z2 := V MOD 8;
       FOR J := 1 TO Z2 DO Z := Z * 2;
       Grid[U,W] := Grid[U,W] OR Z;
    End ; { If }
    End ; { PlotPoint }

Procedure WriteLabel(I, U, V, Len : Integer) ;
Var
   Col, J, K, L, Row, Test, Test2, W, Z, Z2, Z3 : Integer ;
Begin
Col := U + 3 ; Row := V - 2 ;
For J := 1 To Len DO
   Begin
   For K := Row To Row + 4 Do
      Begin
      W := ( K Div 8 ) Mod 50 ;
      Z2 := K Mod 8 ; Z := 1 ;
      For L := 1 To Z2 Do Z := Z * 2 ; Test := 1 ;
      For L := Col To Col + 3 Do
         Begin
         If L > Col Then Test := Test * 2 ;
         Test2 := Test And Digit[Integer(Copy(Index[I],J,1))-48,K+1-Row];
         If Test2 = 0 Then Z3 := 0 Else Z3 := Z ;
         Grid[L,W] := Grid[L,W] Or Z3 ;
      End ; { For L }
   End ; { For K }
   Col := Col + 5 ;
End ; { For J }
End ; { WriteLabel }

  PROCEDURE PlotCurves ;
    VAR
      EndLabelCol, I, LabelCol, Len, LenLabel, U, V : INTEGER;
      PlotY,X: REAL;
      Table: ARRAY[1..5] OF STRING[21];

    BEGIN
      FOR I := 1 TO 7 DO
        IF Index[I] <> '' THEN
          BEGIN
            Quantile[I] := SampleSize(Convert(Index[I]));
            Quantile[16 - I] := 0 - Quantile[I];
          END;
      Quantile[8] := 0; Index[8] := ' ';
      If Not DoneAlready Then FOR U := 1 TO 718 DO
      BEGIN
         X := -3.0 + 6.0 * U / 720;
         IF ABS(X) < 2.25 THEN Y[U] := MacLauren(ABS(X))
            ELSE Y[U] := ConFrac(ABS(X));
         IF (X < 0.0) THEN Y[U] := 1.0 - Y[U] ;
      End ; { For }
      DoneAlready := True ;
        FOR I := 1 TO 15 DO
           Begin
           IF Index[I] <> '' THEN
              BEGIN
              Len := Length(Index[I]) ;
              LenLabel := 5 * Len + 1 ;
              If I < 8 Then LabelCol := 8 Else LabelCol := 708 - LenLabel ;
              EndLabelCol := LenLabel + LabelCol + 1 ;
              If I = 8 Then EndLabelCol := 0 ;
              If I <> 8 Then For U := 1 To LabelCol Do PlotPoint(I,U,V) ;
              If I <> 8 Then WriteLabel(I,LabelCol,V,Len) ;
              For U := EndLabelCol + 3 To 718 Do PlotPoint(I,U,V) ;
           End ; { If }
        End ; { For }
    End ; { PlotCurves }

  PROCEDURE GraphTitle(Option: INTEGER ; Var Sig : Integer);
    VAR
      I : INTEGER;
    BEGIN
      FOR I := 0 TO 7 DO WRITELN(Lst);
      CASE Option OF
        1: Sig := 99 ;
        2: Sig := 95 ;
        3: Sig := 90 ;
      ELSE
        Sig := 85 ;
      END;
      Write(Lst,Sig:30) ;
      WRITELN(Lst, '% Lilliefors Bounds for Normal Samples');

      FOR Option := 1 TO 5 DO
        WRITELN(Lst);
    END;

  PROCEDURE InitPrinter;
    BEGIN
      WRITELN(Lst, #27#64);            {Initialize printer}
      Writeln(Lst, #27#51#24) ;        {line spacing 8/72 in for Epson }
    { WRITELN(Lst, #27#65#8); }        {line spacing is 8/72 in for Star}
      WRITELN(Lst, #27#77);            {elite pitch, 12 char/in for Epson }
    { Writeln(Lst, #27#66#2) ; }       {elite pitch, 12 char/in for Star  }
    END;

  PROCEDURE PrintGraph ;
    VAR
      A, I, J, Sig: INTEGER;
    BEGIN
      {$U+}
      GraphTitle(Op1,Sig);
        BEGIN
          FOR I := 49 DOWNTO 0 DO
            BEGIN
              IF (I > 10) AND (I < 40) THEN
                WRITE(Lst, Copy('CUMULATIVE RELATIVE FREQUENCY', 30 - (I - 10), 1):6)
              ELSE
                WRITE(Lst, ' ':6);
              IF I = 49 THEN
                WRITE(Lst, '1.0 ':6)
              ELSE
                IF (I MOD 5) = 0 THEN
                  WRITE(Lst, ' .':4, I DIV 5, ' ')
                ELSE
                  WRITE(Lst, '    ':6);

             {set printer for 8 lines of 720 dots @ 120 dots per inch}

              WRITE(Lst, #27#76#208#2);

             {send the 720 8 dot columns comprising a line to the printer}

              FOR J := 0 TO 719 DO WRITE(Lst, CHR(Grid[J,I]));
              Writeln(Lst) ;
            END;
          WRITELN(Lst);
          WRITELN(Lst,-3:13,-2:12,-1:12,0:12,1:12,2:12,3:12);
          WRITELN(Lst); WRITELN(Lst);
          WRITELN(Lst, 'STANDARDIZED SAMPLE VALUE':60);
          If N > 4 Then
            Begin
            Writeln(Lst,#27#51#36) ;     {6 lines per inch for Epson }
            WRITELN(Lst, #27#77);        {elite pitch, 12 char/in for Epson }
            { Writeln(Lst, #27#66#2) ; } {elite pitch, 12 char/in for Star  }
            Writeln(Lst) ; Writeln(Lst) ;
            Write(Lst,' ':9,'The maximum distance between ') ;
            Writeln(Lst,'the Normal and sample CDFs is ',DMax:5:4,'.');
            Write(Lst,' ':9,'This maximum occurs at z = ',WMax:6:4,', x = ') ;
            Writeln(Lst,XMax,'.') ;
            Write(Lst,' ':9,'The hypothesis of normality is ') ;
            If Reject = True
               Then Write(Lst,'rejected at the ',100-Sig)
               Else Write(Lst,'not rejected at the ',100-Sig) ;
            Writeln(Lst,'% significance level.') ;
            Writeln(Lst,' ':9,'The critical distance is ',DCrit:5:3,'.') ;
         End ; { If }
         Writeln(Lst,#12,#27,#64) ;
        END;
    END;

  BEGIN
    SetUp ;
    REPEAT
      Special := 0;
      ScreenMenu;
      IF Key = '@' THEN
        BEGIN
          ClrScr;
          FillIndex ;
          PlotGrid ;
          GotoXY(27,11); WRITE('<<< Generating Graph >>>');
          PlotCurves ;
          IF N > 4 THEN
            PlotX(Data,N) ;
          ClrScr;
          GotoXY(30,12); WRITE('<<< Printing Graph >>>');
          GotoXY(40,14) ;
          InitPrinter ;
          PrintGraph ;
        END;
    UNTIL
      Key = 'D';
    ClrScr;
  END.
