;
;  File: MEINIT.ASM
; 
;  This file can be used as a starting point for an initialization
; routine file Metal/Z-Msg versions 1.31 and later..
;
;  This is an entirely optional insert file.
;
;  An initialization routine is handy for setting up other remote
; access system programs (eg. bye).  The following information is
; passed to this routine from the message system:
;
;	. Whether or not BYE is active
;	. a pointer to the 'user structure' which contains the user
;	  name, where they are from, etc..
;	. a pointer to the 'user status' parameter block coresponding
;	  to the current user.  This will give things like the max
;	  amount of time allowed on the system, max user, max drive, etc..
;
;   The init routine is called after the user name and password have
; been verified by the system.
;
; *** This routine must not excede 251 bytes in length !! ***
;				   ===

	org	384h		; fixed location to put it at..

	db	0ffh		; flag to tell message system init routine
				; is installed...
bye:	db	00		; passed flag if bye is active..
user:	dw	0000		; pointer to user structure
status:	dw	0000		; pointer to user status info
	db	00,00,00,00,00,00	; reserved for later..

; The following are offsets from 'user' above

unumber	equ	0	; user number (also seek pos into users file) (2 bytes)
ufirst	equ	2	; first name of user          (0 terminated string)
ulast	equ	17	; last name of user           (0 terminated string)
upass	equ	38	; password                    (0 terminated string)
udate	equ	47	; date last logged on         (0 terminated string)
utime	equ	56	; time last logged on         (0 terminated string)
ucity	equ	65	; city of user                (0 terminated string)
ulastrd	equ	94	; message at last login               (2 bytes)
ustatus	equ	96	; user status character (+snXxabc)    (1 byte)
ujmpos	equ	99	; auto jump to OS on login? ('1'=yes) (1 byte)
ubell	equ	101	; bell enabled? ('1'=yes)             (1 byte)
urp	equ	102	; auto read on login? ('1'=yes)       (1 byte) 
unulls	equ	104	; nulls                               (1 byte)
uheight	equ	105	; terminal height                     (1 byte)
uwidth	equ	106	; terminal width                      (1 byte)
uupload	equ	109	; upload file count   (2 byte) --not used yet--
udnload	equ	111	; download file count (2 byte) --not used yet--
umins	equ	113	; minutes on today    (1 byte) --not used yet--
ucalls	equ	117	; unsigned number of calls            (2 byte)
udef	equ	124	; You can actually use these locs..   (124-127)

; The following offsets are from 'status' above...

sstatus	equ	0	; status char (+snXxabc)
smaxdrv	equ	1	; max drive
smaxusr	equ	2	; max user
sacttout equ	3	; activity timeout in mins (timeout if not typing)
skillflg equ	4	; kill messages flag..
szcprflg equ	5	; wheel privs?
sreadprv equ	6	; read private msgs?
spostmsg equ	7	; allowed to post messages?
stimeout equ	8	; logoff timeout in minutes
sz3flags equ	9	; 2 byte commands file flag (zcpr3 only)


;  *********************************************************
; * Insert your routine here..  IT MUST PRESERVE REGISTERS  *
;	  v   v   v   v   v   v   v   v   v   v   v   


;
;
	ret		; simple return ends routine

; Last byte in routine must not be at an address over 047FH...
