CODESEG  segment para public 'code'
         assume cs:CODESEG,ds:CODESEG
;
         public stroke_
         public strokel_
stroke   proc  near
stroke_  label near
         mov   cs:svflag,0
         jmp   short start
strokel_ label far
         mov   cs:svflag,1
         jmp   short start
svstkoff dw    0
svstkseg dw    0
svoldoff dw    0
svoldseg dw    0
svnewoff dw    0
svnewseg dw    0
svax     dw    0
svbx     dw    0
svcx     dw    0
svdx     dw    0
svbp     dw    0
svsi     dw    0
svdi     dw    0
sves     dw    0
svds     dw    0
svflag2  dw    0
svcount  dw    0
svflag   db    0
stksegl  equ   1eh                ; parm5 (large)      +1eh
stkoffl  equ   1ch                ; parm4 (large)      +1ch
rtnsegl  equ   1ah                ; parm3 (large)      +1ah
stkoffs  equ   18h                ; parm3 (small) +18h
rtnoffl  equ   18h                ; parm2 (large)      +18h
rtnoffs  equ   16h                ; parm2 (small) +16h
flag2l   equ   16h                ; parm1 (large)      +16h
flag2s   equ   14h                ; parm1 (small) +14h
                                  ; cs =               +14h
start:                            ; ip = +12h
         push  ds                 ; ds = +10h
         push  es                 ; es = +0eh
         push  di                 ; di = +0ch
         push  si                 ; si = +0ah
         push  bp                 ; bp = +08h
         push  dx                 ; dx = +06h
         push  cx                 ; cx = +04h
         push  bx                 ; bx = +02h
         push  ax                 ; ax = +00h
         mov   bp,sp
         push  cs
         pop   ds
;
         mov   bx,[bp+flag2l]
         cmp   svflag,0
         jne   cont56
         mov   bx,[bp+flag2s]
cont56:
         test  bx,bx
         jnz   cont1
         jmp   restore
cont1:
;
         mov   ax,3509h           ; Get old keyboard int9 vector
         int   21h                ;    and save information in saveint
         mov   svoldseg,es
         mov   svoldoff,bx
;
         cmp   svflag,0
         jne   short cont17a
;
;                                 ; get parms from small model
         mov   svnewseg,cs
         mov   ax,[bp+rtnoffs]
         mov   svnewoff,ax
         mov   ax,[bp+flag2s]
         mov   svflag2,ax
         mov   ax,[bp+10h]
         mov   svstkseg,ax
         mov   ax,[bp+stkoffs]
         mov   svstkoff,ax
         jmp   short cont17b
cont17a:
         mov   ax,[bp+rtnsegl]    ; get parms from large model
         mov   svnewseg,ax
         mov   ax,[bp+rtnoffl]
         mov   svnewoff,ax
         mov   ax,[bp+flag2l]
         mov   svflag2,ax
         mov   ax,[bp+stksegl]
         mov   svstkseg,ax
         mov   ax,[bp+stkoffl]
         mov   svstkoff,ax
cont17b:
         mov   ax,[bp+10h]
         mov   svds,ax
         mov   ax,[bp+0eh]
         mov   sves,ax
         mov   ax,[bp+0ch]
         mov   svdi,ax
         mov   ax,[bp+0ah]
         mov   svsi,ax
         mov   ax,[bp+08h]
         mov   svbp,ax
         mov   ax,[bp+06h]
         mov   svdx,ax
         mov   ax,[bp+04h]
         mov   svcx,ax
         mov   ax,[bp+02h]
         mov   svbx,ax
         mov   ax,[bp+00h]
         mov   svax,ax
         xor   ax,ax
         mov   svcount,ax
;
         mov   dx,offset stk2     ; Set new clock interrupt
         mov   ax,2509h           ;    int9
         int   21h
         jmp   short strkret
;
restore:                          ; Reset clock speed
         mov   dx,svoldoff
         mov   ds,svoldseg
         mov   ax,2509h           ;    int9
         int   21h
strkret:
         pop   ax
         pop   bx
         pop   cx
         pop   dx
         pop   bp
         pop   si
         pop   di
         pop   es
         pop   ds
         cmp   cs:svflag,0
         je    retn
         db    0cbh               ; far return
retn:
         db    0c3h               ; near return
stroke   endp
;
;
stk2     proc  near
                                  ; flags = +16h
                                  ; cs = +14h
                                  ; ip = +12h
         push  ds                 ; ds = +10h
         push  es                 ; es = +0eh
         push  di                 ; di = +0ch
         push  si                 ; si = +0ah
         push  bp                 ; bp = +08h
         push  dx                 ; dx = +06h
         push  cx                 ; cx = +04h
         push  bx                 ; bx = +02h
         push  ax                 ; ax = +00h
         mov   bp,sp
         push  cs
         pop   ds
;
         cli
         in    al,21h             ; Disable the keyboard interrupt
         or    al,2
         out   21h,al
         mov   stk2ss,ss
         mov   stk2sp,sp
         mov   ss,svstkseg
         mov   sp,svstkoff
         mov   ax,svax
         mov   bx,svbx
         mov   cx,svcx
         mov   dx,svdx
         mov   bp,svbp
         mov   si,svsi
         mov   di,svdi
         mov   es,sves
         mov   ds,svds
;
         in    al,60h
         push  ax
         cmp   cs:svflag,0
         jne   cont18
         call  word ptr cs:[svnewoff]
         jmp   short cont19
cont18:  call  dword ptr cs:[svnewoff]
cont19:
         pop   ax
;
         push  cs
         pop   ds
         pushf
         call  dword ptr [svoldoff]
;
stk2ret:
         cli
         db    0b8h               ; mov ax,
stk2ss   dw    0000
         mov   ss,ax
         db    0bch               ; mov sp,
stk2sp   dw    0000
         in    al,21h             ; Re-enable the keyboard interrupt
         and   al,0fdh
         out   21h,al
         sti
         pop   ax
         pop   bx
         pop   cx
         pop   dx
         pop   bp
         pop   si
         pop   di
         pop   es
         pop   ds
         iret
stk2     endp
;
CODESEG  ends
         end   stroke
