        NAME    PDISKIO
        PAGE    60,132
;****************************************************************;
;                                                                ;
;       PHYSICAL DISK I/O                                        ;
;                                                                ;
;****************************************************************;

_TEXT   SEGMENT  BYTE PUBLIC 'CODE'
_TEXT   ENDS
CONST   SEGMENT  WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT  WORD PUBLIC 'BSS'
_BSS    ENDS
_DATA   SEGMENT  WORD PUBLIC 'DATA'
_DATA   ENDS
DGROUP  GROUP   CONST,  _BSS,   _DATA
        ASSUME  CS: _TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP

_TEXT           SEGMENT

;****************************************************************;
;                                                                ;
;       char                                                     ;
;       disk_io(cmd, drive, buf, count, sector, head, cylinder)  ;
;                4     6     8     10     12     14     16       ;
;****************************************************************;

                PUBLIC  _DISK_IO
_DISK_IO        PROC    NEAR

        PUSH    BP                              ; SAVE FRAME
        MOV     BP, SP                          ; MAKE NEW FRAME
        PUSH    ES                              ;
        PUSH    SI                              ;
        PUSH    DI                              ;
        MOV     AH, [BP+4]                      ; PICK UP COMMAND
        MOV     DL, [BP+6]                      ; PICK UP DRIVE
        MOV     BX, [BP+8]                      ; PICK UP BUFFER
        PUSH    DS                              ;
        POP     ES                              ;
        MOV     AL, [BP+10]                     ; PICK UP COUNT
        MOV     DH, [BP+14]                     ; PICK UP HEAD
        MOV     CH, [BP+17]                     ; HIGH CYL BITS
        SHR     CX, 1                           ; SHF 2 MSB TO CL
        SHR     CX, 1                           ;
        AND     CL, 0C0H                        ; MASK THEM
        ADD     CL, [BP+12]                     ; ADD IN SECTOR
        INC     CL                              ; PLUS ONE
        MOV     CH, [BP+16]                     ; REST CYL IN CH
        INT     13H                             ; CALL BIOS
        JC      SAVERR                          ; JUMP IF ERROR
        MOV     AH, 0                           ; CLEAR RESULT
        CMP     BYTE PTR [BP+4], 8              ; DRIVE PARAM CMD
        JNE     SAVERR                          ; JUMP IF NOT
        MOV     BX, [BP+8]                      ; RESULTS IN BUF
        MOV     [BX], CL                        ; SECTORS
        AND     BYTE PTR [BX], 03FH             ;
        MOV     BYTE PTR [BX+1], 0              ;
        INC     DH                              ;
        MOV     [BX+2], DH                      ; HEADS
        MOV     BYTE PTR [BX+3], 0              ;
        MOV     [BX+4], CH                      ; CYLINDERS
        SHL     CX, 1                           ;  FIX HIGH BYTE
        SHL     CX, 1                           ;
        AND     CH, 003H                        ;
        MOV     [BX+5], CH                      ;
        MOV     [BX+6], DL                      ; DRIVES
        MOV     BYTE PTR [BX+7], 0              ;
SAVERR: MOV     AL, AH                          ; RESULT IN AX
        MOV     AH, 0                           ;
        POP     DI                              ; RESTORE REGS
        POP     SI                              ;
        POP     ES                              ;
        POP     BP                              ; RESTORE FRAME
        RET                                     ; RETURN

_DISK_IO        ENDP

;****************************************************************;
;                                                                ;
;       Get the current BIOS clock tick count                    ;
;                                                                ;
;       long ticks();                                            ;
;                                                                ;
;****************************************************************;

                PUBLIC  _TICK
_TICK           PROC    NEAR

        PUSH    BP                              ; SAVE FRAME
        MOV     BP, SP                          ; MAKE NEW FRAME
        PUSH    ES                              ;
        MOV     AX, 0                           ; CLEAR ES TO
        MOV     ES, AX                          ; GET BIOS DATA
        CLI                                     ; DISABLE INTS
        MOV     AX, ES:WORD PTR [046CH]         ; LOW TICK COUNT
        MOV     DX, ES:WORD PTR [046EH]         ; HIGH TICK COUNT
        STI                                     ; ENABLE INTS
        POP     ES                              ; RESTORE REGS
        POP     BP                              ; RESTORE FRAME
        RET                                     ; RETURN

_TICK           ENDP

;****************************************************************;

_TEXT   ENDS

        END
