;	disktest.asm - assembler functions for
;	disk I/O performance benchmark
;	assumes the small memory model is used

;	compiler-dependent definitions
;	Lattice C version
Pgroup	group	prog
Dgroup	group	data
	assume  cs:pgroup,ds:dgroup
dstart	equ	dgroup
Data	segment	word public 'DATA'
Data	ends
Prog	segment	byte public 'PROG'
;	end of Lattice C version


;	rawread(drive,nsec,begin_sec,buffer) - reads raw disk sectors
;		drive     = drive number 0=A  , 1=B ...
;		nsec      = number of sectors (512 bytes) to read
;		begin_sec = number of first logical sector to read
;		buffer    = store the data read here
;			    (relative to DS)

;	define the argument offsets relative to BP
;	old BP value is at zero
;	return address is at 2
drive	equ	4
nsec	equ	6
begsec	equ	8
buffer	equ    10

	public  rawread,rawread_,_rawread
rawread:
rawread_:
_rawread:	push	bp
	mov	bp,sp
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	mov	ax,word ptr [bp+drive]
	mov	cx,word ptr [bp+nsec]
	mov	dx,word ptr [bp+begsec]
	mov	bx,word ptr [bp+buffer]
	int	25H		; absolute disk read
	pop	cx		; discard original flags
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	jc	raw1		; did the operation succeed ?
	mov	ax,0		;    yes - set ax=0
	jmp	raw2
				;    no  - force ax to be non-zero.
raw1:
	or	ax,ax		; is AX already non-zero ?
	jnz	raw2		;    yes - just use it as an error return
	mov	ax,255		;    no  - fake a non-zero error return.
raw2:
	pop	bp
	ret


;	get_ds()  - returns the data segment address
	public get_ds,get_ds_
get_ds:
get_ds_:
_get_ds:
	mov	ax,ds
	ret


;	long gettime() - returns time 
	public	gettime,gettime_,_gettime
gettime:
gettime_:
_gettime:
	push	cx
	push	dx
	mov	ax,0		; read clock function
	int	1AH		; time of day BIOS call	
;	now set up the return value
;	Lattice C version - long return = (AX-high , BX-low)
	mov	ax,cx		; move high order word to AX
	mov	bx,dx		; move low order word to BX
;	for C.I. C86 and others - long return = (DX-high , AX-low)
;	mov	ax,dx
;	mov	dx,cx
	pop	dx
	pop	cx
	ret


;	getspac(ddrive,pfree,ptot,pbytes) - get disk free space info
;	ddrive - drive number ( 0=A , 1=B ... )
;	pfree - store no. free clusters here
;	ptot  - store no. clusters total here
;	pbytes- store number of bytes per sector here
;	returns no. sectors per cluster (or 0xFFFF for invalid drive)

;	define argument offsets
;	old BP = 0
;	return address = 2
ddrive	equ	4
pfree	equ	6
ptot	equ	8
pbytes	equ    10

	public	getspac,getspac_,_getspac
getspac:
getspac_:
_getspac:
	push	bp
	mov	bp,sp
	push	bx
	push	cx
	push	dx
	push	si
	mov	dx,word ptr [bp+ddrive]
	mov	ah,36H		; PC-DOS get free space call
	int	21H
	mov	si,word ptr [bp+pfree] ; store free clusters value
	mov	word ptr [si],bx
	mov	si,word ptr [bp+ptot]  ; store total clusters value
	mov	word ptr [si],dx
	mov	si,word ptr [bp+pbytes] ; store bytes/sector value
	mov	word ptr [si],cx
					; sectors/cluster already in AX
	pop	si		; restore registers
	pop	dx
	pop	cx
	pop	bx
	pop	bp
	ret

;	compiler dependent stuff for end of code segment
;	Lattice C version
Prog	ends
;	end of Lattice C version

	end
