PROGRAM Life;  { John Conway's math past-time }

{

  Written by:

  Ron Sharp (Life Routines)
  Timothy Campbell (Graphics and Soup Recipe)

}

{ You may  distribute this,  change it,  sell it for big bucks,  or do }
{ anything you want.   You have our  permission  and our  best wishes. }

CONST
  Xsize    = 249;
  Ysize    = 149;
  MaxCells = 6000;
  StartNum = 1500;
  Xoff     = 10;

TYPE
  CellArray = RECORD
    Xpos   : Byte;
    Ypos   : Byte;
  END;

VAR
  Board    : Array[0..Xsize,0..Ysize] of Byte;
  Ch       : CHAR;
  Cells    : Array[0..1,1..MaxCells] of CellArray;
  LineCntr : Integer;
  NumCells : Integer;
  NumCellq : Integer;
  x,y,z,q  : Integer;
  v        : Integer;
  w        : Boolean;
  Gen      : Integer;

{========== GRAPHICS PROCEDURES ==========}

{ HGraf(0 or 1)             - Hercules Graphics Off (Text) or On (720x348)
                              (Replaces Turbo-Pascal HIRES and TEXTMODE)
  HClrScr(0 or 1)           - Clear screen memory for Text or Graphics
  HPlot(X,Y,0 or 1)         - Point X,Y Off or On (X IN [0..719]  Y IN [0..347]
                              (Replaces Turbo-Pascal PLOT)
  HDraw(X1,Y1,X2,Y2,0 or 1) - Erases or draws a line from X1,Y1 to X2,Y2
                              (Replaces Turbo-Pascal DRAW)                 }


PROCEDURE HClrScr(HSwitch : BYTE);
VAR
  MemFill : BYTE;
  Screen  : INTEGER ABSOLUTE $B000 : $0000;
BEGIN
  IF HSwitch = 1
  THEN MemFill := $0000
  ELSE MemFill := $0720;
  FillChar(Screen,$7FFF,MemFill);
END;

PROCEDURE HGraf(HSwitch : BYTE);
CONST
  Tables : ARRAY[0..13,0..1] OF BYTE =
           ( ($35,97),($2D,80),($2E,82),($07,15),($5B,25),($02,06),
             ($57,25),($57,25),($02,02),($03,13),($00,11),($00,12),
             ($00,00),($00,00) );
VAR
  HItem  : BYTE;
  HCtrl : BYTE;
BEGIN
  IF HSwitch = 1
  THEN HCtrl := $02
  ELSE HCtrl := $20;
  PORT[$3B8] := HCtrl;
  {--- Initialize the 6845 ---}
  FOR HItem := 0 TO 13 DO
  BEGIN
    PORT[$3B4] := HItem;
    PORT[$3B5] := Tables[HItem,1-HSwitch];
  END;
  HClrScr(HSwitch);
  PORT[$3B8] := HCtrl OR $08;
END;

PROCEDURE HPlot(XByte,YByte : INTEGER; HSwitch : BYTE);
CONST
  HBits : ARRAY[0..7] OF BYTE = (128,64,32,16,8,4,2,1);
VAR
  HOfs  : INTEGER;
BEGIN
  HOfs := (YByte MOD 4 * $2000)
          + (YByte DIV 4 * 90)
          + (XByte DIV 8);
  IF HSwitch = 1
  THEN MEM[$B000:HOfs] := MEM[$B000:HOfs] OR HBits[XByte MOD 8]
  ELSE MEM[$B000:HOfs] := MEM[$B000:HOfs] AND (NOT HBits[XByte MOD 8]);
END;

FUNCTION HStep(C1,C2 : INTEGER) : INTEGER;
BEGIN
  IF C1 = C2
  THEN HStep := 0
  ELSE
  BEGIN
    IF C1 < C2
    THEN HStep := 1
    ELSE HStep := -1;
  END;
END;

PROCEDURE HDraw(X1,Y1,X2,Y2 : INTEGER; HSwitch : BYTE);
VAR
  MaxDist   : INTEGER;
  PtCnt     : INTEGER;
  XCnt      : INTEGER;
  XDist     : INTEGER;
  XJump     : INTEGER;
  XStep     : INTEGER;
  YCnt      : INTEGER;
  YDist     : INTEGER;
  YJump     : INTEGER;
  YStep     : INTEGER;

BEGIN
  IF X1 < 0 THEN X1 := 0;  IF X1 > 719 THEN X1 := 719;
  IF Y1 < 0 THEN Y1 := 0;  IF Y1 > 347 THEN Y1 := 347;
  IF X2 < 0 THEN X2 := 0;  IF X2 > 719 THEN X2 := 719;
  IF Y2 < 0 THEN Y2 := 0;  IF Y2 > 347 THEN Y2 := 347;
  PtCnt   := 0;
  XCnt    := 0;                YCnt    := 0;
  XDist   := ABS(X2-X1) + 1;   YDist   := ABS(Y2-Y1) + 1;
  XStep   := HStep(X1,X2);     YStep   := HStep(Y1,Y2);
  IF YDist >= XDist
  THEN
  BEGIN
    MaxDist := YDist;
    YJump   := 1;
    XJump   := YDist DIV XDist;
  END
  ELSE
  BEGIN
    MaxDist := XDist;
    XJump   := 1;
    YJump   := XDist DIV YDist;
  END;
  REPEAT
      HPlot(X1,Y1,HSwitch);
      PtCnt := PtCnt + 1;
      XCnt  := XCnt + 1;
      YCnt  := YCnt + 1;
      IF XCnt = XJump THEN
      BEGIN
        XCnt := 0;
        X1   := X1 + XStep;
      END;
      IF YCnt = YJump THEN
      BEGIN
        YCnt := 0;
        Y1   := Y1 + YStep;
      END;
  UNTIL PtCnt = MaxDist;
END;

{========== END OF GRAPHICS PROCEDURES ==========}

PROCEDURE FillRand;
  BEGIN
    q := 0;
    Gen := 0;
    HDraw((Xoff-1)*2,0,(Xoff-1)*2,Ysize*2,1);
    HDraw((Xoff-1)*2,0,(Xoff+Xsize+1)*2,0,1);
    HDraw((Xoff+Xsize+1)*2,0,(Xoff+Xsize+1)*2,Ysize*2,1);
    HDraw((Xoff+Xsize+1)*2,Ysize*2,(Xoff-1)*2,Ysize*2,1);

    FOR z := 1 TO StartNum DO
    BEGIN
      Cells[q,z].Xpos := Random((Xsize-1) div 2) + Random((Xsize-1) div 2)+1;
      Cells[q,z].Ypos := Random((Ysize-1) div 2) + Random((Ysize-1) div 2)+1;
      HPlot((Cells[q,z].Xpos+Xoff)*2,Cells[q,z].Ypos*2,1);
    END;
    NumCells := StartNum;
  END;

PROCEDURE ScrubBoard;
  BEGIN
{    FOR z := 1 TO NumCells DO
    BEGIN
      FOR x := Cells[q,z].Xpos-1 TO Cells[q,z].Xpos+1 DO
      BEGIN
        FOR y := Cells[q,z].Ypos-1 TO Cells[q,z].Ypos+1 DO
        BEGIN
          Board[x,y] := 0;
        END;
      END;
    END;}
    FillChar(Board,SizeOf(Board),0);
  END;

PROCEDURE DoGeneration;
  BEGIN
    FOR z := 1 TO NumCells DO
    BEGIN
      Board[Cells[q,z].Xpos,Cells[q,z].Ypos] :=
        Board[Cells[q,z].Xpos,Cells[q,z].Ypos] or $40;
      FOR x := Cells[q,z].Xpos-1 TO Cells[q,z].Xpos+1 DO
      BEGIN
        FOR y := Cells[q,z].Ypos-1 TO Cells[q,z].Ypos+1 DO
        BEGIN
          Board[x,y] := Board[x,y] + 1;
        END;
      END;
    END;
  END;

PROCEDURE NewCells;
  BEGIN
    NumCellq := 0;
    FOR z := 1 TO NumCells DO
    BEGIN
      FOR y := Cells[q,z].Ypos-1 TO Cells[q,z].Ypos+1 DO
      BEGIN
        FOR x := Cells[q,z].Xpos-1 TO Cells[q,z].Xpos+1 DO
        BEGIN
          IF (x > 0) and (x < Xsize) and (y > 0) and (y < Ysize) THEN
          BEGIN
            v := Board[x,y] and $3F;
            w := ((Board[x,y] and $40) > 0);
            IF (v = 3) or (w and (v = 4)) THEN
            BEGIN
              NumCellq := NumCellq + 1;
              Cells[1-q,NumCellq].Xpos := x;
              Cells[1-q,NumCellq].Ypos := y;
              IF not w THEN HPlot((x+Xoff)*2,y*2,1);
            END
            ELSE BEGIN
              IF w THEN HPlot((x+Xoff)*2,y*2,0);
            END;
            Board[x,y] := 0;
          END;
        END;
      END;
    END;
    NumCells := NumCellq;
    q        := 1-q;
    Gen      := Gen + 1;
  END;

BEGIN
  HGraf(1);
  FillRand;
  REPEAT
    REPEAT
      ScrubBoard;
      DoGeneration;
      NewCells;
      LineCntr := (Gen-1) div 200 * 2;
      HPlot(Gen*3 + ((Gen-1) div 5)*3,YSize * 2 + 3 + LineCntr,1);
      Sound(3600);
      Delay(1);
      NoSound;
    UNTIL KeyPressed or (NumCells = 0);
    READ(KBD,Ch);
    IF Ch = ' ' THEN
    BEGIN
      SOUND(1500);
      DELAY(5);
      NOSOUND;
      REPEAT UNTIL KEYPRESSED;
      READ(KBD,Ch);
    END;
  UNTIL Ch <> ' ';
  HGraf(0);
END.
