/* xlftab2.c - xlisp function table - part 2 */
/*	Copyright (c) 1985, by David Michael Betz
	All Rights Reserved
	Permission is granted for unrestricted non-commercial use	*/

#include "xlisp.h"

/* external functions */
extern NODE
    *xfix(),*xfloat(),
    *xadd(),*xsub(),*xmul(),*xdiv(),*xrem(),*xmin(),*xmax(),*xabs(),
    *xadd1(),*xsub1(),*xbitand(),*xbitior(),*xbitxor(),*xbitnot(),
    *xsin(),*xcos(),*xtan(),*xexpt(),*xexp(),*xsqrt(),
    *xlss(),*xleq(),*xequ(),*xneq(),*xgeq(),*xgtr(),
    *xstrcat(),*xsubstr(),*xstring(),*xchar(),
    *xread(),*xprint(),*xprin1(),*xprinc(),*xterpri(),
    *xflatsize(),*xflatc(),
    *xopeni(),*xopeno(),*xclose(),*xrdchar(),*xpkchar(),*xwrchar(),*xreadline(),
    *xload(),*xgc(),*xexpand(),*xalloc(),*xmem(),*xtype(),*xexit();

/* the function table */
struct fdef ftab2[] = {

	/* arithmetic functions */
{	"TRUNCATE",	SUBR,	xfix		},
{	"FLOAT",	SUBR,	xfloat		},
{	"+",		SUBR,	xadd		},
{	"-",		SUBR,	xsub		},
{	"*",		SUBR,	xmul		},
{	"/",		SUBR,	xdiv		},
{	"1+",		SUBR,	xadd1		},
{	"1-",		SUBR,	xsub1		},
{	"REM",		SUBR,	xrem		},
{	"MIN",		SUBR,	xmin		},
{	"MAX",		SUBR,	xmax		},
{	"ABS",		SUBR,	xabs		},
{	"SIN",		SUBR,	xsin		},
{	"COS",		SUBR,	xcos		},
{	"TAN",		SUBR,	xtan		},
{	"EXPT",		SUBR,	xexpt		},
{	"EXP",		SUBR,	xexp		},
{	"SQRT",		SUBR,	xsqrt		},

	/* bitwise logical functions */
{	"BIT-AND",	SUBR,	xbitand		},
{	"BIT-IOR",	SUBR,	xbitior		},
{	"BIT-XOR",	SUBR,	xbitxor		},
{	"BIT-NOT",	SUBR,	xbitnot		},

	/* numeric comparison functions */
{	"<",		SUBR,	xlss		},
{	"<=",		SUBR,	xleq		},
{	"=",		SUBR,	xequ		},
{	"/=",		SUBR,	xneq		},
{	">=",		SUBR,	xgeq		},
{	">",		SUBR,	xgtr		},

	/* string functions */
{	"STRCAT",	SUBR,	xstrcat		},
{	"SUBSTR",	SUBR,	xsubstr		},
{	"STRING",	SUBR,	xstring		},
{	"CHAR",		SUBR,	xchar		},

	/* I/O functions */
{	"READ",		SUBR,	xread		},
{	"PRINT",	SUBR,	xprint		},
{	"PRIN1",	SUBR,	xprin1		},
{	"PRINC",	SUBR,	xprinc		},
{	"TERPRI",	SUBR,	xterpri		},
{	"FLATSIZE",	SUBR,	xflatsize	},
{	"FLATC",	SUBR,	xflatc		},

	/* file I/O functions */
{	"OPENI",	SUBR,	xopeni		},
{	"OPENO",	SUBR,	xopeno		},
{	"CLOSE",	SUBR,	xclose		},
{	"READ-CHAR",	SUBR,	xrdchar		},
{	"PEEK-CHAR",	SUBR,	xpkchar		},
{	"WRITE-CHAR",	SUBR,	xwrchar		},
{	"READ-LINE",	SUBR,	xreadline	},

	/* system functions */
{	"LOAD",		SUBR,	xload		},
{	"GC",		SUBR,	xgc		},
{	"EXPAND",	SUBR,	xexpand		},
{	"ALLOC",	SUBR,	xalloc		},
{	"MEM",		SUBR,	xmem		},
{	"TYPE-OF",	SUBR,	xtype		},
{	"EXIT",		SUBR,	xexit		},

{	0					}
};
