Procedure WriteMsg(Srg : LineString; Col,Row : Integer;Att : AttributeT);
{*****************************************************************************
**                                                                          **
**                         Procedure  WriteMsg                              **
**                                                                          **
**      Purpose:   To output a message at a specific screen position.       **
**                                                                          **
**      Passed :    Srg     - Any String up to 80 characters in length;     **
**                  Col     - An Integer containing the X Coordinate;       **
**                  Row     - An Integer containing the Y Coordinate.       **
**                  Att     - An AttributeT containing the attribute.       **
**                                                                          **
**    Written by :  SJDimon                    1985                         **
**    FastWrite  :  PDS by Marshall Brain      1985                         **
**                                                                          **
*****************************************************************************}

Var

    Attrib : Byte;

Begin

    Case Att of
         Low    : Attrib := $02;
         High   : Attrib := $0A;
         UlLo   : Attrib := $01;
         UlHi   : Attrib := $09;
         BlLo   : Attrib := $82;
         BlHi   : Attrib := $8A;
         UlBlLo : Attrib := $81;
         UlBlHi : Attrib := $89;
         Inv    : Attrib := $70;
         InvBl  : Attrib := $F0;
    End;

  Col := Col - 1;
  Row := Row - 1;

  Inline
    ($1E/$1E/$8A/$86/Row/$B3/$50/$F6/$E3/$2B/$DB/$8A/$9E/Col/
     $03/$C3/$03/$C0/$8B/$F8/$BE/$00/$00/$8A/$BE/Attrib/
     $8A/$8E/Srg/$22/$C9/$74/$3E/$2B/$C0/$8E/$D8/$A0/$49/$04/
     $1F/$2C/$07/$74/$22/$BA/$00/$B8/$8E/$DA/$BA/$DA/$03/$46/
     $8A/$9A/Srg/$EC/$A8/$01/$75/$FB/$FA/$EC/$A8/$01/$74/$FB/
     $89/$1D/$47/$47/$E2/$EA/$2A/$C0/$74/$10/$BA/$00/$B0/
     $8E/$DA/$46/$8A/$9A/Srg/$89/$1D/$47/$47/$E2/$F5/$1F);

End;