Type

    DetString = String[133];

Procedure SpaceOut(DetLine : DetString;
                   Length, Indent, CrgeCtl : Integer);
{*****************************************************************************
**                                                                          **
**                       Procedure SpaceOut                                 **
**                                                                          **
**      Purpose : To precisely format strings on a Turbo Pascal Report      **
**                                                                          **
**      Passed  : DetLine - DetString containing output variable            **
**                Length  - Integer length of output field                  **
**                Indent  - Integer number of spaces to indent              **
**                CrgeCtl - Integer number of return/line feeds to issue    **
**                                                                          **
**   Written by :  SJDimon         1984                                     **
**                                                                          **
*****************************************************************************}

Var

    Ctr1 : Integer;

Begin
    If CrgeCtl > 0 then
        For Ctr1 := 1 to CrgeCtl do
            WriteLn(LST);
    If Indent > 0 then
        For Ctr1 := 1 to Indent do
            Write(LST,' ');
    Write(LST,DetLine:Length);
End;
{.PA}
Procedure SpaceOutR(DetLine : Real;
                    LLength, RLength, Indent, CrgeCtl : Integer);
{*****************************************************************************
**                                                                          **
**                       Procedure SpaceOutR                                **
**                                                                          **
**      Purpose : To precisely format reals on a report in Turbo Pascal     **
**                                                                          **
**      Passed  : DetLine - Real containing output variable                 **
**                RLength - Integer length to Left of decimal point         **
**                LLEngth - Integer length to Right of decimal point        **
**                Indent  - Integer number of spaces to indent              **
**                CrgeCtl - Integer number of return/line feeds to issue    **
**                                                                          **
**   Written by :  SJDimon         1984                                     **
**                                                                          **
*****************************************************************************}

Var

    Ctr1 : Integer;
    DString : DetString;

Begin
    If CrgeCtl > 0 then
        For Ctr1 := 1 to CrgeCtl do
            WriteLn(LST);
    If Indent > 0 then
        For Ctr1 := 1 to Indent do
            Write(LST,' ');
    Str(DetLine:LLength:RLength,DString);  {Convert real to String}
    Ctr1 := LLength + RLength + 1;
    Write(LST,DString:Ctr1);
End;
{.PA}
Procedure SpaceOutI(DetLine, Length, Indent, CrgeCtl : Integer);
{*****************************************************************************
**                                                                          **
**                       Procedure SpaceOutI                                **
**                                                                          **
**      Purpose : To precisely format integers on a report in Turbo Pascal  **
**                                                                          **
**      Passed  : DetLine - Integer containing output variable              **
**                LEngth -  Integer length to of output field               **
**                Indent  - Integer number of spaces to indent              **
**                CrgeCtl - Integer number of return/line feeds to issue    **
**                                                                          **
**   Written by :  SJDimon         1984                                     **
**                                                                          **
*****************************************************************************}

Var

    Ctr1 : Integer;
    DString : DetString;

Begin
    If CrgeCtl > 0 then
        For Ctr1 := 1 to CrgeCtl do
            WriteLn(LST);
    If Indent > 0 then
        For Ctr1 := 1 to Indent do
            Write(LST,' ');
    Str(DetLine:Length,DString); {Convert Integer to String for Output}
    Write(LST,DString:Length);
End;