Procedure FixReal(Var RealTotal : Real;DecPlaces : Integer);
{*****************************************************************************
**                                                                          **
**                       Procedure FixReal                                  **
**                                                                          **
**        Purpose : To correct Real Numbers by rounding them off to a       **
**                  specified accuracy/decimal point.                       **
**                                                                          **
**        Passed  : RealTotal - VAR Real number passed to routine to adjust **
**                  DecPlaces - Integer degree to "FIX" the passed number   **
**                                                                          **
**                  Written by : SJDimon   1985                             **
*****************************************************************************}

Var

    I        : Integer;
    Decimals : Real;

Begin
    If (DecPlaces > 0) Then
        Begin
            Decimals := 1.0;
            For I := 1 to DecPlaces Do
                Decimals := 10 * Decimals;
            RealTotal := RealTotal * Decimals;
            RealTotal := Round(RealTotal);
            RealTotal := Int(RealTotal);
            RealTotal := RealTotal / Decimals;
        End; {If DecPlaces >0}
End; {Procedure FixReal}