{ FLASH.INC (C) Copyright 1985 by Bill Hileman

  The following routines are released to the Public Domain to be used
  in programs and/or be distributed free of charge, provided that they
  are distributed in their original form, and including this copyright
  notice.

  Version 1.00  09/08/85

-------------------------------------------------------------------------------

  Function get_equipment_flag

  This function helps add flash to a program as it helps avoid having
  to prompt the user for such questions as 'Color or Mono', and other
  hardware dependent questions...

  The hardware equipment flags are located at absolute hexadecimal address
  0000:0410.  The word (two bytes) at that location contain information as
  to the hardware configuration.  The bit table below shows the two bytes
  and their bit meaning as is returned by BIOS interrupt #17 (11h) which
  actually returns byte 0000:0411 first, and then 0000:0410:

  F E D C B A 9 8 7 6 5 4 3 2 1 0 Meaning
  --------------- --------------- -------------------------------------------
  X X . . . . . . . . . . . . . . Number of printers installed
  . . X . . . . . . . . . . . . . Serial Printer: 1=installed (PCjr only)
  . . . X . . . . . . . . . . . . Game Adapter: 1=installed
  . . . . X X X . . . . . . . . . Number of RS232 serial ports
  . . . . . . . X . . . . . . . . DMA chip: 0=installed
  . . . . . . . . X X . . . . . . Number of floppy drives (1-4) (see bit 0)
  . . . . . . . . . . X X . . . . Initial video mode: 01=CO40 10=CO80 11=MONO
  . . . . . . . . . . . . X X . . System board RAM: 11=64K (normal for all)
  . . . . . . . . . . . . . . X . Not used (set to 0)
  . . . . . . . . . . . . . . . X Floppy Drives: 1=installed

  The routine is used by assigning an INTEGER variable to the function, i.e.

  equip_flag := get_equip_flag;

  Boolean variables can then be assigned by ANDing values to equip_flag, i.e.

  no_printer := ((equip_flag and $B000) = $B000); (* True if no printer *)
  mono       := ((equip_flag and $0300) = $0300); (* True if monochrome *)
  color      := (not mono);

  or, numbers can be returned, such as

  numb_print := (equip_flag shr 14);  (* number of printers installed *)
  numb_flops := ((equip_flag shr 6) and $0003); (* number of floppies *)

------------------------------------------------------------------------------}

function get_equip_flag : integer;

type
  result  = record
              ax,bx,cx,dx,bp,si,di,ds,es,flags : integer;
            end;

var
  regpack : result;

begin
  with regpack do begin
    intr($11,regpack);
    get_equip_flag:=ax;
  end;
end;

{------------------------------------------------------------------------------

  Function get_installed_ram

  This function returns the installed RAM (random access memory) in Kbytes.

  The routine is used by assigning an INTEGER variable to the function, i.e.

  ram := get_installed_ram;

------------------------------------------------------------------------------}

function get_installed_ram : integer;

type
  result  = record
              ax,bx,cx,dx,bp,si,di,ds,es,flags : integer;
            end;

var
  regpack : result;

begin
  with regpack do begin
    intr($12,regpack);
    get_installed_ram:=ax;
  end;
end;

{------------------------------------------------------------------------------

  Procedure set_cursor_size

  This procedure allows you to define the shape of your cursor, as well as
  hide it from the screen completely!  Hiding the cursor makes the program
  look better while it is writing to the screen.  A good programming practise
  might be to only show a cursor when input is required.  Another possibility
  is to show one shape of a cursor for 1-key entries (like Y/N responses), and
  another shape for line entries (like name) which require [ENTER] to complete.

  The routine requires two integer parameters: c_start and c_end.  They can be
  INTEGER variables or constants, or literals.  'c_start' is the starting scan
  line of the cursor, and 'c_end' is the ending scan line.  It is recommended
  that the user first make a call to the get_equip_flag (above) first to deter-
  mine if the display is color or mono, since a monochrome screen has 14 scan
  lines (0-13) for its cursor, and the color screen has eight scan lines (0-7).

  To turn the cursor off, use 32 (20h) for the c_start parameter, and anything
  (preferably 0), for c_end.

  To define a block cursor:

  if mono then             (* Assumes get_equip_flag called *)
    set_cursor_size(0,13)  (* mono *)
  else
    set_cursor_size(0,7);  (* color *)

  To define an bar cursor:

  if mono then             (* Assumes get_equip_flag called *)
    set_cursor_size(12,13) (* mono *)
  else
    set_cursor_size(6,7);  (* color *)

------------------------------------------------------------------------------}

procedure set_cursor_size(c_start,
                          c_end    : integer);

type
  result  = record
              ax,bx,cx,dx,bp,si,di,ds,es,flags : integer;
            end;

var
  regpack : result;

begin
  with regpack do begin
    ax:=1 shl 8;
    cx:=(c_start shl 8)+c_end;
    intr($10,regpack);
  end;
end;

{------------------------------------------------------------------------------

  Procedure get_cursor_size

  This procedure allows you to determine the cursor's shape at any time.  It
  is a good programming practise to determine the computer's orginal state as
  much as possible and return the user to that state upon the completion of
  your program.  This routine should be called early in the program (before
  any calls to the set_cursor_size procedure.

  You will need to define two INTEGER variables in your program to store the
  c_start and c_end values returned.  Like the set_cursor_size procedure
  described above, c_start is the starting scan line of the cursor, and c_end
  is the ending scan line of the cursor.

  This procedure should be used something like this:

  program xxxx;

  ...

  var
    org_c_start, org_c_end : Integer;

  ...

  Begin
    get_cursor_size(org_c_start,org_c_end);

    ...

    set_cursor_size(org_c_start,org_c_end);
  end.

------------------------------------------------------------------------------}

procedure get_cursor_size(var c_start,
                              c_end    : integer);

type
  result  = record
              ax,bx,cx,dx,bp,si,di,ds,es,flags : integer;
            end;

var
  regpack : result;

begin
  with regpack do begin
    bx:=0;
    ax:=3 shl 8;
    intr($10,regpack);
    c_start:=cx shr 8;
    c_end:=(cx and 255);
  end;
end;
