	page	64,120
; PSET2631.ASM - Printer set-up program for the HP2631G printer
;
; This program will allow the operator to per-set certain printer
; states.  The printer will remain in these states until the
; printer power is recycled, or the printer is directed into 
; another state through program control.
;
; Modified from PSET15.ASM, an Epson printer set-up program
; written under CP/M 2.2.
;
; Written by:  Barron F. McIntire III
;              3400 S. Greeley Hwy #8
;              Cheyenne, Wyoming  82007
;              RCP/M phone 307-635-8366, 300/1200/2400 baud, 24 hours
;              CIS ID #74155,441
;
;********************************************************************
;
cr	equ	0dh		;carriage return
lf	equ	0ah		;line feed
dos	equ	21h		;DOS call location
bel	equ	7		;bell
esc	equ	1bh		;escape character
cls	equ	'J'		;HP clear screen character
hom	equ	'H'		;HP cursor home character
;
conin	equ	1		;console input function
conout	equ	2		;console output function
lstout	equ	5		;printer output function
linout	equ	9		;string print function
bufin	equ	10		;buffered keyboard input function
;
ver	equ	'2'		;version
modlev	equ	'0'		;modification level
;
;********************************************************************
;
st_seg	segment	stack		;define stack segment
	db	20 dup	('stack   ')
st_seg	ends
;
;********************************************************************
;
data	segment
;
clr	db	esc,hom,esc,cls,'$'	;clear screen data
;
messg	db	'            ***** HP 2631G PRINTER PRE-SET '
	db	'PROGRAM v',ver,'.',modlev,' *****',cr,lf,lf
	db	'This program will allow the operator to pre-set '
	db	'certain printer states.',cr,lf
	db	'The printer will remain in these states until the '
	db	'printer power is',cr,lf
	db	'recycled, or the printer is directed into another '
	db	'state by program control.',cr,lf,'$'
;
optmes	db	cr,lf,'The following options are available:',cr,lf,lf
	db	'  A.  Printer initialization            '
	db	'K.  Set 7.2 char per inch (1/2 exp)',cr,lf
	db	'  B.  Printer self-test                 '
	db	'L.  Set 10 char per inch (standard)',cr,lf
	db	'  C.  Send CR,LF to printer             '
	db	'M.  Set 14.4 char per inch (compressed)',cr,lf
	db	'  D.  Underline on                      '
	db	'N.  Form length setting',cr,lf
	db	'  E.  Underline off                     '
	db	'O.  Send form feed (top of form)',cr,lf
	db	'  F.  Skip over perforation on          '
	db	'P.  Set printer on-line',cr,lf
	db	'  G.  Skip over perforation off         '
	db	'Q.  Set printer off-line',cr,lf
	db	'  H.  Set lines per inch                '
	db	'R.  Display functions on',cr,lf
	db	'  I.  Page length setting               '
	db	'S.  Display functions off',cr,lf
	db	'  J.  Set 5 char per inch (expanded)    '
	db	'T.  EXIT TO MS-DOS ******',cr,lf
;
	db	cr,lf,'Enter desired option:','$'
;
emess	db	bel,cr,lf,'++ UNKNOWN ENTRY! - Exit to DOS (Y/N) ?','$'
;
ermes	db	bel,cr,lf,'NON-NUMERIC character entered!  '
	db	'Try again!',cr,lf,'$'
;
msend	db	cr,lf,'Another option (Y/N) ?','$'
;
mlin	db	'Enter number of lines (0-255):','$'
;
mlinc	db	'Enter number of lines per inch',cr,lf
	db	'(0,1,2,3,4,6,or 8 only)(0=12 lpn) :','$'
;
buff	db	6		;4 bytes for number input
;
data	ends
;
;********************************************************************
;
pset	segment
;
main	proc	far
;
; Main part of program
;
	assume cs:pset,ds:data
;
start:
;
; Set up stack for return
;
	push	ds		;ds on stack
	sub	ax,ax		;set ax to zero
	push	ax		;zero on stack
	mov	ax,data
	mov	ds,ax		;data area to ds reg
;
; Display opening message
;
	mov	dx,offset clr	;get clear screen message
	mov	ah,linout	;get string print function
	int	dos		;call DOS
;
	mov	dx,offset messg	;get opening message
	mov	ah,linout	
	int	dos
;
; Display options
;
optdis:	
	mov	dx,offset optmes ;get options message
	mov	ah,linout
	int	dos
;
; Input option
;
optin:
	mov	ah,conin	;get keyboard input char
	int	dos
	and	al,5fh		;mask to upper case
	push	ax		;save character on stack
	mov	dl,cr		;send carriage return
	mov	ah,conout	
	int	dos
	mov	dl,lf		;send line feed
	mov	ah,conout
	int	dos
	pop	ax		;get char back from stack
;
; Compare option - goto proper lstout routine
;
	cmp	al,'A'
	jnz	optb
	jmp	opt1
optb:	cmp	al,'B'
	jnz	optc
	jmp	opt2
optc:	cmp	al,'C'
	jnz	optd
	jmp	opt3
optd:	cmp	al,'D'
	jnz	opte
	jmp	opt4
opte:	cmp	al,'E'
	jnz	optf
	jmp	opt5
optf:	cmp	al,'F'
	jnz	optg
	jmp	opt6
optg:	cmp	al,'G'
	jnz	opth
	jmp	opt7
opth:	cmp	al,'H'
	jnz	opti
	jmp	opt8
opti:	cmp	al,'I'
	jnz	optj
	jmp	opt9
optj:	cmp	al,'J'
	jnz	optk
	jmp	opt10 
optk:	cmp	al,'K'
	jnz	optl 
	jmp	opt11
optl:	cmp	al,'L'
	jnz	optm 
	jmp	opt12
optm:	cmp	al,'M'
	jnz	optn
	jmp	opt13
optn:	cmp	al,'N'
	jnz	opto
	jmp	opt14
opto:	cmp	al,'O'
	jnz	optp
	jmp	opt15
optp:	cmp	al,'P'
	jnz	optq
	jmp	opt16 
optq:	cmp	al,'Q'
	jnz	optr 
	jmp	opt17
optr:	cmp	al,'R'
	jnz	opts 
	jmp	opt18
opts:	cmp	al,'S'
	jnz	optt
	jmp	opt19
optt:	cmp	al,'T'
	jnz	opterr
	jmp	exit
;
; Error if no compare
;
opterr:	mov	dx,offset emess	;get error message
	mov	ah,linout
	int	dos
	mov	ah,conin	;get response
	int	dos
	and	al,5fh		;mask to upper case
	push	ax		;save on stack
	mov	dl,cr		;send carriage return
	mov	ah,conout
	int	dos
	mov	dl,lf		;send line feed
	mov	ah,conout
	int	dos
	pop	ax		;get char back from stack
	cmp	al,'Y'		;return to DOS ?
	jz	ext		;yes, go exit
	jmp	optdis		;no, then re-display options
ext:	jmp	exit		;exit to DOS
;
; Printer initialization
;
opt1:
	call	escap		;send escape character to printer
	mov	dl,'E'		;get printer init char
	mov	ah,lstout	;get list out char
	int	dos		;send to printer
	jmp	more		;another option?
;
; Printer self test
;
opt2:
	call	escap
	mov	dl,'z'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Send CR,LF to printer
;
opt3:
	mov	dl,cr
	mov	ah,lstout
	int	dos
	mov	dl,lf
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set underline on
;
opt4:
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'d'
	mov	ah,lstout
	int	dos
	mov	dl,'E'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set underline off
;
opt5:
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'d'
	mov	ah,lstout
	int	dos
	mov	dl,'A'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Skip over perf on
;
opt6:
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'l'
	mov	ah,lstout
	int	dos
	mov	dl,'1'
	mov	ah,lstout
	int	dos
	mov	dl,'L'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Skip over perf off
;
opt7:
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'l'
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	mov	dl,'L'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set lines per inch
;
opt8:
	mov	dx,offset mlinc	;get lines per inch message
	mov	ah,linout
	int	dos		;send it
	mov	ah,conin
	int	dos
	cmp	al,'0'		;less than 0?
	jl	opt8		;try again
	cmp	al,'8'		;greater than 8?
	jg	opt8		;try again
	cmp	al,'5'		;5 isnt legal
	jz	opt8
	cmp	al,'7'		;neither is 7
	jz	opt8
;
	push	ax		;must be ok, save char on stack
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'l'
	mov	ah,lstout
	int	dos
	pop	ax		;get char back
	mov	dl,al
	mov	ah,lstout
	int	dos
	mov	dl,'D'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set page length
;
opt9:
	mov	dx,offset mlin	;get lines per page message
	mov	ah,linout
	int	dos		;send it
	call	decin		;decimal input for lines per page
	cmp	bx,0000h	;less than 0?
	jl	opt9		;then do it again
	cmp	bx,000ffh	;greater than 255?
	jg	opt9		;shame on you
;
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'l'
	mov	ah,lstout
	int	dos
	mov	dl,buff+2
	mov	ah,lstout
	int	dos
	mov	dl,buff+3
	cmp	dl,cr		;done?
	jz	done
	mov	ah,lstout	;no, send it
	int	dos
	mov	dl,buff+4
	cmp	dl,cr		;done?
	jz	done
	mov	ah,lstout	;no, send it
	int	dos
done:
	mov	dl,'P'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set 5 char per inch (expanded mode)
;
opt10:
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'k'
	mov	ah,lstout
	int	dos
	mov	dl,'1'
	mov	ah,lstout
	int	dos
	mov	dl,'S'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set 7.2 char per inch (half-expanded mode)
;
opt11:
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'k'
	mov	ah,lstout
	int	dos
	mov	dl,'3'
	mov	ah,lstout
	int	dos
	mov	dl,'S'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set 10 char per inch (standard pica mode)
;
opt12:
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'k'
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	mov	dl,'S'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set 14.4 char per inch (condensed mode)
;
opt13:
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'k'
	mov	ah,lstout
	int	dos
	mov	dl,'2'
	mov	ah,lstout
	int	dos
	mov	dl,'S'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set form length
;
opt14:
	mov	dx,offset mlin	;get lines per page message
	mov	ah,linout
	int	dos		;send it
	call	decin		;decimal input for lines per page
	cmp	bx,0000h	;less than 0?
	jl	opt14		;then do it again
	cmp	bx,000ffh	;greater than 255?
	jg	opt14		;shame on you
;
	call	escap
	mov	dl,'&'
	mov	ah,lstout
	int	dos
	mov	dl,'l'
	mov	ah,lstout
	int	dos
	mov	dl,buff+2
	mov	ah,lstout
	int	dos
	mov	dl,buff+3
	cmp	dl,cr		;done?
	jz	don1
	mov	ah,lstout	;no, send it
	int	dos
	mov	dl,buff+4
	cmp	dl,cr		;done?
	jz	don1
	mov	ah,lstout	;no, send it
	int	dos
don1:
	mov	dl,'F'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Send form feed
;
opt15:
	mov	dl,0ch
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set printer on-line
;
opt16:
	call	escap
	mov	dl,'n'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set printer off-line
;
opt17:
	call	escap
	mov	dl,'o'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set display functions on
;
opt18:
	call	escap
	mov	dl,'Y'
	mov	ah,lstout
	int	dos
	jmp	more
;
; Set display functions off
;
opt19:
	call	escap
	mov	dl,'Z'
	mov	ah,lstout
	int	dos
	jmp	more
;
more:
	mov	dx,offset msend
	mov	ah,linout
	int	dos
	mov	ah,conin
	int	dos
	and	al,5fh
	push	ax
	mov	dl,cr
	mov	ah,conout
	int	dos
	mov	dl,lf
	mov	ah,conout
	int	dos
	pop	ax
	cmp	al,'Y'			;do it again?
	jnz	exit			;no, exit
	jmp	optdis			;else re-display options
;
exit:
	ret				;else return to DOS	
;
main	endp			;end of main program
;
;--------------------------------------------------------------------
;Procedure for decimal input
;Result is in BX register, with ASCII chars in buff
;
decin	proc	near
;
	mov	dx,offset buff
	mov	ah,bufin
	int	dos
;
	mov	bx,0		;clear bx reg
	mov	al,buff+2	;get first char
	sub	al,30h		;convert ASCII to decimal
	jl	error
	cmp	al,9d
	jg	error		;must be from 0 to 9
;
	cbw			;byte in al to word in ax
	xchg	ax,bx
	mov	cx,10d
	mul	cx		;digit X 10
	xchg	ax,bx
	add	bx,ax		;add digit and number
;
	mov	al,buff+3	;get next digit
	cmp	al,cr		;done?
	jz	retn		;return if done
	sub	al,30h		;convert ASCII to decimal
	jl	error
	cmp	al,9d
	jg	error
;
	cbw
	xchg	ax,bx
	mov	cx,10d
	mul	cx
	xchg	ax,bx
	add	bx,ax
;
	mov	al,buff+4
	cmp	al,cr
	jz	retn
	sub	al,30h
	jl	error
	cmp	al,9d
	jg	error
;
	cbw
	xchg	ax,bx
	mov	cx,10d
	mul	cx
	xchg	ax,bx
	add	bx,ax
	ret
;
error:
	mov	dx,offset ermes
	mov	ah,linout
	int	dos
	sub	dx,dx
retn:	ret
;
decin	endp
;
;--------------------------------------------------------------------
; Procedure to send escape sequence to printer
;	
escap	proc	near
;
	mov	dl,esc
	mov	ah,lstout
	int	dos
	ret
;
escap	endp
;
;--------------------------------------------------------------------
pset	ends
;********************************************************************
;
	end	start
