;	SSM PB1 2708/2716 PROGRAMMMER & 4K/8K EPROM PROGRAM
;	          WRITTEN WITH MODIFICATIONS    
;		BY H.A.LAUTENBACH  MARCH 19/1982
;	
;	    USED WITH DDT THIS PROGRAM LINKS TOGETHER
;      THE ORIGINAL PROGRAMS WRITTEN BY SSM -FOR PROGRAMMING 
;	   2708 & 2716 MODIFIED TO INCLUDE T.I. 2716'S
;
;     ALL THREE TYPES MAY BE PROGRAMED WITH THIS MODIFICATION
;
;************************************************************
;
	ORG	0100H

;SET THE STACK TO LOCATION TO WRITE MESSAGES TO CONSOLE

	LXI	SP,0800H	;SET STACK POINTER
USER:	CALL	PROMPT		;SEND MENU TO SCREEN 
	CALL	INCHR		;INPUT CHARACTER
	CALL	SELECT		;SELECT SUBROUTINE
	JMP	USER		;RETURN TO PROMPT

;**********************************************************
;
;	SECTION FOR SUBROUTINES

;USING CBIOS ROUTINE TO SEND STRING TO CONSOLE 
;	ENTER:	C=2
;		DE=LOCATION OF STRING ($ REPRESENTS EOT)
;	EXIT:	ALL REGISTERS SCREWED UP

PROMPT:	LXI	D,MSG		;LOAD D WITH MESSAGE POINTER
	MVI	C,9		;BDOS FUNC STRING OUT
	CALL	CONSOL		;LOCATION FOR CBIOS SR
	RET

;USING CBIOS SR TO READ USER INPUT STRING
;	ENTER:	C=1
;	EXIT:	A=ASCII CHARACTER INPUTTED BY USER
;		ALL OTHER REGISTERS SCREWED UP

INCHR:	MVI	C,1		;BDOOS FUNCTION CONIN
	CALL	CONSOL		;LOCATION FOR CBIOS SR
	RET

;WITH CHARACTER IN ACCUMULATOR COMPARE TO MENU FOR FUNCTION
;	ENTER:	A=CHARACTER FROM USER
;	EXIT:	FROM WHICH EVER FUNCTION CALLED 

;	PROGRAM EPROMS

SELECT:	CPI	50H		;ASCII 'P'
	JZ	PROT2		;PROGRAM STANDARD 2716
	CPI	4FH		;ASCII 'O'
	JZ	PROTI		;PROGRAM T.I. 2716
	CPI	49H		;ASCII 'I'
	JZ	PROT3		;PROGRAM STANDARD 2708

;	MOVE MEMORY FROM EPROM TO RAM AREA 

	CPI	54H		;ASCII 'T'
	JZ	YAN1		;EPROM TO RAM T.I.
	CPI	59H		;ASCII 'Y'
	JZ	YAN2		;EPROM TO RAM STD. 2716
	CPI	52H		;ASCII 'R'
	JZ	YAN3		;EPROM TO RAM STD. 2708
 
;	VERIFY EPROM VS RAM

	CPI	43H		;ASCII 'C'
	JZ	VER1		;EPROM VS RAM T.I. 2716
	CPI	56H		;ASCII 'V'
	JZ	VER2		;EPROM VS RAM STD. 2716
	CPI	58H		;ASCII 'X'
	JZ	VER3		;EPROM VS RAM STD. 2708

;	CHECK FOR EMPTY EPROM
	
	CPI	57H		;ASCII 'W'
	JZ	EMPY1		;EPROM EMPTY ? T.I. 2716
	CPI	45H		;ASCII 'E'
	JZ	EMPY2		;EPROM EMPTY ? STD. 2716
	CPI	51H		;ASCII 'Q'
	JZ	EMPY2		;EPROM EMPTY ? STD. 2708

	CPI	1AH		;CHECK FOR ^Z
	JZ	ERS1		;ERASE 4K BLOCK @ RAM START

	CPI	1BH		;ASCII 'ESC'
	RNZ			;NOT A COMMAND
	RST 	0		;BACK TO DDT MODE

SELCT1: CPI	4DH		;ASCII 'M'
	JZ	USER		;REPRINT MENU
	CPI	1BH		;ASCII 'ESC'
	RNZ
	JMP	MONITR

;PROGRAM WRITTEN FOR PROGRAMMING EPROMS
;COPYRIGHT BY SOLID STATE MUSIC ,  1978

;REGISTER USAGE:
;REG.A....PASS DATA FROM MEMORY TO PROGRAMMER
;REG.B....REPEATED PROGRAMMING CYCLES
;REG.C....SIZE.   SIZE=256(REG.C+1)
;REG.DE...PROM CARD ADDRESS
;REG.HL...DATA ADDRESS TO BE COPIED

PROTI:  MVI	A,01		;TEXAS INSTR 2716
	OUT	CPORT		;PRESENT BOARD
	MVI	B,01H		;1 CYCLE FOR 2716
	MVI	C,07		;# OF BLOCKS
	JMP	PROG1

PROT2:  MVI	A,02		;STANDARD 2716
	OUT	CPORT		;PRESENT BOARD
	MVI	B,01		;1 CYCLE FOR 2716
	MVI	C,07		;# OF BLOCKS
	JMP	PROG1

PROT3:	MVI	A,01		;STANDARD 2708
	OUT	CPORT		;PRESENT BOARD
	MVI	B,0FFH		;256 CYCLES FOR 2708
	MVI	C,03		;# OF BLOCKS
	JMP	PROG1

;			SET UP ADDRESSES FOR TRANSFER

PROG1:	LXI	D,PROM
	LXI	H,RAM

;				PROGRAM THE EPROM

PROG2:	MOV	A,M
	STAX	D
	INX	D
	INX	H
	MOV	A,D
	ANA	C
	ORA	E
	JNZ	PROG2
	DCR	B
	JNZ	PROG1
	DCX	D
	LDAX	D		;RESET PB1
	LXI	D,M5		;LOAD MESS COMPLETED
	MVI	C,9		;CP/M PARAMETER
	CALL	CONSOL
	LXI	D,M6		;LOAD PROMPT MESS
	MVI	C,9		;CP/M PARAMETER
	CALL	INCHR
	CALL	SELCT1
	RET

;DESIGNED TO MOVE DATA FROM EPROM TO RAM
;REGISTER USAGE:
;REG.A....TRANSFER DATA
;REG.C....CHECK FOR END OF READ
;REG.DE...PROM
;REG.HL...RAM

YAN1:	MVI	A,01		;TEXAS INSTR 2716
	OUT	CPORT		;PRESENT BOARD
	XRA	A		;CLEAR THE ACCUMULATOR
	MVI	C,07		;07=2716
	LXI	D,PROM
	LXI	H,RAM
	JMP	YANK1

YAN2:	MVI	A,02		;STANDARD 2716
	OUT	CPORT		;PRESENT BOARD
	XRA	A		;CLEAR THE ACCUMULATOR
	MVI	C,07		;07=2716
	LXI	D,PROM
	LXI	H,RAM
	JMP	YANK1

YAN3:	MVI	A,01		;STANDARD 2708
	OUT	CPORT		;PRESENT BOARD
	XRA	A		;CLEAR THE ACCUMULATOR
	MVI	C,03		;03=2708
	LXI	D,PROM
	LXI	H,RAM

;MOVE THRU A TO MEMORY

YANK1:	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	MOV	A,D
	ANA	C
	ORA	E
	JNZ	YANK1
	LXI	D,M7
	MVI	C,9
	CALL	CONSOL
	LXI	D,M6
	MVI	C,9
	CALL	CONSOL
	CALL	INCHR
	CALL	SELCT1
	RET

;MODIFIED ROUTINE FOR VERIFYING THE ORIGINAL
;SOURCE DATA IN MEMORY AGAINST THE EPROM COPY
;COPYRIGHT BY SOLID STATE MUSIC, 1978
;PRETTYPRINT MODS BY L.R.TITZE  SEPT/80
;
;REGISTER USAGE:
;REG.A....TEST AND PASS CHARACTERS
;REG.B....ORIGINAL DATA
;REG.C....SIZE.   SIZE=256(REG.C+1)
;REG.DE...PROM CARD ADDRESS
;REG.HL...ADDRESS OF ORIGINAL

VER1:	MVI	A,01		;TEXAS INSTR 2716
	OUT	CPORT		;PRESENT BOARD
	XRA	A		;CLEAR THE ACCUMULATOR
	MVI	C,07		;# OF BLOCKS
	LXI	D,PROM		;SOCKET ADDRESS OF COPY
	LXI	H,RAM		;POINT TO RAM MASTER
	JMP	VERF1

VER2:	MVI	A,02		;STANDARD 2716
	OUT	CPORT		;PRESENT BOARD
	XRA	A		;CLEAR THE ACCUMULATOR
	MVI	C,07		;# OF BLOCKS
	LXI	D,PROM		;SOCKET ADDRESS OF COPY
	LXI	H,RAM		;POINT TO RAM MASTER
	JMP	VERF1

VER3:	MVI	A,01		;STANDARD 2708
	OUT	CPORT		;PRESENT BOARD
	XRA	A		;CLEAR THE ACCUMULATOR 
	MVI	C,03		;# OF BLOCKS 2708
	LXI	D,PROM		;SOCKET ADDRESS OF COPY
	LXI	H,RAM		;POINT TO RAM MASTER

VERF1:	MOV	B,M		;GET ORIGINAL DATA
	LDAX	D		;GET ROM COPY
	CMP	B		;ARE THEY ALIKE?
	CNZ	ERPRT
	INX	D
	INX	H
	MOV	A,D
	ANA	C
	ORA	E
	JNZ	VERF1		;GO BACK FOR NEXT BYTE
	LXI	D,DMSG		;DONE MESSAGE LOCATION
OVRF:	MVI	C,9		;PARAMETER TO PRINT CHAR
	CALL	CONSOL		;LOCATION OF CBIOS
	LXI	D,M6
	MVI	C,9
	CALL	CONSOL
	CALL	INCHR
	CALL	SELCT1
	RET

;OUTPUT ERROR CHARACTER
;
ERPRT:	PUSH H! PUSH D! PUSH B
	PUSH	PSW
	PUSH H! PUSH D! PUSH B	;PRINT MESSAGE STRING 1
	MVI	C,9
	LXI	D,M1		;CR,'ERROR at '
	CALL	5
	POP B! POP D! POP H
	MOV	A,D		;PRINT PROM
	CALL	PHEX		; ADDRESS
	MOV	A,E		; CONTAINED
	CALL	PHEX		; IN D,E REG
	PUSH H! PUSH D! PUSH B	;PRINT MESSAGE STRING 2
	MVI	C,9
	LXI	D,M2		;': '
	CALL	5
	POP B! POP D! POP H
	MOV	A,B		;PRINT RAM
	CALL	PHEX		; CONTENTS
	PUSH H! PUSH D! PUSH B	;PRINT MESSAGE STRING 3
	MVI	C,9
	LXI	D,M3		;' = '
	CALL	5
	POP B! POP D! POP H
	POP	PSW		;PRINT PROM
	CALL	PHEX		; CONTENTS
	PUSH H! PUSH D! PUSH B	;PRINT MESSAGE STRING 4
	MVI	C,9
	LXI	D,M4		;'in EPROM'
	CALL	5
	POP B! POP D! POP H
	POP B! POP D! POP H
	RET
;
;LIBRARY OF PRINT FUNCTIONS  L.R.TITZE
;	PHEX:prints hex byte in A register
;	PCHAR:prints ASCII char in A reg.
;	PNIB:converts binary to ASCII hex char
;
PHEX:	;PRINT HEX CHAR IN A REG
	PUSH H! PUSH D! PUSH B
	PUSH	PSW
	RRC ! RRC ! RRC ! RRC
	CALL	PNIB
	POP	PSW
	CALL	PNIB
	POP B! POP D! POP H
	RET
PCHAR:	PUSH H! PUSH D! PUSH B
	MVI	C,2
	MOV	E,A
	CALL	5
	POP B! POP D! POP H
	RET
;
PNIB:	ANI	0FH	;LOW 4 BITS
	CPI	10
	JNC	P10
	ADI	'0'
	JMP	PRN
;	GREATER OR EQUAL TO 10
P10	ADI	'A' - 10
PRN:	CALL	PCHAR
	RET
;
;A SIMPLE ROUTINE FOR CHECKING IF THE EPROM
;IS ERASED. PRINTS P=PASS, F=FAIL.
;COPYRIGHT SOLID STATE MUSIC, 1978

;REGISTER USAGE:
;REG.A....TEST AND PASS A CHARACTER
;REG.C....SIZE
;REG.DE...EPROM CARD ADDRESS

EMPY1:	MVI	A,01		;TEXAS INSR 2716
	OUT	CPORT		;PRESENT BOARD
	XRA	A		;CLEAR THE ACCUMULATOR
	MVI	C,07		; 07=2716
	LXI	D,PROM		;EPROM ADDRESS
	JMP	ER1

EMPY2:	MVI	A,02		;STANDARD 2716
	OUT	CPORT		;PRESENT BOARD
	XRA	A		;CLEAR THE ACCUMULATOR
	MVI	C,07		; 07=2716
	LXI	D,PROM		;EPROM ADDRESS
	JMP	ER1

EMPY3:	MVI	A,01		;STANDARD 2708
	OUT	CPORT		;PRESENT BOARD
	XRA	A		;CLEAR THE ACCUMULATOR
	MVI	C,03		; 03=2708 
	LXI	D,PROM		;EPROM ADDRESS

ER1:	LDAX	D		;READ PROM
	INX	D
	CPI	0FFH		;TEST FOR ERASE
	JNZ	ERR1
	MOV	A,D
	ANA	C
	ORA	E		;DONE YET?
	JNZ	ER1
	LXI	D,PMSG		;PASS MESSAGE LOCATION
	JMP	PASS
ERR1:	LXI	D,FMSG		;FAIL MESSAGE LOCATION
PASS:	MVI	C,9		;BDOS FUNC PRINT STRING
	CALL	CONSOL		;OUTPUT ROUTINE
	LXI	D,M6
	MVI	C,9
	CALL	CONSOL
	CALL	INCHR
	CALL	SELCT1
	RET

;CLEAR 4069 BYTES OF MEMORY - READY FOR UPLOAD/DOWNLOAD

ERS1:	LXI	B,ERSSE		;4K SEGMENT +1 BLK
	LXI	D,ERAM		;ERAM ADDRESS
	MVI	A,00H		;LOAD A WITH 00
ER12:	INX	D		;INCREMENT DE
	STAX	D		;LOAD 00 TO ADDRESS
	DCX	B		;DEC BC 
	CMP	B		;DONE YET?
	JNZ	ER12		;NO GO BACK
	LXI	D,M8		;CALL ERASE MESS COMPLETE
	MVI	C,9
	CALL	CONSOL
	LXI	D,M6
	MVI	C,9
	CALL	CONSOL
	CALL	INCHR
	CALL	SELCT1
	RET



;IMBEDDED MESSAGE CALLED AS PROMPT WITH MENU

MSG:	EQU	$
DB CLS
DB '              EPROM PROGRAMMER FOR SSM-PB1',CR,LF,CR,LF
DB '          RAM EQU = 2000H - EPROM EQU = C000H',CR,LF
DB '              by: H.A. Lautenbach 03/20/82',CR,LF,CR,LF  
DB ' Standard  Texas Inst. Standard       Function',CR,LF
DB '   2716       2716       2708',CR,LF,CR,LF
DB '    P          O          I      FOR PROGRAMMING EPROM',CR,LF
DB '    Y          T          R      MOVE EPROM TO RAM',CR,LF
DB '    V          C          X      VERIFYING EPROM TO RAM',CR,LF
DB '    E          W          Q      CHECK FOR EMPTY EPROM',CR,LF
DB CR,LF,CR,LF
DB 'Note: Texas Instrument 2716 EPROMS must be',CR,LF
DB '      placed in the 2708 programming socket.',CR,LF,CR,LF
DB 'Enter ^Z to clear 4K RAM space',CR,LF,CR,LF
DB 'TYPE <ESC>......FOR ESCAPE BACK TO CP/M',CR,LF
DB 'ENTER COMMAND <CR> not required >'
DB '$'

;MESSAGES FOR ERROR ROUTINE
;
M1:	DB	0DH,'ERR at $'
M2:	DB	': $'
M3:	DB	' = $'
M4:	DB	' in EPROM',CR,LF
	DB '$'
;PROGRAMMING FINISHED MESSAGE
;
M5:	EQU	$
	DB	CLS
	DB 'PROGRAMMING NOW COMPLETE',CR,LF
	DB	'$'

M6:	EQU	$
	DB 'Enter (M) for MENU or ESC for Monitor -->'
	DB      '$'

M7:	EQU	$
	DB	CLS
	DB 'Contents of EPROM memory area now in RAM',CR,LF
	DB 	'$'

M8:	EQU	$
	DB	CLS
	DB 'Memory has been ERASED at RAM start',CR,LF
	DB	'$'
;
;MESSAGE FOR FUNCTION PASSING

DMSG:	EQU	$
	DB 	CLS
	DB	'FUNCTION COMPLETED ',CR,LF

	DB	'$'		
PMSG:	EQU	$
	DB	CLS
	DB	'FUNCTION PASS',CR,LF

	DB	'$'		

;MESSAGE FOR FUNCTION FAILING
FMSG:	EQU	$
	DB	'FUNCTION FAIL',CR,LF

	DB	'$'		;EOT CHARACTER

;ALL EQUATES FALL BELOW HERE

CONSOL:	EQU	5H		;LOCATION OF BDOS CALL
CPORT:	EQU	10H             ;PROGRAMMER PORT
PROM:	EQU	0C000H		;ADDRESS FOR PROM
RAM:	EQU	2000H		;ADDRESS FOR RAM
CR:	EQU	0AH		;CARRIAGE RETURN
LF:	EQU	0DH		;LINE FEED
CLS:    EQU     0CH 		;CLEAR SCREEN
MONITR: EQU	0E003H		;MONITOR JUMP VECTOR 
ERAM:	EQU	1FFFH		;ERASE START ADDRESS
ERSSE:	EQU	20FFH		;COUNT DOWN + 1 BLOCK
;
	END
