;THIS FILE IS FOR PEOPLE WITH LARGE MAST.CAT FILES WHO WANT TO
;USE AN EXTERNAL SORT PROGRAM SUCH AS SUPERSORT RATHER THAN
;THE INTERNAL SORT IN CROSSREF.  IT HAS THE SINGLE FUNCTION
;OF READING MAST.CAT AND CREATING FROM IT A FILE 'TEMP.CAT'
;WHICH IS IN THE FORMAT FOR SORTING VIA SUPERSORT.  THE 'IGNORE'
;NAMES ARE DELETED AND ALL PERIODS ARE CHANGED INTO COMMAS
;AS PROPER SUPERSORT FIELD DELIMITERS.
;
VERSION	EQU	1		;FOR SIGNON
MODLEV	EQU	0
;
	MACLIB	SEQIO
;
BSIZE	EQU	20*1024		;DISK BUFFER SIZE (*2)
;MAKE AS LARGE AS POSSIBLE FOR YOUR SYSTEM, HERE THEY
;ARE 20K EACH, 40K TOTAL
FILERR	SET	EXIT		;DISK I/O ERROR VECTOR
;
	ORG	100H
	POP	H		;GET RETURN ADDRESS
	SHLD	EXIT+1
	LXI	SP,STACK
;
	CALL	ILPRT
	DB	CR,LF
	DB	'MAST.CAT translator program, V'
	DB	VERSION+'0', '.', MODLEV+'0'
	DB	CR,LF
	DB	'Reads MAST.CAT, writes TEMP.CAT.  Strips off IGNORE'
	DB	CR,LF
	DB	'names.  Changes all PERIODS to COMMAS for SUPERSORT.'
	DB	CR,LF,LF,0
;
;SEQIO DOES CHARACTER I/O FUNCTIONS
;SET UP THE FILES
;
	FILE	INFILE,MASTIN,,MAST,CAT,BSIZE
	FILE	OUTFILE,MASTOUT,,TEMP,CAT,BSIZE
;
;
;READ IN THE NAMES TO BE IGNORED (I.E. NOT
;CATALOGED) AND THROW THEM AWAY (DO NOT WRITE TO
;OUTPUT FILE.)  THEY ARE AT THE FRONT OF MAST CAT.
;THEY ARE SIMPLY A LIST OF FILENAME.FILETYPE (CR/LF)
;WITH THE FIRST HAVING A ( BEFORE IT, AND THE
;LAST HAVING A ) AFTER IT.
;
	GET	MASTIN	;GET THE LEADING '('
	JZ	NOMAST		;IF EOF
	CPI	'('
	JNZ	NOIGN
IGNRD	GET	MASTIN
	JZ	IGNEOF	;UNEXPECTED EOF
	CPI	')'
	JZ	IGNEND	;TABLE IS LOADED
	JMP	IGNRD
;
;GOT THE ')', IGNORE TO END OF THIS LINE
IGNEND	GET	MASTIN
	JZ	IGNEOF
	CPI	0AH
	JNZ	IGNEND	;DELETE CR/LF
;
LOOP:	GET	MASTIN		;READ INPUT
	JZ	ALLDONE		;THRU ON EOF
	CPI	'.'
	JNZ	LOOP1		;CHANGE PERIODS TO COMMAS
	MVI	A,','
LOOP1:	PUT	MASTOUT		;WRITE OUTPUT
	JMP	LOOP		;DO ENTIRE FILE
;
;ALL DONE - WRITE EOF TO OUTPUT, ASK IF MORE TO DO
;
ALLDONE	MVI	A,'Z'-40H 	;EOF CHAR
	PUT	MASTOUT
	FINIS	MASTOUT
	FINIS	MASTIN
;
	CALL	ILPRT
	DB	CR,LF,'FUNCTION COMPLETE',CR,LF,0
	JMP	EXIT
;
;INLINE PRINT SUBROUTINE
;
ILPRT	XTHL		;GET STARTING ADDR OF STRING TO HL
ILPLP	MOV	A,M
	PUSH	H
	PUT	CON
	POP	H
	INX	H
	MOV	A,M
	ORA	A
	JNZ	ILPLP
	INX	H
	XTHL		;RETURN ADDR TO TOP OF STACK 
	RET
;
CRLF:	CALL	ILPRT		;CARRIAGE RET - LINE FEED
	DB	CR,LF,0
	RET
;
;EXIT WITH ERROR MESSAGE
EREXIT	CALL	CRLF
	POP	D		;ADDRESS OF TEXT TO DE
	MVI	C,PRINT
	CALL	BDOS
EXIT	JMP	$-$		;TO CP/M RETURN ADDR
;
NOMAST	CALL	EREXIT
	DB	BEL,'++MISSING OR EMPTY MAST.CAT',0
NOIGN	CALL	EREXIT
	DB	BEL,'++NO IGNORE NAMES IN MAST.CAT',0
IGNEOF	CALL	EREXIT
	DB	BEL,'++EOF READING FOR IGNORE NAMES.'
	DB	0DH,0AH,'MAY BE MISSING ")" AFTER LAST NAME.',0
;
	DS	80	;LOTSA STACK SPACE (40 LEVELS)
STACK	EQU	$
;
BUFFERS	EQU	$		;USED BY SEQIO
MEMSIZE	EQU	BUFFERS+@NXTB
;
;BDOS/CBIOS EQUATES 
PRINT	EQU	9
BDOS	EQU	5

CR	EQU	0DH
LF	EQU	0AH
BEL	EQU	07H

	END	NEWCAT



