;
;		   DYNABYTE MEMORY TEST
;		    (Revised 10/15/79)
;
;Converted for CP/M and error msgs by Keith Petersen.
;Does not use CP/M for I/O so that all of memory above
;this program may be tested.
;
;EQUATES
;
MEMSIZE	EQU	48	;48K MEMORY SIZE
;
SIZE	EQU	((MEMSIZE*1024) SHR 8)-2
;
;DEFINE I/O PORTS
;
STATUS	EQU	02H	;UART STATUS PORT
DATA	EQU	03H	;UART DATA PORT
TBE	EQU	80H	;UART READY FOR CHAR. BIT
;
	ORG	100H
;
START:	LXI	SP,$+256 ;SET STACK POINTER
;
INITL:	LXI	D,0	;SET DE TO ZERO
	LXI	H,BEGIN	;SET BEGINNING ADDRESS
	MOV	B,C	;GET FIRST PATTERN
;
WRITE:	MOV	M,B	;WRITE A BYTE
	INX	H	;INCREMENT ADDRESS
	INX	D	;INCREMENT COUNT
	DCR	B	;CHANGE DATA
;
;HAVE WE DONE A COMPLETE PASS OF WRITES?
;
	MVI	A,SIZE	;SIZE OF TEST
	CMP	D	;COMPARE SIZE WITH D
	JNZ	WRITE	;IF NOT EQUAL, WRITE MORE
;
;IF EQUAL, DO READS.
;
READ:	MVI	D,0	;SET D TO 0. E IS ALREADY.
	LXI	H,BEGIN	;GET BEGINNING ADDRESS
	MOV	B,C	;GET FIRST DATA PATTERN
;
REREAD:	MOV	A,M	;READ A BYTE
	CMP	B	;COMPARE WITH CORRECT DATA
	CNZ	ERROR	;NOT EQUAL, PRINT ERROR MSG
	INX	H	;INCREMENT ADDRESS
	DCR	B	;CHANGE DATA
	INX	D	;INCREMENT COUNT
	MVI	A,SIZE	;PUT SIZE IN A
	CMP	D	;COMPARE WITH COUNT
	JNZ	REREAD	;NOT EQUAL? KEEP READING.
	INR	C	;CHANGE BEGINNING PATTERN
	JMP	INITL	;START OVER
;
ERROR:	PUSH	PSW	;SAVE DATA
	CALL	ADROUT	;PRINT BAD ADDRESS
	CALL	SPACE	;SPACE ONCE ON PRINTER
	MOV	A,B	;GET CORRECT DATA
	CALL	HEXO	;PRINT IT
	CALL	SPACE	;SPACE ONCE ON PRINTER
	POP	PSW	;GET BACK READ DATA
	CALL	HEXO	;PRINT BAD DATA
;NOW TURN UP A NEW LINE
	MVI	A,0DH	;CARRIAGE RETURN
	CALL	TYPE	;TYPE IT
	MVI	A,0AH	;LINE FEED
	JMP	TYPE	;TYPE IT AND RETURN
;
ADROUT:	MOV	A,H	;GET HIGH ORDER ADRS
	CALL	HEXO	;PRINT IT IN HEX
	MOV	A,L	;GET LOW, PRINT IT IN HEX
;
HEXO:	PUSH	PSW	;SAVE FOR RIGHT DIGIT
	RAR		;RIGHT..
	RAR		;..JUSTIFY..
	RAR		;..LEFT..
	RAR		;..DIGIT..
	CALL	NIBBL	;PRINT LEFT DIGIT
	POP	PSW	;RESTORE RIGHT
NIBBL:	ANI	0FH	;ISOLATE DIGIT
	CPI	10	;IS IS <10?
	JC	ISNUM	;YES, NOT ALPHA
	ADI	7	;ADD ALPHA BIAS
ISNUM:	ADI	'0'	;MAKE PRINTABLE
	JMP	TYPE	;..THEN TYPE IT
;
SPACE:	MVI	A,' '	;OUTPUT A SPACE
;
TYPE:	PUSH	PSW	;SAVE CHARACTER
	IN	STATUS	;GET UART STATUS
	ANI	TBE	;READY FOR CHAR?
	JZ	TYPE+1	;NO, LOOP AND WAIT
	POP	PSW	;GET CHAR BACK
	OUT	DATA	;OUTPUT IT
	RET
;
BEGIN	EQU	START+256 ;START ADDRESS OF TEST
;
	END

