0001 IDENTIFICATION DIVISION.
0002 PROGRAM-ID.
0003     EZCHECK.
0004* this program reads a sequential file containing checking
0005* account data and outputs to the printer a listing with
0006* updated balances, # transactions, total $ dep,
0007* and total $ value of checks processed.
0008 AUTHOR.
0009     STEVE SANDERS.
0010 DATE-WRITTEN.
0011     MAY 17, 1983.
0012 DATE-COMPILED.
0013     JUNE 10, 1983.
0014 SECURITY.
0015     NONE.
0016 ENVIRONMENT DIVISION.
0017 CONFIGURATION SECTION.
0018 SOURCE-COMPUTER.
0019     KAYPRO-II-Z80A.
0020 OBJECT-COMPUTER.
0021     ANY-Z80A-8080-CPU.
0022 INPUT-OUTPUT SECTION.
0023 FILE-CONTROL.
0024     SELECT CKFILE1 ASSIGN TO INPUT DISK
0025       ORGANIZATION IS SEQUENTIAL
0026       ACCESS IS SEQUENTIAL
0027       RECORD DELIMITER IS STANDARD.
0028     SELECT PRINT-OUT ASSIGN TO OUTPUT PRINTER.
0029 DATA DIVISION.
0030 FILE SECTION.
0031 FD  CKFILE1
0032     LABEL RECORDS ARE STANDARD
0033     VALUE OF FILE-ID IS FILE-IN
0034     BLOCK CONTAINS 1 RECORD
0035     DATA RECORD IS CHECK-IN.
0036 01  CHECK-IN.
0037     02 DATE-IN                     PIC X(8).
0038     02 FILLER                      PIC X(2).
0039     02 CHECK-NO-IN                 PIC X(3).
0040     02 FILLER                      PIC X(2).
0041     02 DESCRIPTION-IN              PIC X(20).
0042     02 FILLER                      PIC X(2).
0043     02 AMOUNT-IN                   PIC 9999V99.
0044     02 FILLER                      PIC X(37).
0045 FD  PRINT-OUT
0046     LABEL RECORDS ARE STANDARD
0047     VALUE OF FILE-ID IS "PRINTER"
0048     DATA RECORD IS PRINT-REC.
0049 01  PRINT-REC                      PIC X(133).
0050 WORKING-STORAGE SECTION.
0051 01  FILE-IN                        PIC X(14) VALUE
0052                                      "A:CKFILE1.MAS".
0053 01  HEAD-1.
0054     02 FILLER                      PIC X(30) VALUE SPACES.
0055     02 ITEM-1                      PIC X(20) VALUE
0056                                      "ELECTRONIC CHECKBOOK".
0057     02 FILLER                      PIC X(83) VALUE SPACES.
0058 01  HEAD-2.
0059     02 ITEM-2                      PIC X(4) VALUE "DATE".
0060     02 FILLER                      PIC X(10) VALUE SPACES.
0061     02 ITEM-3                      PIC X(9) VALUE
0062                                      "CHECK NO.".
0063     02 FILLER                      PIC X(8) VALUE SPACES.
0064     02 ITEM-4                      PIC X(11) VALUE
0065                                      "DESCRIPTION".
0066     02 FILLER                      PIC X(12) VALUE SPACES.
0067     02 ITEM-5                      PIC X(6) VALUE "AMOUNT".
0068     02 FILLER                      PIC X(7) VALUE SPACES.
0069     02 ITEM-6                      PIC X(7) VALUE "BALANCE".
0070     02 FILLER                      PIC X(59) VALUE SPACES.
0071 01  CHECK-LINE.
0072     02 DATE-OUT                    PIC X(8) VALUE ZEROES.
0073     02 FILLER                      PIC X(8) VALUE SPACES.
0074     02 CHECK-NO-OUT                PIC X(3) VALUE ZEROES.
0075     02 FILLER                      PIC X(12) VALUE SPACES.
0076     02 DESCRIPTION-OUT             PIC X(20).
0077     02 FILLER                      PIC X(2) VALUE SPACE.
0078     02 AMOUNT-OUT                  PIC ZZZZ.99 VALUE     
0079                                       ZEROES.
0080     02 FILLER                      PIC X(7) VALUE SPACES.
0081     02 BALANCE-OUT                 PIC ZZZZ.99 VALUE
0082                                       ZEROES.
0083     02 FILLER                      PIC X(60) VALUE SPACES.
0084 01  DATA-LINE.
0085     02 ITEM-7                      PIC X(16) VALUE
0086                                    "TRANS PROCESSED ".
0087     02 NO-TRANS-OUT                PIC 999 VALUE ZEROES.
0088     02 FILLER                      PIC X(114) VALUE SPACES.
0089 01  DEPOSITS.
0090     02 ITEM-8                      PIC X(17) VALUE
0091                                    "TOTAL DEPOSITS   ".
0092     02 DEP-TOTAL-OUT               PIC $ZZZZ.99 VALUE
0093                                       ZEROES.
0094     02 FILLER                      PIC X(109) VALUE SPACES.
0095 01  CHECKS.
0096     02 ITEM-9                      PIC X(17) VALUE
0097                                    "TOTAL CHECKS     ".
0098     02 CHECK-TOTAL-OUT             PIC $ZZZZ.99 VALUE
0099                                      ZEROES.
0100     02 FILLER                      PIC X(109) VALUE SPACES.
0101 01  FOOTER.
0102     02 FILLER                      PIC X(31) VALUE SPACES.
0103     02 ITEM-10                     PIC X(17) VALUE
0104                                      "END OF LISTING...".
0105     02 FILLER                      PIC X(85) VALUE SPACES.
0106 01  SUMMARY.
0107     02 FILLER                      PIC X(20) VALUE SPACES.
0108     02 ITEM-11                     PIC X(27) VALUE
0109                              "SUMMARY OF CHECKING ACCOUNT".
0110     02 ITEM-12                     PIC X(13) VALUE
0111                                     " TRANSACTIONS".
0112     02 FILLER                      PIC X(73) VALUE SPACES.
0113 01  START-BALANCE.
0114     02 ITEM-13                     PIC X(17) VALUE
0115                                   "STARTING BALANCE ".
0116     02 BALANCE2-OUT                PIC $ZZZZ.99 VALUE
0117                                       ZEROES.
0118 01  CREDIT.
0119     02 ITEM-14                     PIC X(17) VALUE
0120                                   "TOTAL CREDIT     ".
0121     02 CREDIT-OUT                  PIC $ZZZZ.99 VALUE
0122                                       ZEROES.
0123     02 FILLER                      PIC X(109) VALUE SPACES.
0124 01  END-BALANCE.
0125     02 ITEM-15                     PIC X(17) VALUE
0126                                   "ENDING BALANCE   ".
0127     02 BALANCE1-OUT                PIC $ZZZZ.99 VALUE
0128                                       ZEROES.
0129     02 FILLER                      PIC X(109) VALUE SPACES.
0130 01  NO-PAGE.
0131     02 FILLER                      PIC X(37) VALUE SPACES.
0132     02 ITEM-16                     PIC X(5) VALUE
0133                                     "PAGE ".
0134     02 PAGE-NO-OUT                 PIC 99 VALUE ZEROES.
0135     02 FILLER                      PIC X(89) VALUE SPACES.
0136 77  BALANCE-IN                     PIC 9999V99 VALUE
0137                                       ZEROES.
0138 77  BALANCE                        PIC 9999V99 VALUE
0139                                       ZEROES.
0140 77  TRANS-COUNTER                  PIC XXX VALUE ZEROES.
0141 77  CHECK-TOTAL-IN                 PIC 9999V99 VALUE ZEROES.
0142 77  DEP-TOTAL-IN                   PIC 9999V99 VALUE ZEROES.
0143 77  BALANCE2                       PIC 9999V99 VALUE ZEROES.
0144 77  LINE-COUNT                     PIC 999 VALUE ZEROES.
0145 77  BAL1-IN                        PIC 9999V99 VALUE ZEROES.
0146 77  CREDIT-IN                      PIC 9999V99 VALUE ZEROES.
0147 77  PAGE-COUNT                     PIC 99 VALUE 01.
0148 77  X1                             PIC 9 VALUE ZERO.
0149 PROCEDURE DIVISION.
0150 START-PAR.
0151     DISPLAY "ENTER INPUT FILE ".
0152     DISPLAY FILE-IN WITH NO ADVANCING.
0153     ACCEPT FILE-IN.
0154     DISPLAY "ENTER STARTING BALANCE (807.48 = 080748)  ".
0155     ACCEPT BALANCE.
0156     MOVE BALANCE TO BALANCE2.
0157     OPEN OUTPUT PRINT-OUT.
0158     OPEN INPUT CKFILE1.
0159 HEAD-PAR.
0160     MOVE SPACES TO PRINT-REC.
0161     MOVE HEAD-1 TO PRINT-REC.
0162     WRITE PRINT-REC BEFORE ADVANCING 2 LINES.
0163     MOVE PAGE-COUNT TO PAGE-NO-OUT.
0164     MOVE NO-PAGE TO PRINT-REC.
0165     WRITE PRINT-REC BEFORE ADVANCING 2 LINES.
0166     MOVE HEAD-2 TO PRINT-REC.
0167     WRITE PRINT-REC BEFORE ADVANCING 2 LINES.
0168 CHECK-PAR.
0169     READ CKFILE1 AT END GO TO DATA-PAR.
0170     IF DATE-IN = "XXXXXXXX" GO TO DATA-PAR.
0171     MOVE DATE-IN TO DATE-OUT.
0172     MOVE CHECK-NO-IN TO CHECK-NO-OUT.
0173     MOVE DESCRIPTION-IN TO DESCRIPTION-OUT.
0174     IF CHECK-NO-IN IS NOT NUMERIC
0175       ADD AMOUNT-IN TO BALANCE
0176       GIVING BALANCE-IN
0177     ELSE
0178       SUBTRACT AMOUNT-IN FROM BALANCE 
0179       GIVING BALANCE-IN.
0180     IF CHECK-NO-IN IS NUMERIC
0181       ADD AMOUNT-IN TO CHECK-TOTAL-IN
0182     ELSE
0183       ADD AMOUNT-IN TO DEP-TOTAL-IN.
0184     MOVE AMOUNT-IN TO AMOUNT-OUT.
0185     MOVE BALANCE-IN TO BALANCE-OUT.         
0186     MOVE BALANCE-IN TO BALANCE.
0187     MOVE CHECK-LINE TO PRINT-REC.
0188     WRITE PRINT-REC BEFORE ADVANCING 1 LINE.
0189     MOVE ZEROES TO BALANCE-IN.
0190     ADD 1 TO TRANS-COUNTER.
0191     ADD 1 TO LINE-COUNT.
0192     IF LINE-COUNT > 52
0193       ADD 1 TO X1
0194       MOVE SPACE TO PRINT-REC
0195       WRITE PRINT-REC BEFORE ADVANCING PAGE
0196       MOVE HEAD-1 TO PRINT-REC
0197       WRITE PRINT-REC BEFORE ADVANCING 2 LINES
0198       ADD 1 TO PAGE-COUNT
0199       MOVE PAGE-COUNT TO PAGE-NO-OUT
0200       MOVE NO-PAGE TO PRINT-REC
0201       WRITE PRINT-REC BEFORE ADVANCING 2 LINES
0202       MOVE HEAD-2 TO PRINT-REC
0203       WRITE PRINT-REC BEFORE ADVANCING 2 LINES 
0204       MOVE ZEROES TO LINE-COUNT
0205       GO TO CHECK-PAR
0206     ELSE
0207     GO TO CHECK-PAR.
0208 DATA-PAR.
0209     ADD BALANCE2 TO DEP-TOTAL-IN
0210       GIVING CREDIT-IN.
0211     SUBTRACT CHECK-TOTAL-IN FROM CREDIT-IN
0212       GIVING BAL1-IN.
0213     MOVE SPACE TO PRINT-REC.
0214     WRITE PRINT-REC BEFORE ADVANCING 2 LINES.
0215     MOVE FOOTER TO PRINT-REC.
0216     IF LINE-COUNT > 40
0217       WRITE PRINT-REC BEFORE ADVANCING PAGE
0218       ADD 1 TO PAGE-COUNT
0219     ELSE
0220       WRITE PRINT-REC BEFORE ADVANCING 2 LINES.
0221     MOVE SPACE TO PRINT-REC.
0222     IF PAGE-COUNT > 1 AND X1 > 0
0223       MOVE HEAD-1 TO PRINT-REC
0224       WRITE PRINT-REC BEFORE ADVANCING 2 LINES
0225     ELSE
0226       MOVE HEAD-1 TO PRINT-REC
0227       WRITE PRINT-REC BEFORE ADVANCING 2 LINES
0228       MOVE PAGE-COUNT TO PAGE-NO-OUT
0229       MOVE NO-PAGE TO PRINT-REC
0230       WRITE PRINT-REC BEFORE ADVANCING 2 LINES.
0231     MOVE SUMMARY TO PRINT-REC.
0232     WRITE PRINT-REC BEFORE ADVANCING 3 LINES.
0233     MOVE TRANS-COUNTER TO NO-TRANS-OUT.
0234     MOVE DATA-LINE TO PRINT-REC.
0235     WRITE PRINT-REC BEFORE ADVANCING 2 LINES.
0236     MOVE BALANCE2 TO BALANCE2-OUT.
0237     MOVE START-BALANCE TO PRINT-REC.
0238     WRITE PRINT-REC BEFORE ADVANCING 1 LINE.
0239     MOVE DEP-TOTAL-IN TO DEP-TOTAL-OUT.
0240     MOVE DEPOSITS TO PRINT-REC.
0241     WRITE PRINT-REC BEFORE ADVANCING 1 LINE.
0242     MOVE CREDIT-IN TO CREDIT-OUT.
0243     MOVE CREDIT TO PRINT-REC.
0244     WRITE PRINT-REC BEFORE ADVANCING 1 LINE.
0245     MOVE CHECK-TOTAL-IN TO CHECK-TOTAL-OUT.
0246     MOVE CHECKS TO PRINT-REC.
0247     WRITE PRINT-REC BEFORE ADVANCING 2 LINES.
0248     MOVE BAL1-IN TO BALANCE1-OUT.
0249     MOVE END-BALANCE TO PRINT-REC.
0250     WRITE PRINT-REC BEFORE ADVANCING PAGE.
0251 END-PAR.
0252     CLOSE CKFILE1.
0253     CLOSE PRINT-OUT.
0254     STOP RUN.
0255 END PROGRAM EZCHECK.
   CING 2 LINES.
0231     MOVE SUMMARY TO PRINT-REC.
0232     WRITE PRINT-REC BEFORE ADVANCING 3 LINES.
0233     MOVE TRANS-C