/****************************************************************
 *   Metal User edit/add routines for METAL version 1.10e 	*
 *                                                              *
 *	FILE: MUTIL.C version 1.10e				*
 *								*
 *		Copyright (c) 1984 Tim Gary			*
 *		    Delphi Data Systems				*
 *		    All rights reserved				*
 *								*
 ****************************************************************
 *								*
 * 1.20a 11/07/84  More work on the ADD command (gcntrs change)	*
 * 1.10e 11/03/84  # calls initialized in ADD			*
 * 1.10e 10/30/84  User width initialized.			*
 * 1.10a  9/12/84  Cosmetic fixes.				*
 * 1.10a  9/08/84  Cosmetic fixes.				*
 * 1.10a  9/01/84  Split from mutil for overlay Metal.		*
 *								*
 * 1.01a  6/10/84  Fixed for Aztec C 1.06.			*
 *								*
 * 1.0b	  4/13/84  Fixed for upper/lower case names.		*
 *								*
 ****************************************************************/

#include "xpm.h"
#include "hmh.h"
#include "hmconfg.h"
#include "ctype.h"

static int dead_rec_no=0;	/* for deleted user */
static int dead_user_no=0;	

/* main program */

ovmain(func,parm)
int func;
char *parm;
{

if (user.status==SYSOP)
	switch(func) {
		case ADDUSER:
			adduser(parm);
			break;
		case DELETEUSER:
			deleteuser(parm);
			break;
		case EDITUSER:
			edituser(parm);
			break;
		default:
			send("ERROR: User function not supported.\n");
			break;
		}

/* if public user routines are added, they go after an 'else' here */

}	/* main */


edituser(name)
char *name;
{
register int cfast;
char temp[MAXLINE+1];
usr *up;

users=open(USERFILE,F_RD | F_UNLOCK);

if (users==NULL) {
         send("Users file not present");
         return ERROR;
         }

if (name) printf("Edit %s.",name);

do {
	if (!name) send("Edit ");
	if ((cfast=finduser(name))==ERROR) break;
	if (cfast==FALSE)
		continue;

up=bufloc(users);

/**********************************
 * begin editing user             *
 *********************************/

send("\nHit return if no change, if you make a mistake, you will have a\nchance to abort before the information gets saved.\n");

      do {

       do {
         sprintf(buffer,"User name: %s %s : ",up->first,up->last);
	 sepstr=' ';
         ask(buffer,temp,FNAMELEN,UPLOW);
	 sepstr='\0';
         if (*temp!='\0')
                 {
		 capstr(temp);
                 if (isdigit(*temp))
                     {
                     send("First char can't be numeric!");
                     continue;
                     }
                 else {
                      strcpy(up->first,temp);
                      break;
                      }

                 }
          } while (*temp!='\0');


if (*temp) do {
		sprintf(buffer,"Last name: %s : ",up->last);
		ask(buffer,temp,LNAMELEN,UPLOW);
		if (*temp!='\0')
			{
			capstr(temp);
			strcpy(up->last,temp);
			break;
			}
		} while (*temp!='\0');

	sprintf(buffer,"City: %s : ",up->city);
	ask(buffer,temp,CITYLEN,UPLOW);
	capstr(temp);
	if (*temp!='\0') strcpy(up->city,temp);

	do {
	   sprintf(buffer,"Password: %s : ",up->pass);
	   ask(buffer,temp,PASSLEN,UP);
	   if (*temp!='\0')
		{
		if (isdigit(*temp))
			{
			send("First char can't be numeric!");
			continue;
			}
		else {
		     strcpy(up->pass,temp);
		     break;
		     }

		}
	    } while (*temp!='\0');

       do {
         sprintf(buffer,"Status: '%c' (%s)  :",up->status,up->status==SYSOP ?
         "SYSOP" : up->status==SPECIAL ? "SPECIAL" : up->status==NORMAL ?
        "NORMAL" : up->status==NOCPM ? "NO CP/M" : 
	up->status==TWIT ? "*TWIT*" : "OTHER");
         ask(buffer,temp,10,UPLOW);
	 if (*temp=='\0') continue;
	 if (!index("+snxXabc",*temp))
                 {
                 send("Invalid status, try:\n'+' for SYSOP     's' for SPECIAL\
\n'n' for NORMAL\t'x' for NO CP/M\n'X' for TWIT\
\nor 'a','b' or 'c' for user defined types\n");
                 continue;
                 }
           else {
		up->status=*temp;
		up->type=get_type(up->status);
		break;
		}
         } while (*temp!='\0');

         ask("Is all info now correct (RETURN to retry same user)?",temp,3,UP);
         if (*temp=='\0') continue;
         if (*temp=='N')
                 {
                 ask("Do you wish to abort editing this user?",temp,2,UP);
                 if (*temp=='Y') break;
                 continue;
                 }
         if (*temp=='Y') {
                 send("<Saving user>\n");
		 setrrec(users,-1);		/* backup one */
		 write(users,0);		/* write new version */
                 break;
                 }
         else {
              send("Retrying");
              continue;
              }

         } while (1);          /* seemingly endless loop */
} while (!name);                   /* main edit-user loop */

close(users);
}        /* edituser */


deleteuser(name)
char *name;
{
register int cfast,rec;
char temp[MAXLINE];
usr *up;

if (name) printf("Delete %s.",name);

do {

users=open(USERFILE,1);

if (users==NULL) {
         send("\nUsers file not present.\n");
         return ERROR;
         }

if (!name) send("\nDelete ");
if ((cfast=finduser(name))==ERROR) break;
if (cfast==FALSE) break;

up=bufloc(users);
if (up->number==1)
	send("\nUser #1 may not be deleted, use EDIT to change it.\n");
  else	{
	setrrec(users,-1);              /* back up one.. */
	send("<deleting>\n");
	up->number=0;
	write(users,0);
	}
close(users);

  } while (!name);   /* main loop */

}        /* deleteuser */


finduser(name)
char *name;
{
register int cfast;
char temp[MAXLINE+1];
usr *up;

if (!name) {
	ask("user (# or FULL name)?",temp,MAXLINE,UP);
	if (*temp=='\0') return ERROR;          /* exit to main */
	}
	else strcpy(temp,name);

/* ok.. now check if name entered, or user number */

up=bufloc(users);
setarec(users,0);	/* fix for search, if any */

send("\n[Searching..");
while ((cfast=read(users,1))==128)
         {
	 if (!(getrec(users)%25)) putchar('.');
         cfast=128;
	 if (up->number!=0) {
	         if (isdigit(*temp)) if (up->number==atoi(temp)) break;
        	 if (!isdigit(*temp))
                	 {
	                 sprintf(buffer,"%s %s",up->first,up->last);
        	         if (!ustrcmp(temp,buffer)) break; /* found him */
                	 }
		}
         }
if (cfast!=128)
        {
        send("\n[User not found]\n");
        return FALSE;
        }
putchar(']');	/* make things look neato */
return TRUE;
}


adduser(nada)
int nada;
{
register int cfast;				/* fast c variable	*/
char first[FNAMELEN+1],last[LNAMELEN+1];	/* temp name	*/
char temp[MAXLINE+1];
unsigned tu;
usr *up;

gcntrs(0);	/* get counters (date) */

do {
  sepstr=' ';
  ask("User name? ",first,FNAMELEN,UPLOW);
  sepstr='\0';
  if (*first=='\0') break;
  capstr(first);

  ask("Last name? ",last,LNAMELEN,UPLOW);
  if (*last=='\0') break;
  capstr(last);

  if ((users=open(USERFILE,1))!=NULL)
     {					/* open users file, and create it
						if it doesn't exist now */
  up=bufloc(users);
  dead_user_no=dead_rec_no=up->number=0;	/* clear these */

  do	{
	tu=up->number;
	cfast=read(users,1);		/* read and increment record counter */
	if (cfast!=128) break;		/* exit loop if eof */

	/* get desired info from users file... */

	if (dead_rec_no==0) dead_user_no=tu;

	if (up->number==0 && dead_rec_no==0)
		{
		dead_user_no++;	/* make the user one after last ok one */
		dead_rec_no=getrec(users)-1;
		}

	/* see if a match of either name or user number */

	  if (  up->number && ((ustrcmp(first,up->first)==0)
		  && (ustrcmp(last,up->last)==0)) )
		{
		send("\nUser Exists, use 'E'dit to change info.\n");
		break;		/* exit this loop and ask for name again */
		}

	} while (cfast==128);	/* read do loop ends */

	close(users);	/* close it... */
    }	/* good open loop */

/* user not found, get new user, location and password */

	if (cfast!=128)
		newuser(first,last);    /* newuser or bad name */

} while (1);	/* new user loop */

}


/**/
/* this routine checks if mistaken name, or gets new user's info	*/
/**/

newuser(first,last)
char *first,*last;
{
register int cfast;
char temp[MAXLINE+1];
usr userbuf;

setmem(&userbuf,128,0);		/* zero out buffer */

  ask("\nCity, State? ",userbuf.city,CITYLEN,UPLOW);
  if (userbuf.city[0]=='\0') return ERROR;   /* not entered, get name again */
  capstr(userbuf.city);

  printf("\nUser is %s %s from %s", first,last,userbuf.city);
  ask("\nRight? ",temp,1,UP);
  if (*temp=='N') return ERROR;

  do	{
 	ask("\nPassword? ",temp,PASSLEN,UP);
	if (*temp=='\0') return ERROR;
	if (isspc(temp)) {
			 send("\nSpaces aren't allowed in passwords!!\n");
			 continue;	/* ask again... */
			 }
	if (isdigit(*temp))
			{
			send("\nThe first character must NOT be numeric!!\n");
			continue;
			}
	break;
	} while (1);

users=open(USERFILE,1);	/* open for r/w */

if (dead_rec_no!=0) userbuf.number=dead_user_no;
	else {
	     toeof(users);
	     setrrec(users,-1);		/* backup one */
	     if (read(users,1)!=128)
		{
		toeof(users);
		userbuf.number=1;
		}
	 	else {
		     usr *up;
		     up=bufloc(users);
		     userbuf.number=up->number+1;
		     }
		}

  printf("\nUser number is %u.\n",userbuf.number);

  strcpy(userbuf.first,first);	strcpy(userbuf.last,last);
  strcpy(userbuf.pass,temp);
  strcpy(&userbuf.parm.ulcase,"0000110");     /* initial user parms.. */
  userbuf.lastread=0;
  userbuf.status=NORMAL;	userbuf.type=get_type(userbuf.status);
  userbuf.parm.height=24;
  userbuf.parm.width=0;
  userbuf.parm.calls=1;
  getdate();
  strcpy(userbuf.date,date);
  strcpy(userbuf.time,time);

if (dead_rec_no!=0)
	setarec(users,dead_rec_no);

  movmem(&userbuf,bufloc(users),128);
  write(users,1);
  close(users);

  return NULL;		/* got a new usr ok.. */

}	/* newuser */


/* End of file */

