/****************************************************************
 *   Metal Sysop Routines for METAL version 1.20a 		*
 *                                                              *
 *	FILE: MESYSOP.C version 1.20a				*
 *								*
 *		Copyright (c) 1984 Tim Gary			*
 *		    Delphi Data Systems				*
 *		    All rights reserved				*
 *								*
 ****************************************************************
 * 1.20a 11/07/84  Purge message after effects muffled.		*
 * 1.20a 11/04/84  Few more safeguards added.			*
 * 1.10e 11/03/84  Ho hum, added info about disk reset, etc..	*
 * 1.10e 11/02/84  Make purge function work!.. (after yesterday)*
 * 1.10e 11/01/84  Reset disk performed before purge..		*
 * 1.10e 10/31/84  Added sostat() and readcomm().		*
 *		  Fixed purge messages to allow seperate output *
 *		  drive for message file.			*
 * 1.10c 10/12/84  Modified to use msg[] table for reply/parent	*
 *		  in case of conficts found earlier.		*
 * 1.10b  <none>						*
 * 1.10a  9/26/84  Fixed purge to allow messages on drives	*
 *		  than A:					*
 * 1.10a  9/01/84  Split from mutil.c for overlay Metal.	*
 *								*
 * 1.01c  8/16/84  Improved bad record handling, and patchup.	*
 *								*
 * 1.01b  8/03/84  Fixed to handle message purge cases when a	*
 *		  summary file is unavailable, or destroyed..	*
 *		  This is handled by removing or renaming the	* 
 *		  the destroyed summary file, and index will be	*
 *		  built from message file directly.		*
 *								*
 * 1.01a  6/10/84  Fixed for Aztec C 1.06.			*
 *								*
 ****************************************************************/

#include "xpm.h"
#include "hmh.h"
#include "hmconfg.h"
#include "ctype.h"

/* Main dispatcher */

ovmain(func,parm)
int func,parm;
{

switch (func)
	{
	case PURGE:
		if (user.status!=SYSOP) return;
		return destroy(parm);
	case SOSTAT:
		return sostat(parm);
	case READCOMM:
		return readcomm(parm);
	default:
		send("\nUnknown overlay function called for.\n");
		break;
	}

return ERROR;
}	/* main */


FILE *msource,*mdest;

destroy(parm)
 int parm;
{
int tindex;
char temp[50],msgdest[30],sumdest[30],countdest[30],*tp,newdrive[10];
msg_record *mptr;

if (!lmsg) {
	send("\nNo messages to purge.\n");
	return;
	}

msource=open(MESSAGES,0);

printf("\nThere are %d active messages, and %d deleted messages (unpurged).\n",
	msgcount,mindex-msgcount);
if (msource)
	{
	toeof(msource);
	printf("\nMessage file now %dk",(getrec(msource)+7)/8);
	}
if (summary=open(SUMMARY))
	{
	toeof(summary);
	printf(",  Summary file is %dk\n",(getrec(summary)+7)/8);
	close(summary);
	}

close(msource);		/* cause gotta close for reset disk */

ask("\n\nPurge messages (y/n) ?",temp,1,UP);
if (*temp!='Y') return;

send("\nPress any key to perform a disk reset and continue.\n(swap disks NOW if you need to!) --> ");
getchar();

reset_disk(0);
msource=open(MESSAGES,0);
mptr=bufloc(msource);

*newdrive='\0';	/* nothing */

do {
   ask("\n\nUser area/Drive to place new files on ( uu/d: )\n(RETURN=same as message source files)? ",temp,8,UP);
   if (index(temp,':') || index(temp,'/'))
	{
	sprintf(buffer,"\nNew user/drive = '%s', ok (y/n)? ",temp);
	ask(buffer,temp+10,2,UP);
	if (temp[10]=='Y')
		{
		strcpy(newdrive,temp);	/* put in place */
		break;
		}
	continue;
	}
     else if (*temp=='\0') break;
    } while (1);

send("\n\n[Purging messages]\n");

if (!*newdrive)
	{
	rename(SUMMARY,"summary.bak");	/* backup of summary file */
	summary=open(SUMMARY,1);	/* make new summary file  */
	}
  else {
       sprintf(sumdest,"%ssummary",newdrive);
       unlink(sumdest);		/* make sure no file previously */
       summary=open(sumdest,1);
       }

*msgdest='\0';
if (tp=index(MESSAGES,':'))	/* THIS = IS ON PURPOSE !!! */
	{
	strncpy(msgdest,MESSAGES,tp-MESSAGES+1);
	msgdest[tp-MESSAGES+1]='\0';	/* terminate */
	}

if (*newdrive)
	{
	sprintf(msgdest,"%smessages",newdrive);
	sprintf(countdest,"%scounters",newdrive);
	unlink(countdest);	unlink(msgdest);
	}
  else
	{
	strcat(msgdest,"messages.new");
	rename(COUNTERS,"counters.bak");	/* backup counters */
	*countdest='\0';
	}

if (*newdrive)
	printf("\nOutput message file is %s.\nOutput summary file is %s.\n\
Output counters file is %s.\n",msgdest,sumdest,countdest);

mdest=open(msgdest,1);

if (!(msource && mdest && summary))
	{
	printf("\nCan't open all files...\nMESSAGES=%s  NEWMESS=%s  SUMMARY=%s \n\n",
	msource ? "<open>" : "<Couldn't open>",
	mdest ? "<open>" : "<Couldn't open>",
	summary ? "<open>" : "<Couldn't open>");
	close(msource); close(mdest); close(summary);
	return;
	}

sprintf(bufloc(summary),"%u",msgcount);
write(summary,1);

tindex=0;
while (tindex<mindex)
	{
	setarec(msource,msg[tindex].seek);	/* fix if bad recs.. */
	read(msource,1);	/* into buffer pointed to by mptr */
	if (mptr->status!=DEADMSG) wrtmsg(mdest,tindex); /* output to file */
	   else	msg[tindex].number=0;	/* make this guy REALLY dead */
	++tindex;
	}

printf("\n\nMessage file now %dk,  Summary file is %dk\n\n[Finishing up]\n",
	(getrec(mdest)+7)/8,(getrec(summary)+7)/8);

close(mdest);
close(summary);
close(msource);
if (!*newdrive)
	{
	rename(MESSAGES,"messages.bak");	/* backup message file */
	rename(msgdest,MESSAGES);
	}

pcounters(*countdest ? countdest : 0);	/* write new counters file */

send("\nPress any key to return to command mode.\n(swap disks back NOW if you need to!) --> ");
getchar();
reset_disk(0);		/* make sure buffers flushed */

printf("\n\n[done]\n");

} /* destroy */


wrtmsg(fil,tindex)
 FILE *fil;
 int tindex;
{
msg_record *mptr;
int lines;
unsigned rseek,eseek;

mptr=bufloc(msource);
sprintf(buffer,"\r[Processing %5u]",mptr->number);
send(buffer);

msg[tindex].seek=mptr->seek=getrec(fil);	/* fix seek loc 	   */
mptr->parent=msg[tindex].parent;		/* if bombed pointers, fix */
mptr->reply=msg[tindex].reply;			/* from msg_alert function */

movmem(bufloc(msource),bufloc(fil),128);	/* copy to output buffer   */
write(fil,1);
movmem(bufloc(msource),bufloc(summary),128);
write(summary,1);

lines=mptr->lines+1;
rseek=getrec(msource);		/* save location */
read(msource,1);
while (lines--) while (getc(msource)!='\n');  /* flush line */
eseek=getrec(msource);
setarec(msource,rseek);		/* go back to begining */

  while (getrec(msource)<eseek)
	{
	if (read(msource,1)!=128) break;
	movmem(bufloc(msource),bufloc(fil),128);
	write(fil,1);
	}

}	/* write message */


/***********************
 * Toggle sysop status * 
 ***********************/

extern char ostat,otype;	/* these are defined in metal.c */

sostat(n)
 register int n;
{
if (user.status==SYSOP) {
	if (ostat!=0) {
		user.status=ostat;
		user.type=otype;
		}  else {
			ostat=user.status=SPECIAL;
			otype=user.type=get_type(SPECIAL);
			}
		send("[Sysop status Off]");
		return;
		}
ask("Prove it! ",buffer,PASSLEN+1,UP+NOECHO);	/* why not */
if (!strcmp(buffer,O.SOPASS))
	{
	ostat=user.status;	/* save original status and type */
	otype=user.type;
	user.status=SYSOP;
	user.type=get_type(SYSOP);
	send("[Sysop status On]");
	}
}


/**************************
 * read comments function *
 **************************/

readcomm(n)
 register int n;
{
if (user.status!=SYSOP)	return;	/* special sysop functions.. */

if (type(COMMENTS)!=ERROR)
	{
	ask("[Purge comments file???]",buffer,2,UP);
	if (*buffer=='Y') { send("[purging]"); unlink(COMMENTS); }
	}

}


/* End of file */

