/***********************************************************************
 *
 *	Options/configuration file for METAL Version 1.10e
 *		and HMH.H version 1.10e
 *
 *	Copyright (c) 1984  Tim Gary
 *	Delphi Data Systems
 *	All rights reserved.
 *
 *	FILE: HMCONFG.H
 *
 **********************************************************************
 *
 * 1.10e 10/30/84
 * 1.10c 10/12/84  OVMISC from OVFEAT.  Changed order of files, and added
 *		  more room for expansion later without needing to
 *		  reconfigure the whole mess.
 * 1.10b <none>
 * 1.10a  9/01/84  Overlay files added.
 *
 * 1.01a  7/02/84  Multi_user id_loc pointer added.
 * 1.01a  6/10/84  Changed file structure, names include user/drive.
 *
 * 1.0c   5/17/84  Hayes support added. 
 *
 * 1.0b   4/18/84  Added default user status..
 *
 *	  4/13/84  Fixed RTC port order.  Added maximum total msgs allowed
 *		  variable and changed order of configuration variables.
 *
 *	  1/24/84  Broke apart HMH.H to form this file of configuration
 *		  only declarations.
 *
 *********************************************************************/


/************************************************************************
   Options are contained in this large structure, and are initialized
  here.  BE VERY VERY CAREFULL NOT TO DELETE A COMMA, OR OTHER SUCH
  PUNCTUATION IN THE DECLARATIONS, SINCE THE ORDER OF THINGS HAS EVERY-
  THING TO DO WITH THE WAY IT GETS INITIALIZED!!!!!!!!!!!		*/

struct	options	O
#ifdef MAIN
		 =	{	/* and off we go !! */

/************************************************************************
 * The following is the initializing of one HUGE structure of options	*
 ************************************************************************/

	"Zilch!!!!",	/* To allow config to do its job (DON'T TOUCH!!) */


/**********************************************************/
/******* OPTIONS that are likely to need changing.. *******/
/**********************************************************/

/*************************************************************************
 Each user is of a certian 'type'; here is where types are defined.
	In this order:
		1) Character to use as type identifier (DON'T CHANGE!)
		2) Maximum CP/M user area avaliable to him/her (0=no CP/M)
		3) Timeout before loging out, if idle (in mins, 0=no access)
		4) YES/NO flag, can he/she kill messages
		5) YES/NO flag, does he/she get ZCPR privs (era, save, etc)
		6) YES/NO flag, can the user read private msgs (not to them)?
		7) YES/NO flag, can the user post messages??		*/

/*	/--option #'s from above----\	*/
/*--------1-----2---3--4---5---6---7----*/
{	SYSOP,	15,30,YES,YES,YES,YES,	/* SYSOP gets everything he wants */
	SPECIAL,12,15,YES, NO, NO,YES,	/* SPECIAL can kill msgs, user 12 */
	NORMAL, 10, 5, NO, NO, NO,YES,	/* Joe Blow, gets nothing special */
	NOCPM,	 0, 5, NO, NO, NO,YES,	/* normal, except can't go to CPM */
	TWIT,	 0, 0, NO, NO, NO, NO,	/* can't even get on the system	  */
	'a',	 0, 0,  0,  0,  0,  0,	/* room for 3 other types */
	'b',	 0, 0,  0,  0,  0,  0,
	'c',	 0, 0,  0,  0,  0,  0,
	0,0,0,0,0,0,0	/* end of table DON'T CHANGE! !! ! !*/
	},

/************************************************************************
 Most sysops want the initial user to either be of 'normal' status, or
 'nocpm' status, but you can make it whatever you like..
 Take the status from the above table (SYSOP, SPECIAL, NORMAL, NOCPM,
 TWIT (sure!), 'a', 'b', 'c')...					*/

	NORMAL,	/* this is what you change */


/************************************************************************
 Is the bbs to be a private or pay system?
 	if SO set private to YES,This will require a system id code to logon.
	if NOT (it's public) then set to NO.				*/

	NO,	/* <--- that's what you change	*/

/* The following definition is for private systems ONLY	*/
/* (you may ignore it, if the above itset to 'NO')		*/

/* this is the private system password to get on to the system	*/
/* it can be UP TO 8 CHARS LONG (NO MORE)!			*/

	"CODXYZZY",	/* <--- this is it	*/


/**************************************************************************
	 The following table MUST BE KEPT IN THE SAME ORDER!!!!!!!!

	You may change the filenames to suit your tastes, also you
	may change the location (user area and drive) of each file.

	Filenames are of the format:  [user/][drive:]filename.ext	  */

{	"14/a:bulletin",	/* Bulletins file */
	"14/a:welcome",		/* Welcome file, as typed bye BYE */
	"14/a:users",		/* Users file */
	"14/a:callers",		/* callers log */
	"14/a:counters",	/* system special counters */
	"14/a:messages",	/* Main Message file */
	"14/a:summary",	 	/* Message Summary file */
	"14/a:lastcalr",	/* Last caller file */
	"14/a:newuser",		/* file to type for new users */
	"14/a:help",	 	/* brief command list help */
	"14/a:cpminfo", 	/* help file when exiting to cpm */
	"14/a:system.inf",	/* In private sys. account info, etc.*/
	"14/a:comments",	/* comments file */
	"14/a:othersys",	/* other systems file  */
	"14/a:notes.ind",	/* Notes index file    */
	"14/a:feature.ind",	/* Features index file */
	"14/a:meinfreq.ovr",	/* Infrequent routines overlay */
	"14/a:menter.ovr",	/* Metal Enter overlay (user enter) */
	"14/a:mesumm.ovr",	/* Summary command overlay */
	"14/a:mekill.ovr",	/* Kill message overlay */
	"14/a:mesend.ovr",	/* send message (enter msg) overlay   */
	"14/a:meuser.ovr",	/* User functions (edit, delete, add) */
	"14/a:mesysop.ovr",	/* Sysop functions.. msg purge, etc.. */
	"14/a:memisc.ovr",	/* Features/misc other funcs overlay  */
	"", /*	"14/a:z3tcap.tcp",   */	/* termcap description file   */
	"", /*	"14/a:medownld.ovr", */	/* file xfer orverlay (coming) */
	"", /*  "14/a:meopsys.ovr",  */	/* operating system functions (coming) */
	"", /*  "14/a:mehelp.ovr",   */	/* Help overlay for extended help (coming)  */
	"",			/* room for later */
	0	 /* leave alone */
	},


/************************************************************************
   after a certain number of unsuccessful login attempts, a person is
   hung-up on.  This variable declares that number.
   NOTE: attempt to logon as sysop counts as TWO tries.			*/

	5,	/* <--- Right here...	*/


/************************************************************************
   You can set an upper limit on the amount of active messages.  Each
   active message will take up 8 bytes of memory.			*/

	250,	/* <--- And here...	*/


/**************************************************************************
   Each line of a message can be up to 128 chars, but for a clear display
   the max length of a line of entered text should be something like 80	  */

	80,	/* <--- Change this if you like */


/************************************************************************
   You can set the maximum number of lines a message can have.  This is
  limited to 250 lines.

   100 lines at 80 chars a line (assuming completely full msg) would
   take 8k (RAM) above the actual program.				*/

	100,	/* <--- Here */


/************************************************************************
   A buffer space is needed in Metal to hold message pointers.  Each
  Space in the buffer takes up 8 bytes of memory.  This number MUST
  be larger than the Max Active message count above.			*/

	400,	/* Plenty of space */


/***************************************************************************
   There are built-in routines for compupro's real time clock, and for the
   time from a 10,000 day clock (Mountain Hardware).  The date must be
   manually entered for anything but the Compupro board.  This variable
   defines what type of clock, if any, and the port addresses.
	NOCLOCK	is no clock
	COMPUPRO is compupro ss1 clock
	HAYES is Hayes chronograph clock (not currently implemented)

/* this is what you change for type of clock */

	NOCLOCK,	/* <--- Change this */

/* the following are port addresses, and status info for the ports, for the
   clock board.  Currently setup for NOCLOCK.
   Note: compupro SS1 setup does NOT use the status mask values below.
   Also: if the port address is >255, then memory mapped port is assumed */

	0,		/*  command/status port address		*/
	1,		/*  data port address			*/
	2,		/*  output ready mask			*/
	0x20,		/*  input ready mask			*/

	16,		/*  used by compupro ss1 as an offset (ignore for other clocks..	*/


/*************************************************************************
  If your BYE is setup to ask for NULLS, then set the following to YES,
  else, set it to NO.							*/

	NO,	/* <--- Change this as desired	*/


/***************************************************************************
   If you are running ZCPR in Secure mode, set the following to YES, else
   set it to NO.							   */

	YES,	/* <--- And here */

 /* loc of WHEEL, ignore if above is set to NO */

	0x003e,	/* <--- Here..	*/


/***************************************************************************
  The following variable is used ONLY for NON-MP/M, MULTI_USER systems.

   For multiuser systems which make it dificult to tell which console is
  running the program (like TurboDos...) we need to have a set of 4 locations
  in memory that will be used to contain a simulated console Id.  The
  following is the starting address of the 4 locations in NON-COMMON memory.
  Usually there is room someplace in the base page of memory (0-100h)
  to place this.  This is currently set for a "reserved" area in TurboDos. */

	0x003b,	/* here.. */


/************************************************************************
   Initial default terminal line length.. this is currently not used*****/

	80,	/* Alter this if you like */ 


/************************************************************************
   Location of site.  Up to 80 chars. Displayed in MENTER 		*/

	"\nLos Altos, Ca.  (415) 949-1476",	/* <--- You got it!! */


/************************************************************************
   If you wish callers log and comments to go to printer and not a file
   then set this to YES, else set to NO.				*/

	NO,	/* <--- This one too */


/************************************************************************
   If you have a 5" drive that's motor shuts off after 5 secs or so, and
   can be retriggered with a read from a MEMORY location, then set this
   variable to that memory location.  Otherwise, you can ignore this	*/
 
	0xf201,	/* <--- this is for micropolis, at f000 */


/************************************************************************
   If you have a 25th line on your terminal that doesn't scroll, then
   the following to YES, and set the appropriate control chars, and
   port addresses below.  Otherwise declare the variable to NO		*/

	NO,	/* Set this to yes or no	*/

/* Up to 15 chars can be used to get to or from the 25th line		*/

/*** You may ignore the following if the above is NO ***/

/*	vvvvvvvvvvvvv---- change ALL OF these !!!!!		*/
	"\033\070",	/* Sequence to get to the 25th line	*/
	"\n",		/* Sequence to return from 25th line	*/
	0x13,		/* terinal output status port		*/
	0x12,		/* terminal data output port	  	*/
	0x01,		/* terminal status mask.. if bit is one,*/
			/* then ready to output char to port    */

/* NOTE::::: If you are using a non-I/O mapped video board that has a 25th
   line (Kaypro people), you can set the following values to obtain the
   same results as if it were i/o mapped:
	Set Terminal Output Status AND Terminal Status Mask to 0 (zero).
	Then find your bios output routine like this:
		A>ddt
		DDT Version...
		-l0		; list from 0
		0000 JMP B603	; look at where this jump instruction goes to
		-lb603		; and list from that address
		B603 JMP xyz
		B60x...		; we want the one at B60E in this case
				; (first two digits + 0E as last two digits)
		B60E JMP e877	; Ok, now write down the address this jump
				;  instruction goes to (e877h in this ex.)
	Now With the address you've written down, enter it as the
	'Terminal Output Data Port'.

	That's it!

	MAJOR NOTE::  This method is BIOS Dependent, so you'll have to
		      go through the same procedure anytime you use a
		      different flavored BIOS!!!!!!!!!!!!!!!!!!!!!
									*/


/************************************************************************
   CHANGE THESE!!!!!!!!  Sysop built-in password, and name
 */

	"Tim",		/* <--- Sysop's first name (change this)	*/
	"Gary",		/* <--- Sysop's last name  (  "      " )	*/

	"NOPASS",	/* <--- Change to a password (UPPER CASE ONLY)	*/


/************************************************************************
   Address of Your ZCPR 3 terminal descriptor buffer in memory.
   If you don't have ZCPR 3, either get it, or set this value to 0000
 */

	0000,		/* <------ */


/* leave these alone!!!!!!!! */
"",		/* Expansion area declaration	*/
"KABOOM!!!"	/* signal end of structure -------DO NOT TOUCH */

}	/* WHEW !!!!!!!!!!!!!!!!!   THAT'S IT!!!!!!!!!!!!!!!!!!!!!!!!!! */
#endif	/* if main or not.. */
      ;

/* EOF (HMCONFG.H) */

