'INPUT.INC: Some input routines that make life easier
'			(C) Copyright 1983 Marty Franz

PROCEDURE INITIALIZE.INPUT		'Initialize cursor and proof string
	IN.CHAR$ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890 "
	IN.BLINK = 5 : IN.CURCNT = IN.BLINK
ENDPROC

PROCEDURE GET.YES.OR.NO			'Get a yes or no answer from user
    'ANSWER contains either YES (1) or NO (0) on exit.
    IN.GOTIT = 0 : YES = 1 : NO = 0
    REPEAT
		DO IN.GET.KEY
		IF IN.KEY$ = "Y"
			IN.GOTIT = 1
			ANSWER = YES
		ELSE
			IF IN.KEY$ = "N"
				IN.GOTIT = 1
				ANSWER = NO
			ENDIF
		ENDIF
	UNTIL IN.GOTIT = 1
ENDPROC

PROCEDURE GET.STRING			'Get label name for breakpoint
	IN.INPUT$ = ""
	IN.START.COL = POS(0)
	REPEAT
		DO IN.GET.KEY
		IF IN.KEY$ = CHR$(13)
			BREAK
		ELSE
			IF IN.KEY$ = CHR$(8)
				DO IN.DEL.CHAR
			ELSE
				IF INSTR(IN.CHARS$,IN.KEY$) > 0
					DO IN.INS.CHAR
				ELSE
					BEEP
				ENDIF
			ENDIF
		ENDIF
	UNTIL 1 = 0
ENDPROC

PROCEDURE IN.GET.KEY	 		'Get uppercase key from keyboard
	REPEAT
		DO IN.CURSOR
		IN.KEY$ = INKEY$
	UNTIL LEN(IN.KEY$) > 0
	IF ASC(IN.KEY$) > 96 AND ASC(IN.KEY$) < 123
		IN.KEY$ = CHR$(ASC(IN.KEY$) - 32)
	ENDIF
ENDPROC

PROCEDURE IN.INS.CHAR			'Add char to end of input string
	PRINT IN.KEY$;
	IN.INPUT$ = IN.INPUT$ + IN.KEY$
ENDPROC

PROCEDURE IN.DEL.CHAR			'Handle backspace key in input
	IN.CUR.COL = POS(0)
	IF IN.CUR.COL > IN.START.COL
		IN.INPUT$ = LEFT$(IN.INPUT$,LEN(IN.INPUT$)-1)
		PRINT " ";
		LOCATE ,IN.CUR.COL-1
	ELSE
		BEEP
	ENDIF
ENDPROC

PROCEDURE IN.CURSOR				'Simulate BASIC cursor
	IF IN.CURCNT = IN.BLINK
		IF IN.CURCHAR$ = CHR$(&H5F)
			IN.CURCHAR$ = " "
		ELSE
			IN.CURCHAR$ = CHR$(&H5F)
		ENDIF
		IN.CURCNT = 0
	ENDIF
	PRINT IN.CURCHAR$;
	IN.CURCNT = IN.CURCNT + 1
	LOCATE ,POS(0)-1
ENDPROC
