;
;	MEMSCAN--SCANS ENTIRE MEGABYTE OF MEMORY
;
PMESS	EQU	9H
DISPLAY EQU	2H
DOSCALL EQU	21H
;
X_SEG	SEGMENT
X_BYTE	DB	?
X_SEG	ENDS
;
VAR_AREA	SEGMENT
LINES		DB	?
DIV_LINE	DB	?
GP_DIV		DB	?
HEADER		DB	'        0000     2000     4000     6000'
		DB	'     8000     A000     C000     E000$'
COLON		DB	': $'
FOOTER		DB	0AH,0DH,'X     X     X     X     X     X     X     X'
		DB	0AH,0DH,'000   400   800   C00   1000  1400  1800  1C00$'
;
VAR_AREA	ENDS
;
MEMSCAN 	SEGMENT
;
MAIN		PROC	FAR
;
		ASSUME	CS:MEMSCAN, DS:VAR_AREA
		ASSUME	ES:X_SEG
;
START:
		PUSH	DS
		SUB	AX,AX
		PUSH	AX
;
		MOV	AX,VAR_AREA
		MOV	DS,AX
;
		MOV	LINES,16
		SUB	AX,AX
		MOV	ES,AX
;
		CALL	CRLF
		MOV	DX,OFFSET HEADER
		MOV	AH,PMESS
		INT	DOSCALL
		CALL	CRLF
;
NEW_LINE:
		MOV	BX,ES
		CALL	BINIHEX
		MOV	DX,OFFSET COLON
		MOV	AH,PMESS
		INT	DOSCALL
;
		MOV	DIV_LINE,8
		MOV	BX,0
;
NEW_DIV:
		MOV	GP_DIV,8
NEW_GRP:
		MOV	CX,128
NEW_BYTE:
		MOV	AL,[BX + X_BYTE]
		MOV	AH,[BX + X_BYTE + 2]
		AND	AX,7F7FH
		CMP	AL,AH
		JE	NX_BYTE
;
		MOV	DL,[BX + X_BYTE + 5]
		AND	DL,7FH
		CMP	AL,DL
		JE	NX_BYTE
		CMP	AH,DL
		JE	NX_BYTE
;
		MOV	DL,'X'
		MOV	AH,DISPLAY
		INT	DOSCALL
;
		AND	BX,0FC00H
		ADD	BX,1024
		JMP	DONE_GRP
;
NX_BYTE:
		ADD	BX,8
		DEC	CX
		JNZ	NEW_BYTE
		MOV	DL,'.'
		MOV	AH,DISPLAY
		INT	DOSCALL
DONE_GRP:
		DEC	GP_DIV
		JNZ	NEW_GRP
		MOV	DL,' '
		MOV	AH,DISPLAY
		INT	DOSCALL
;
DONE_DIV:
		DEC	DIV_LINE
		JNZ	NEW_DIV
		CALL	CRLF
		MOV	AX,ES
		ADD	AX,1000H
		MOV	ES,AX
;
DONE_LINE:
		DEC	LINES
		JNZ	NEW_LINE
;
		MOV	DX,OFFSET FOOTER
		MOV	AH,PMESS
		INT	DOSCALL
		RET
;
MAIN		ENDP
;
CRLF		PROC	NEAR
		MOV	DL,0DH
		MOV	AH,DISPLAY
		INT	DOSCALL
		MOV	DL,0AH
		MOV	AH,DISPLAY
		INT	DOSCALL
		RET
CRLF		ENDP
;
BINIHEX 	PROC	NEAR
		MOV	CH,4
ROTATE:
		MOV	CL,4
		ROL	BX,CL
		MOV	AL,BL
		AND	AL,0FH
		ADD	AL,30H
		CMP	AL,3AH
		JL	PRINTIT
		ADD	AL,7
;
PRINTIT:
		MOV	DL,AL
		MOV	AH,DISPLAY
		INT	DOSCALL
		DEC	CH
		JNZ	ROTATE
		RET
BINIHEX 	ENDP
;
MEMSCAN 	ENDS
;
		END	START
