This is a description of the format of a WSSINDEX database.  This
information is not needed for normal program operation, but may be
useful if you want to write a program to convert an existing
database into a WSSINDEX database, read the database with another
program to produce a customized listing, or recover a damaged disk
file.  This description may be easier to follow if you use it as a
guide while examining a small database with DEBUG or some other
utility.

Dates and times are stored in the same format as used in an FCB. 
Date has 7 bits for years since 1980, 4 bits for month, 5 bits for
day.  Time has 5 bits for hour, 6 bits for minute, 5 bits for
second.

The database is stored unsorted.  This is done because the time
required by the Quicksort algorithm used by WSSINDEX is O(n*log n)
for a randomly ordered source, but O(n*n) for an already ordered
input.  In more concrete terms, storing the database in sorted
order would turn a 30 second sort into a longer than 10 minute
sort.

Notation:   \n   - a newline, that is an ASCII linefeed, hex 0A
            \EOS - end of string marker, hex 0
            *    - a field dependent on the WSSINDEX version 

   length     contents
   (bytes)

Header:

   9          "WSSINDEX\n"
   5 or 6*    version number\n
   2          number of disks in database
   2          number of subdirectories (including root)
   2          number of files

Disk record, repeated for each disk:

   11         volume name, blank padded to 11 chars (no \n or EOS)
   4          bytes on disk
   4          free bytes on disk
   2          number of files on disk
   2          number of subdirectories on disk (not counting root)
   2          date indexed
   1          "Y" or "N" for bootable or not

Subdirectory record, repeated for each subdirectory:

   2          disk number, cout starts at zero
   variable   subdirectory name\n

File record, repeated for each file:

   10         file name\EOS   there may be garbage after the \EOS
   4          extension\EOS   there may be garbage after the \EOS
   2          date
   2          time
   4          size
   2          disk number
   2          subdirectory number, root is 0
   1          "C" (if commented), else blank
   variable   comment\n   if comments flag is "C"
   1*         "C" (if categorized), else blank; field only present
              if written by version 2.00 or later
   variable*  category\n  if category flag is "C"

Note that there is not a control-Z to mark the end of file.

This information is subject to change in future releases. 
However, I do guarantee that WSSINDEX will alway be able to read
databases written by older versions of the program.
