#include <jaz.h>

/*
Ŀ
jzpshdir.c								     
Push the current subdirectory and drive.				     
Synopsis								     
  TSTKHEAD whead;							     
									     
  jzpshdir(&whead);	 ( current sub directory and drive saved now )	     
  chdir("\\test");                                                          
									     

*/

jzpshdir(fhead)
TSTKHEAD *fhead;		/* head of stack structure */
{
  TSTACK *wtemp;
  char wpath[65];
  int wdrive;

  jzgetdr(wpath);		/* return path string */

  /**
   ** We will save the drive in the first
   ** byte of the buffer, and the path
   ** in the remaining bytes!
   **/

  wtemp = (TSTACK *)  malloc(sizeof(TSTACK));	    /* get pointer to struct */
  wtemp->pointer = (char *) malloc(strlen(wpath)+1);   /* space for path */

  strcpy(wtemp->pointer,wpath); 	/* copy the path */
  wtemp->wint = jzgetdrv();		/* get default drive in size variable */

  if (fhead->last == 0) {	 /* empty stack */
    wtemp->prev  = 0;
    fhead->last  =  wtemp;	/* set last item (top of stack) */
    fhead->first =  wtemp;	/* set first item */
    fhead->numitems = 1;	/* set number of items */
  }
  else {
    wtemp->prev = fhead->last;	/* set link to stack top */
    fhead->last = wtemp;	/* set new top of stack */
    fhead->numitems++;		/* increment stack pointer */
  }
}


