/*	SPY.C  Ver. 1.1  Last rev.  8-25-88

	SPY was written to track when a particular batch file was
	executed.  It gets system time and date from dos and appends
	a file listed on the command line.  If no filename is listed,
	a default of SPY.DAT is assigned.  It could also be used in
	an AUTOEXEC.BAT file to log when a system is fired up.  SPY.COM	
	is about 6k long and goes about its business quickly and
	discreetly, as it produces no console output.

	Example batch file use:

		echo off		;turn off command echo
		c:			;log to drive c:
		cd\123			;change to 123 subdirectory
		SPY			;write time & date to c:\123\SPY.DAT
		123			;run Lotus 123
		cd\			;return to root directory when done

	or:

		echo off		;turn off command echo
		c:			;log to drive c:
		cd\FASTBACK		;change to FASTBACK subdirectory
		SPY C:\FOO\FOO.DAT	;write time/date to C:\FOO\FOO.DAT
		FASTBACK		;run FASTBACK
		cd\			;return to root directory when done		

	This yields a file similar to:

		5-9-1988    08:12:54
		5-9-1988    10:23:13
		5-9-1988    16:05:29

	indicating three executions at the time and date logged.

	It is assumed that anyone installing this program will check the
	SPY.DAT file once in a while.  There is nothing to keep it from
	eating all availible disk space if left to run amok.

	The author makes no guarantees of any sort about this program.
	If you choose to use it, you alone accept responsibilty for the
	results.  Every effort has been made to ensure "safe C", but you
	and I both know that weird stuff will occaisionally happen.  Bug
	reports are welcome, but keep the lawsuits to yourself.

	SPY.C was compiled under Turbo C 1.0, tiny memory model.
	Ignore "No Stack" warning.  Convert to .COM with EXE2BIN.

	SPY.C is militantly Public Domain, and is not to be sold in any
	way, shape, or form.  Don't send me anything, unless maybe you
	have an extra post card	on your	next vacation.  Have at it and
	welcome to it.

	Danny Walters
	1404 Lexington Ave. #16
	Cape Girardeau, MO  63701

==============================================================================

Now the fun starts!

*/

#include    <dos.h>                                             		
#include    <stdio.h>

main(int argc, char argv[])
{
	struct time now;
	struct date today;
        char filename[20] = "spy.dat";      /* default name -- good as any?? */
	FILE *stream;
  	
	if (argc>1)
		strcpy(filename, argv[2]);    /* use command line, if any */
	
	stream=fopen(filename, "a+");

	gettime (&now);                       /* fetch time & date  */
	getdate (&today);
	
	fprintf (stream, "%d-%d-%d",
		today.da_mon,                 /*  write date  */
		today.da_day,
		today.da_year);
	
	fprintf (stream, "   ");
	
	fprintf (stream, "%02d:%02d:%02d",
		now.ti_hour,
		now.ti_min,    		       /*  write time  */	 		
		now.ti_sec);

	fprintf (stream, "\n");

	fclose  (stream);                      /*  go home  */

}
