;*********************************************************************
;
; PCP-MEN3.CMD  - ProComm 2.4 Command file to dial PC Pursuit numbers.
;
; Modified/Updated by      - Bond Shands, Sysop      01/24/87
;                            The KAY*FOG PCBBS of San Francisco
;                            Modem: (415) 285-2687
;
; String variables are used extensively.  Their uses are:
;
; S0 - holds user input for SWITCHing
; S1 - holds PCP city name
; S2 - holds PCP city area code
; S3 - holds final destination name
; S4 - holds final destination phone number
; S5 - holds user input for SWITCHing
; S6 - YOU must set to modem dial command and local TELENET number
; S7 - YOU must set to your PCP password S7
; S8 - YOU must set to your PCP user id
; S9 - must be set to appropriate baud rate (3 or 12)
;
;*********************************************************************
;
K10-SETUP:                     ; All dialing code in areas K30 to K60
;
; Customization area - you need to change these for your setup
;
  ASSIGN S6 "ATDT956-5777!"    ; Enter ATDT and local telenet # here
                               ; 956-5777 is the San Francisco number.
  ASSIGN S7 "        "         ; Enter the password to be used here
  ASSIGN S8 "        "         ; Enter your PCP account ID here
  ASSIGN S9 "12"               ; Enter either "3" or "12" for baudrate
;
  TRACE OFF                    ; set to TRACE ON to debug changes
  SET CR_IN CR                 ; make sure no extra LF's in menus
;
K20-MENU:                      ; main menu
;
  CLEAR                        ; clear the screen
  LOCATE 1,0                   ; position the cursor
;
  MESSAGE "         Ĵ PC PURSUIT AVAILABLE CITIES Ŀ"
  MESSAGE "                                                                    "
  MESSAGE "            1- ATLANTA         (414)     15- NEW YORK        (212)  "
  MESSAGE "            2- BOSTON          (617)     16- PHILADELPHIA    (215)  "
  MESSAGE "            3- CHICAGO         (312)     17- PHOENIX         (602)  "
  MESSAGE "            4- CLEVELAND       (216)     18- PORTLAND        (503)  "
  MESSAGE "            5- DALLAS          (214)     19- RESEARCH TRI PK (919)  "
  MESSAGE "            6- DENVER          (303)     20- SALT LAKE CITY  (801)  "
  MESSAGE "            7- DETROIT         (313)     21- SAN FRANCISCO   (415)  "
  MESSAGE "            8- GLENDALE        (818)     22- SAN JOSE        (408)  "
  MESSAGE "            9- HOUSTON         (713)     23- SEATTLE         (206)  "
  MESSAGE "           10- LOS ANGELES     (213)     24- TAMPA           (813)  "
  MESSAGE "           11- MIAMI           (305)     25- WASHINGTON, DC  (202)  "
  MESSAGE "           12- MILWAUKEE       (414)                                "
  MESSAGE "           13- MINNEAPOLIS     (612)      Q- Quit This Menu         "
  MESSAGE "           14- NEWARK          (201)      X- Exit Back to DOS       "
  MESSAGE "                                                                    "
  MESSAGE "         Ĵ"
  MESSAGE "          ENTER NUMBER OF THE CITY OF YOUR CHOICE:                  "
  MESSAGE "         "
;
K25-DEFAULT:                 ; label for use by error option
;
  LOCATE 19 52               ; position cursor
  MESSAGE "  "               ; clear prompt area
  LOCATE 19 52               ; reposition cursor
  GET S0 2                   ; get users choice
;
  SWITCH S0                  ; switch on choice
;
  CLEAR
    CASE "Q"                 ; quit this menu to Terminal Mode
      EXIT
    ENDCASE
;
  CASE "X"                   ; exit ProComm to DOS Command Level
    QUIT 
  ENDCASE
;
K28-MENU2:                   ; Menu outline for Local BBS listing
  LOCATE 2,0
;
  MESSAGE "                         Ĵ  **  SEARCHING  **  Ŀ"
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                                                        "
  MESSAGE "                            M- Manual Dial              "
  MESSAGE "                            X- Exit to Main Menu        "
  MESSAGE "                                                        "
  MESSAGE "                         Ĵ"
  MESSAGE "                          Enter the NUMBER or LETTER of "
  MESSAGE "                          Your Choice:                  "
  MESSAGE "                         "
  LOCATE 4,41
;
  CASE "1"                   ; chose ATLANTA
    ASSIGN S1 "ATLANTA"      ; save the city name
    ASSIGN S2 "404"          ; save the area code
    GOSUB ATLANTA            ; go get number to dial
  ENDCASE
;
  CASE "2"              
    ASSIGN S1 "BOSTON" 
    ASSIGN S2 "617"    
    GOSUB BOSTON       
  ENDCASE
;
  CASE "3"
    ASSIGN S1 "CHICAGO"
    ASSIGN S2 "312"
    GOSUB CHICAGO
  ENDCASE
;
  CASE "4"
    ASSIGN S1 "CLEVELAND"
    ASSIGN S2 "216"
    GOSUB CLEVELAND
  ENDCASE
;
  CASE "5"
    ASSIGN S1 "DALLAS"
    ASSIGN S2 "214"
    GOSUB DALLAS
  ENDCASE
;
  CASE "6"
    ASSIGN S1 "DENVER"
    ASSIGN S2 "303"
    GOSUB DENVER
  ENDCASE
;
  CASE "7"
    ASSIGN S1 "DETROIT"
    ASSIGN S2 "313"
    GOSUB DETROIT
  ENDCASE
;
  CASE "8"
    ASSIGN S1 "GLENDALE"
    ASSIGN S2 "818"
    GOSUB GLENDALE
  ENDCASE
;
  CASE "9"
    ASSIGN S1 "HOUSTON"
    ASSIGN S2 "713"
    GOSUB HOUSTON
  ENDCASE
;
  CASE "10"
    ASSIGN S1 "LOS ANGELES"
    ASSIGN S2 "213"
    GOSUB LOS_ANGELES
  ENDCASE
;
  CASE "11"
    ASSIGN S1 "MIAMI"
    ASSIGN S2 "305"
    GOSUB MIAMI
  ENDCASE
;
  CASE "12"
    ASSIGN S1 "MILWAUKEE"
    ASSIGN S2 "414"
    GOSUB MILWAUKEE
  ENDCASE
;
  CASE "13"
    ASSIGN S1 "MINNEAPOLIS"
    ASSIGN S2 "612"
    GOSUB MINNEAPOLIS
  ENDCASE
;
  CASE "14"
    ASSIGN S1 "NEWARK"
    ASSIGN S2 "201"
    GOSUB NEWARK
  ENDCASE
;
  CASE "15"
    ASSIGN S1 "NEW YORK CITY"
    ASSIGN S2 "212"
    GOSUB NEW_YORK
  ENDCASE
;
  CASE "16"
    ASSIGN S1 "PHILADELPHIA"
    ASSIGN S2 "215"
    GOSUB PHILADELPHIA
  ENDCASE
;
  CASE "17"
    ASSIGN S1 "PHOENIX"
    ASSIGN S2 "602"
    GOSUB PHOENIX
  ENDCASE
;
  CASE "18"
    ASSIGN S1 "PORTLAND"
    ASSIGN S2 "503"
    GOSUB PORTLAND
  ENDCASE
;
  CASE "19"
    ASSIGN S1 "RESEARCH TRIANGLE"
    ASSIGN S2 "919"
    GOSUB RESEARCH
  ENDCASE
;
  CASE "20"
    ASSIGN S1 "SALT LAKE CITY"
    ASSIGN S2 "801"
    GOSUB SALT_LAKE
  ENDCASE
;
  CASE "21"
    ASSIGN S1 "SAN FRANCISCO (AREA CODE 415)"
    ASSIGN S2 "415"
    GOSUB SAN_FRANCISCO
  ENDCASE
;
  CASE "22"
    ASSIGN S1 "SAN JOSE (AREA CODE 408)"
    ASSIGN S2 "408"
    GOSUB SAN_JOSE
  ENDCASE
;
  CASE "23"
    ASSIGN S1 "SEATTLE (AREA CODE 206)"
    ASSIGN S2 "206"
    GOSUB SEATTLE
  ENDCASE
;
  CASE "24"
    ASSIGN S1 "TAMPA (AREA CODE 813)"
    ASSIGN S2 "813"
    GOSUB TAMPA
  ENDCASE
;
  CASE "25"
    ASSIGN S1 "WASHINGTON, DC (202)"
    ASSIGN S2 "202"
    GOSUB WASHINGTON_DC
  ENDCASE
;
  DEFAULT                    ; all other cases
    CLEAR
    LOCATE 0,0
    MESSAGE "^G"             ; error noise
    LOCATE 12,23
    MESSAGE "**** Invalid Number Selected ****"
    PAUSE 2
    GOTO K25-DEFAULT
  ENDCASE
;
  ENDSWITCH
;
  FIND S2 "999"
  IF FOUND
    GOTO K20-MENU
  ENDIF
;
; Ok, call the local TELENET number first.  This is an example of
; redialing without using the DIAL or Alt-R commands
;
K30-START:
  SET SCROLL ON
  CLEAR                      ; ready to call TELENET
  SET PARITY EVEN            ; set parms for TELENET
  SET DATABITS 7
;
K31-DIAL:                    ; label for busy TELENET
  HANGUP
  MESSAGE "DIALING SAN FRANCISCO LOCAL PCP TELENET NODE."
  TRANSMIT S6                ; call local Telenet
  WAITFOR "CONNECT" 15       ; give it 15 seconds to answer
;
  IF WAITFOR                 ; it connected
    MESSAGE " "
    MESSAGE "NOW CONNECTED TO LOCAL PCP TELENET NODE ..."
  ELSE
    MESSAGE "LOCAL PCP TELENET NODE IS BUSY.  REDIALING..."
    GOTO K31-DIAL 
  ENDIF
;
; Ok, made it thru local telenet number, now call the remote PCP city
; Notice that we redial at this point as well
;
K35-SET:
  PAUSE 2
  TRANSMIT "!"               ; 1st of 2 CRs to get Telenet's attn
  TRANSMIT "!"               ; Second of two carriage returns
  WAITFOR "="                ; Wait for 'TERMINAL=' prompt
  TRANSMIT "D1!"             ; Enter terminal type
  WAITFOR "@"                ; Wait for Telenet prompt
  TRANSMIT "SET? 10:0!"      ; Speedup code
  WAITFOR "PAR10:0"
  WAITFOR "@"
  IF WAITFOR
    TRACE OFF
  ELSE
    MESSAGE "Telenet not responding to SET parameters"
    TRACE ON
    GOTO K35-SET
  ENDIF
;
K40-CITY:                    ; label for busy remote PCP city
  TRANSMIT "C DIAL"
  TRANSMIT S2                ; area code
  TRANSMIT "/"
  TRANSMIT S9                ; BAUD RATE
  TRANSMIT ","
  TRANSMIT S8                ; ID
  TRANSMIT "!"               ; cr
;
  WAITFOR "="                ; Wait for 'PASSWORD=' prompt
;
  TRANSMIT S7                ; Enter password
  TRANSMIT "!"               ; cr
;
  RGET S5                    ; Get the CR echoed from our TRANSMIT
  RGET S5                    ; Get the CR that precedes PCP messages
  RGET S5                    ; Get the actual message
  PAUSE 2                    ; Display it briefly
;
  FIND S5 "CONNECT"          ; Look for connection
;
  IF NOT FOUND               ; No connection
    CLEAR
    MESSAGE "THE REMOTE PCP IS BUSY.  REDIALING..."
    LOCATE 0,37
    MESSAGE S1
    GOTO K40-CITY
  ENDIF
;
; Ok, made it to the remote PCP city.  Display appropriate message
; then call the actual destination, again using a redial
;
  CLEAR
  MESSAGE "CONNECTED TO -"
  LOCATE 0,15
  MESSAGE S1
  LOCATE 1,0
  MESSAGE "DIALING..."
  LOCATE 1,11
  MESSAGE S3
;
K45-SPEEDUP:                 ; Xmodem speedup "assist" parameters
  MESSAGE "Entering Remote Modem Speed-up Parameters."
  TRANSMIT "@!"              ; Enter Remote Command State
  WAITFOR "@"
  TRANSMIT "SET? 1:0,4:2,10:0,0:0,57:1,63:0!"
  WAITFOR "@"
  IF WAITFOR
    TRANSMIT "CONT!"         ; End PCP Speedup command
    TRACE OFF
    MESSAGE "Remote Modem has accepted Speed-up Parameters."
    PAUSE 1
  ELSE
    MESSAGE "Telenet not responding to SET parameters"
    TRACE ON
    GOTO K45-SPEEDUP
  ENDIF
;
K50-BBS:                     ; Busy BBS phone number
  MESSAGE " "
  TRANSMIT "ATZ!"            ; Wake up remote modem
  WAITFOR "OK"
  TRANSMIT "ATDT"
  TRANSMIT S4                ; THE NUMBER
  TRANSMIT "!"               ; CR
;
  RGET S0                    ; Get CR echoed from our TRANSMIT
  RGET S0 80 40              ; Get CR that precedes PCP messages
  RGET S0                    ; Get the real message
;
  FIND S0 "BUSY"             ; was it busy?
;
  IF FOUND
    CLEAR
    MESSAGE "STILL CONNECTED TO -"
    LOCATE 0,21
    MESSAGE S1
    LOCATE 1,0
    MESSAGE "BUSY.  REDIALING..."
    LOCATE 1,19
    MESSAGE S3
    GOTO K50-BBS
  ENDIF
;
  FIND S0 "CONNECT"          ; did it connect?
;
  IF FOUND
    SET PARITY NONE          ; Switch to N/8/1 for BBS work
    SET DATABITS 8
    CLEAR
    LOCATE 10,0
    MESSAGE "CONNECTED TO"
    LOCATE 10,13
    MESSAGE S3
    LOCATE 11,0
    MESSAGE "LOGON PROCEEDING - PRESS ANY KEY TO CONTINUE"
  ELSE                       ; not busy or connect, assume error
    CLEAR
    MESSAGE "STILL CONNECTED TO -"
    LOCATE 0,21
    MESSAGE S1
    LOCATE 1,0
    MESSAGE "NO CONNECT OR ERROR.  REDIALING "
    LOCATE 1,32
    MESSAGE S3
    GOTO K50-BBS
  ENDIF
;
K60-END:
  ALARM 5                    ; alarm for 5 seconds
  TRANSMIT "^M"
  EXIT                       ; exit to Terminal mode
;
;********************************************************************
;
; GOSUB ROUTINES START HERE
;
;********************************************************************
;
ATLANTA:
  LOCATE 2,32
  MESSAGE "ATLANTA BBS NUMBERS"
  LOCATE 4,29
  MESSAGE "1- ATLGATE                 "
  LOCATE 5,29
  MESSAGE "2- Flagship Express"
  LOCATE 6,29
  MESSAGE "3- BYTE Connection"
  LOCATE 7,29
  MESSAGE "4- Microstuf BBS"
  LOCATE 8,29
  MESSAGE "5- Software Link BBS"
  LOCATE 9,29
  MESSAGE "6- PC-Exchange BBS"
;
ATL1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "ATLGATE"       ; save the BBS name
      ASSIGN S4 "9281876"       ; save the number
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "Flagship Express"
         ASSIGN S4 "9344515"
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "BYTE Connection"
         ASSIGN S4 "9410159"
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "Microstuf_BBS"
         ASSIGN S4 "9988048"
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "Software Link"
         ASSIGN S4 "9986737"
      ENDCASE
;
      CASE "6"
         ASSIGN S3 "PC-Exchange BBS"
         ASSIGN S4 "9776686"
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO ATL1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;** BOSTON **
;
BOSTON: 
   LOCATE 2,32
   MESSAGE "BOSTON AREA NUMBERS"
   LOCATE 4,29
   MESSAGE "1- Boston Computer Society "
   LOCATE 5,29
   MESSAGE "2- To be assigned"
   LOCATE 6,29
   MESSAGE "3- To be assigned"
   LOCATE 7,29
   MESSAGE "4- To be assigned"
   LOCATE 8,29
   MESSAGE "5- To be assigned"
;
BOS1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "BOSTON COMPUTER SOCIETY"
         ASSIGN S4 "3539312"
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO BOS1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;*** CHICAGO **
;
CHICAGO:
   LOCATE 2,32
   MESSAGE "CHICAGO BBS NUMBERS"
   LOCATE 4,29
   MESSAGE "1- CFOG #2: Bill Kuykendall"
   LOCATE 5,29
   MESSAGE "2- To be assigned"
   LOCATE 6,29
   MESSAGE "3- To be assigned"
   LOCATE 7,29
   MESSAGE "4- To be assigned"
   LOCATE 8,29
   MESSAGE "5- To be assigned"
   LOCATE 9,29
;
CHI1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "CFOG #2"
         ASSIGN S4 "2357902"
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO CHI1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;** CLEVELAND **
;
CLEVELAND:
  LOCATE 2,32
  MESSAGE " CLEVELAND NUMBERS "
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
CLE1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO CLE1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;*** DALLAS ***
;
DALLAS: 
   LOCATE 2,32
   MESSAGE "DALLAS AREA NUMBERS"
   LOCATE 4,29
   MESSAGE "1- To be assigned          "
   LOCATE 5,29
   MESSAGE "2- To be assigned"
   LOCATE 6,29
   MESSAGE "3- To be assigned"
   LOCATE 7,29
   MESSAGE "4- To be assigned"
   LOCATE 8,29
   MESSAGE "5- To be assigned"
;
DAL1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO DAL1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;*** DENVER ***
;
DENVER: 
   LOCATE 2,32
   MESSAGE "DENVER AREA NUMBERS"
   LOCATE 4,29
   MESSAGE "1- World Peace - Bucky Carr"
   LOCATE 5,29
   MESSAGE "2-"
   LOCATE 6,29
   MESSAGE "3-"
   LOCATE 7,29
   MESSAGE "4-"
   LOCATE 8,29
   MESSAGE "5-"
;
DEN1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "World Peace RCP/M"
         ASSIGN S4 "3204822"
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO DEN1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;*** DETROIT ***
;
DETROIT:
   LOCATE 2,32
   MESSAGE "DETROIT BBS NUMBERS"
   LOCATE 4,29
   MESSAGE "1- Computer Support BBS    "
   LOCATE 5,29
   MESSAGE "2- The Trading Post"
   LOCATE 6,29
   MESSAGE "3- PX-DOCK BBS: Bob Hermann"
   LOCATE 7,29
   MESSAGE "4-"
   LOCATE 8,29
   MESSAGE "5-"
;
DET1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "Computer Support BBS"
         ASSIGN S4 "9464821"
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "The Trading Post"
         ASSIGN S4 "8827104"
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "PX-Dock BBS"
         ASSIGN S4 "5386968"
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO DET1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;** GLENDALE **
;
GLENDALE:
  LOCATE 2,32
  MESSAGE " GLENDALE NUMBERS  "
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
GLE1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO GLE1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;*** HOUSTON ***
;
HOUSTON:
   LOCATE 2,32
   MESSAGE "HOUSTON BBS NUMBERS"
   LOCATE 4,29
   MESSAGE "1- To be assigned          "
   LOCATE 5,29
   MESSAGE "2- To be assigned"
   LOCATE 6,29
   MESSAGE "3- To be assigned"
   LOCATE 7,29
   MESSAGE "4- To be assigned"
   LOCATE 8,29
   MESSAGE "5- To be assigned"
   LOCATE 9,29
;
HOU1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO HOU1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;*** LOS ANGELES ***
;
LOS_ANGELES:
   LOCATE 2,32
   MESSAGE "LOS ANGELES NUMBERS"
   LOCATE 4,29
   MESSAGE "1- DESQview Priority Svc   "
   LOCATE 5,29
   MESSAGE "2- To be assigned"
   LOCATE 6,29
   MESSAGE "3- To be assigned"
   LOCATE 7,29
   MESSAGE "4- To be assigned"
   LOCATE 8,29
   MESSAGE "5- To be assigned"
;
LOS1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "Quarterdeck/DESQview"
         ASSIGN S4 "3963904"
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO LOS1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;** MIAMI **
;
MIAMI:
  LOCATE 2,32
  MESSAGE "MIAMI AREA NUMBERS "
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
MIA1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO MIA1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;** MILWAUKEE **
;
MILWAUKEE:
  LOCATE 2,32
  MESSAGE " MILWAUKEE NUMBERS "
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
MIL1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO MIL1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;** MINNEAPOLIS **
;
MINNEAPOLIS:
  LOCATE 2,32
  MESSAGE "MINNEAPOLIS NUMBERS"
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
MIN1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO MIN1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;*** NEWARK ***
;
NEWARK:
   LOCATE 2,32
   MESSAGE "NEWARK AREA NUMBERS"
   LOCATE 4,29
   MESSAGE "1- MicroSellar, Mark Rapp  "
   LOCATE 5,29
   MESSAGE "2- To be assigned"
   LOCATE 6,29
   MESSAGE "3- To be assigned"
   LOCATE 7,29
   MESSAGE "4- To be assigned"
   LOCATE 8,29
   MESSAGE "5- To be assigned"
;
NEK1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "MicroSellar BBS"
         ASSIGN S4 "239-1346"
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO NEK1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;*** NEW YORK CITY ***
;
NEW_YORK:
   LOCATE 2,32
   MESSAGE "NEW YORK BB NUMBERS"
   LOCATE 4,29
   MESSAGE "1- To be assigned          "
   LOCATE 5,29
   MESSAGE "2- To be assigned"
   LOCATE 6,29
   MESSAGE "3- To be assigned"
   LOCATE 7,29
   MESSAGE "4- To be assigned"
   LOCATE 8,29
   MESSAGE "5- To be assigned"
;
NYC1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO NYC1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;*** PHILADELPHIA ***
;
PHILADELPHIA:
   LOCATE 2,32
   MESSAGE "PHILADELPHIA NUMBER"
   LOCATE 4,29
   MESSAGE "1- EpsonNet BBS"
   LOCATE 5,29
   MESSAGE "2- To be assigned          "
   LOCATE 6,29
   MESSAGE "3- To be assigned"
   LOCATE 7,29
   MESSAGE "4- To be assigned"
   LOCATE 8,29
   MESSAGE "5- To be assigned"
;
PHI1:
   LOCATE 19,40
   MESSAGE  "          "
   LOCATE 19,40
   GET S5 1
;
   SWITCH S5
;
      CASE "1"
         ASSIGN S3 "EpsonNet BBS"
         ASSIGN S4 "7637766"
      ENDCASE
;
      CASE "2"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "3"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "4"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "5"
         ASSIGN S3 "           "   ; Fill with BBS Name
         ASSIGN S4 "       "       ; Fill with BBS phone number
         ASSIGN S2 "999"           ; Remove this line
      ENDCASE
;
      CASE "M"
         LOCATE 22,27
         MESSAGE "NUMBER TO DIAL:"
         LOCATE 22,43
         ASSIGN S3 "MANUAL DIAL"
         GET S4
      ENDCASE
;
      CASE "X"
         CLEAR
         LOCATE 4,29
         MESSAGE "RETURNING TO MAIN MENU"
         ASSIGN S2 "999"
      ENDCASE
;
      DEFAULT
         MESSAGE "^G"
         LOCATE 19,43
         MESSAGE "<-?????"
         GOTO PHI1
      ENDCASE
;
   ENDSWITCH
RETURN
;
;** PHOENIX **
;
PHOENIX:
  LOCATE 2,32
  MESSAGE "PHOENIX BBS NUMBERS"
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
PHO1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO PHO1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;** PORTLAND **
;
PORTLAND:
  LOCATE 2,32
  MESSAGE "  PORTLAND NUMBERS "
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
POR1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO POR1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;** RESEARCH TRIANGLE PARK **
;
RESEARCH:
  LOCATE 2,32
  MESSAGE " RESEARCH TRIANGLE "
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
RES1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO RES1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;** SALT LAKE CITY **
;
SAN_LAKE:
  LOCATE 2,32
  MESSAGE "SALT LAKE CITY AREA"
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
SAL1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "                       "
      ASSIGN S4 "       "
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO SAL1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;*** SAN FRANCISCO ***
;
SAN_FRANCISCO:
  LOCATE 2,32
  MESSAGE " SAN FRANCISCO AREA "
  LOCATE 4,29
  MESSAGE "1- KAY*FOG PCBBS, B. Shands"
  LOCATE 5,29
  MESSAGE "2- VOR BBS, Vernon Buerg"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
  LOCATE 7,29
  MESSAGE "4- To be assigned"
  LOCATE 8,29
  MESSAGE "5- To be assigned"
;
SFO1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "KAY*FOG PCBBS - Bond Shands, Sysop"
      ASSIGN S4 "2852687"
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "VOR BBS - Vern Buerg, Sysop"
      ASSIGN S4 "9942944"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "4"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "5"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO SFO1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;** SAN JOSE **
;
SAN_JOSE:
  LOCATE 2,32
  MESSAGE " SAN JOSE NUMBERS  "
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- Servu BBS - Al Mehr"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
SAJ1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "                       "
      ASSIGN S4 "       "
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "SERVU BBS - Al Mehr, Sysop"
      ASSIGN S4 "2389621"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO SAJ1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;** SEATTLE **
;
SEATTLE:
  LOCATE 2,32
  MESSAGE "SEATTLE BBS NUMBERS"
  LOCATE 4,29
  MESSAGE "1- To be assigned         ."
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
SEA1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO SEA1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;** TAMPA **
;
TAMPA:
  LOCATE 2,32
  MESSAGE "TAMPA AREA NUMBERS "
  LOCATE 4,29
  MESSAGE "1- To be assigned          "
  LOCATE 5,29
  MESSAGE "2- To be assigned"
  LOCATE 6,29
  MESSAGE "3- To be assigned"
;
TAM1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "           "
      ASSIGN S4 "       "
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      ASSIGN S3 "MANUAL DIAL"
      GET S4
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO TAM1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;*** WASHINGTON, DC - Area Code 202 ***
;
WASHINGTON_DC:
  LOCATE 2,32
  MESSAGE "WASH DC BBS NUMBERS"
  LOCATE 4,29
  MESSAGE "1- PC-Pursuit BBS"
  LOCATE 5,29
  MESSAGE "2- In Pursuit of ..."
  LOCATE 6,29
  MESSAGE "3- Fannie Mae"
  LOCATE 7,29
  MESSAGE "4- Hotline BBS"
  LOCATE 8,29
  MESSAGE "5- Arquimedes"
  LOCATE 9,29
  MESSAGE "6- Compu Center"
  LOCATE 10,29
  MESSAGE "7- Computer Connection"
  LOCATE 11,29
  MESSAGE "8- Net-Exchange BBS"
  LOCATE 12,29
  MESSAGE "9- To be assigned          "
;
WAS1:
  LOCATE 19,40
  MESSAGE  "          "
  LOCATE 19,40
  GET S5 1
  LOCATE 16,43
;
  SWITCH S5
;
    CASE "1"
      ASSIGN S3 "PCPursuit BBS"
      ASSIGN S4 "6893561"
      RETURN
    ENDCASE
;
    CASE "2"
      ASSIGN S3 "In Pursuit of..."
      ASSIGN S4 "6892987"
    ENDCASE
;
    CASE "3"
      ASSIGN S3 "Fannie Mae"
      ASSIGN S4 "5377475"
    ENDCASE
;
    CASE "4"
      ASSIGN S3 "Hotline BBS"
      ASSIGN S4 "6833944"
    ENDCASE
;
    CASE "5"
      ASSIGN S3 "Arquimedes"
      ASSIGN S4 "6988230"
    ENDCASE
;
    CASE "6"
      ASSIGN S3 "Compu Center"
      ASSIGN S4 "9799250"
    ENDCASE
;
    CASE "7"
      ASSIGN S3 "Computer Connection"
      ASSIGN S4 "5472008"
    ENDCASE
;
    CASE "8"
      ASSIGN S3 "Net-Exchange BBS"
      ASSIGN S4 "6893561"
    ENDCASE
;
    CASE "9"
      ASSIGN S3 "           "   ; Fill with BBS Name
      ASSIGN S4 "       "       ; Fill with BBS phone number
      ASSIGN S2 "999"           ; Remove this line
    ENDCASE
;
    CASE "M"
      LOCATE 22,27
      MESSAGE "NUMBER TO DIAL:"
      LOCATE 22,43
      MESSAGE "_______"
      LOCATE 22,43
      GET S4 7
      ASSIGN S3 "MANUAL DIAL"
    ENDCASE
;
    CASE "X"
      CLEAR
      LOCATE 4,29
      MESSAGE "RETURNING TO MAIN MENU"
      ASSIGN S2 "999"
    ENDCASE
;
    DEFAULT
      MESSAGE "^G"
      LOCATE 19,43
      MESSAGE "<-?????"
      GOTO WAS1
    ENDCASE
;
  ENDSWITCH
RETURN
;
;*** END OF PCP-MENU.CMD ***
;
;** 01/25/87 ** lines=2,236 ** count=51,304 **

