*** MENU1.PRG
*** Liz Matthews
*** I am using PgDn/PgUp to show next/previous customer records
*** You could do the same thing with the Up/Down arrow keys and
*** scroll multiple records on the screen
** Home/End go to top/bottom of the file

*** One reason I like this better than Clipper's menu command is that
*** the 'menu' and 'prompt' rewrite the menu line since they are similar
*** to a 'read' and I can see it.

reg_color = "W/N,N/W,N,,W+/N"
hi_color = "W+/N,N/W,N,,W+/N"
rev_color = "N/W,W+/N,N,,W+/N"
homekey = 1
endkey = 6
pgupkey = 18
pgdnkey = 3
esckey = 27
upkey = 5
downkey = 24
rightkey = 4
leftkey = 19
car_ret = 13
spacebar = 32

numopts = 6
optkeys = "AEDSPQ"
declare a_opts[numopts],a_cols[numopts],a_msg[numopts]

a_cols[1] = 00
a_cols[2] = 05
a_cols[3] = 11
a_cols[4] = 19
a_cols[5] = 27
a_cols[6] = 34

a_opts[1] = "Add"
a_opts[2] = "Edit"
a_opts[3] = "Delete"
a_opts[4] = "Search"
a_opts[5] = "Print"
a_opts[6] = "Quit"

a_msg[1] = "Add a new customer         "
a_msg[2] = "Edit this record           "
a_msg[3] = "Delete this record         "
a_msg[4] = "Search by customer no./name"
a_msg[5] = "Print this record          "
a_msg[6] = "Exit to DOS                "

menurow = 23
menucol = 0

menuline = ''
for i = 1 to len(a_opts)
	menuline = menuline + a_opts[i] + '  '
next
menuline = trim(menuline)

newopt = 1
oldopt = 0
keypress = 0
topline = 3
select 1
use customer alias cst
go top

*** there are several routines around to download which you can link
*** in to turn your cursor off.  The one I use is part of a Shareware
*** library -- PROCLIP.LIB -- on the Source in Nansig as PC_V150.ARC

*cursor('off')
clear

do CUSTSCN
@ menurow,0 say menuline
do SHOWCUST
do while .t.
	
	* menu loop: iterates ones for each key input, breaks on selection
	do while .t.
	
		* if selected option has changed, update the bounce-bar
		if oldopt != newopt
			
			* reset oldopt for another pass
			* do not do this on first pass due to array index
			if oldopt > 0
				* lowlight old option
				@ menurow,a_cols[oldopt] say a_opts[oldopt]
			endif
			
			* highlight new option
			set color to &rev_color
			@ menurow,a_cols[newopt] say a_opts[newopt]
			set color to &reg_color
			@ menurow+1,0 say a_msg[newopt]
			
			*** doing this instead of turning the cursor off ***
			@ menurow,a_cols[newopt] say ''
			
			oldopt = newopt
		endif
		
		* if return or an option trigger has been hit, perform the option
		if keypress == car_ret .or. upper(chr(keypress)) $  optkeys
			* fall out to action loop
			exit
		endif
		
		* get key input
		keypress = inkey(0)
		*** erase the stub message at 0,0
		@ 0,0
		
		* update choice number based on key response
		do case
		
		* right arrow/spacebar: increment choice or wrap
		case keypress == rightkey .or. keypress == spacebar
			newopt = iif(oldopt == numopts,1,oldopt + 1)
		
		* left arrow: decrement choice or wrap
		case keypress == leftkey
			newopt = iif(oldopt == 1,numopts,oldopt - 1)
		
		* PgDn: goto next customer record
		case keypress == pgdnkey
			skip 1
			if eof()
				go bottom
			endif
			do SHOWCUST
		
		* PgUp: goto previous customer record
		case keypress == pgupkey
			skip -1
			if bof()
				go top
			endif
			do SHOWCUST
		
		case keypress == homekey
		* first record
			go top
			do SHOWCUST
		
		case keypress == endkey
		* last record
			go bottom
			do SHOWCUST
		
		* option trigger: set choice to option
		case upper(chr(keypress)) $ optkeys
			newopt = at(upper(chr(keypress)), optkeys)
		
		endcase
		
	enddo
	
	* perform selected option
	do case
	case newopt == 1
	* add a new customer
		@ 0,0 say "Option 1 chosen"
	
	case newopt == 2
	* edit current customer
		@ 0,0 say "Option 2 chosen"
	
	case newopt == 3
	* delete a customer
		@ 0,0 say "Option 3 chosen"
	
	case newopt == 4
	* search for a specific customer by customer# or name
		@ 0,0 say "Option 4 chosen"
	
	case newopt == 5
	* print info for current customer
		@ 0,0 say "Option 5 chosen"
	
	case newopt == 6
	* all done
		exit
	endcase
	
	keypress = 0
	
enddo
close database
clear
quit


proc SHOWCUST
set color to &rev_color
@ topline+2,21 say cst->CUST_NO pict "99999" 
set color to &hi_color
@ topline+5,30 say cst->COMPANY
@ topline+6,30 say space(35)
@ topline+6,30 say trim(cst->lname)+if(empty(cst->lname),"",",")+trim(cst->fname)
@ topline+8,30 say cst->ADDR1
@ topline+9,30 say cst->ADDR2
@ topline+10,30 say cst->CITY
@ topline+11,30 say cst->STATE
@ topline+11,40 say cst->ZIP pict "@R 99999-9999"
@ topline+14,20 say cst->AREA pict "999"
@ topline+14,25 say cst->phone pict "@R 999-9999"
@ topline+14,35 say cst->TERMS
@ topline+14,45 say cst->CREDIT pict "999999.99"
@ topline+14,62 say cst->BILLED pict "999999.99"
set color to &reg_color
*** doing this instead of turning the cursor off ***
@ menurow,a_cols[newopt] say ''
RETURN


* display fixed text
proc CUSTSCN
@ topline,06 say "ͻ"
@ topline+1,06 say "                     "
@ topline+2,06 say " Customer No.        "
@ topline+3,06 say "        ͻ"
@ topline+4,06 say "͹"+space(58)+""
@ topline+5,15 say "   Company...."+space(44)+""
@ topline+6,15 say "   Name(L,F).."+space(44)+""
@ topline+7,15 say ""+space(58)+""
@ topline+8,15 say "   Address...."+space(44)+""
@ topline+9,15 say ""+space(58)+""
@ topline+10,15 say "   City......."+space(44)+""
@ topline+11,15 say "   State......    Zip..."+space(34)+""
@ topline+12,15 say ""+space(58)+""
@ topline+13,15 say "   Telephone       Terms  Credit Limit  Current Balance   "
@ topline+14,15 say "   (   )              Da"+space(34)+""
@ topline+15,15 say ""+space(58)+""
@ topline+16,15 say "ͼ"
RETURN


