ASSIGN S5 "12"               ; SET BAUD RATE
ASSIGN S6 "XXXXX"            ; USERID
ASSIGN S8 "99999XXX"         ; PASSWORD
;******************************************************************************
;                                                                             *
; XcelPCP - A system for automatic linking to PC-Pursuit area BBSs.           *
;                                                                             *
; WRITTEN BY Robert C. Lake, 3206 Covered Bridge Rd., Montgomery, AL 36116    *
;                                                                             *
; INSPIRED BY many pioneering PROCOMM Command (Script) files found on         *
;      many of the GREAT BBSs available in the PC-Pursuit areas. Pieces       *
;      of their fine code can be found throughout.   THANKS!!                 *
;                                                                             *
; Please do NOT transfer these programs piecemeal.  Always be sure to include *
; all the related programs, and especially the XREADME.PCP file.              *
;                                                                             *
;******************************************************************************
;
; Program to permit choices of PCP cities to dial.  User can choose any
; number of cities and program will cycle through them (in "ABCD" order)
; until a connection is made
;
; S5 = BAUD RATE
; S6 = USER ID
; S8 = PASSWORD
; S7 = FLAG FOR "MORE" TO DIAL
; S3 = AREA CODE
; S2 = COMMAND FILE TO CHAIN TO
; S0 = USER RESPONSE TO MENU
; S1 = CITY, STATE AND ZIP CODE STRING
;
ASSIGN S7 "    "               ; SET DEFAULT VALUE FOR 'MORE' FLAG
SET DATABITS 7                 ; USE 7 BITS SO USER CAN SEE THE ACTION
SET PARITY EVEN
TRANSMIT "^m^m"                ; A COUPLE RETURNS TO GET PCP'S ATTENTION
TRANSMIT "@!"                  ; HELLO!
WAITFOR "@"                    ; PCP WAKES UP
TRANSMIT "D!"                  ; DISCONNECT FROM PRESENT CITY (IF NEEDED)
WAITFOR "@" 30                 ; AND WAIT FOR PCP PROMPT
PAUSE 1
;
;
CLEAR
MESSAGE  "CHOOSE A CITY *** CHOOSE A CITY *** CHOOSE A CITY *** CHOOSE A CITY ***   "
MESSAGE  " A - Atlanta, GA         [404]           V - Denver, CO         [303]          "
MESSAGE  " B - Boston, MA          [617]           W - Washington, D.C. [202/301/703]    "
MESSAGE  " C - Chicago, IL         [312]           X - Phoenix, AZ        [602]          "
MESSAGE  " D - Dallas, TX          [214]           Y - New York, NY       [212]          "
MESSAGE  " E - Cleveland, OH       [216]           Z -                                   "
MESSAGE  " F - San Francisco, CA   [415]           0 - Portland, OR       [503]          "
MESSAGE  " G - Glendale, CA        [818]           1 - Tampa, FL          [813]          "
MESSAGE  " H - Houston, TX         [713]           2 - Minneapolis, MN    [612]          "
MESSAGE  " I - Miami, FL           [305]           3 -                                   "
MESSAGE  " J - San Jose, CA        [408]           4 -                                   "
MESSAGE  " K - Salt Lake City, UT  [801]           5 -                                   "
MESSAGE  " L - Los Angeles, CA     [213]           6 -                                   "
MESSAGE  " M - Milwaukee, WI       [414]           7 -                                   "
MESSAGE  " N - Newark, NJ          [201]           8 -                                   "
MESSAGE  " O -                                     9 -                                   "
MESSAGE  " P - Philadelphia, PA    [215]           @ -                                   "
MESSAGE  " Q -                                     # -                                   "
MESSAGE  " R - Research Triangle   [919]           $ -                                   "
MESSAGE  " S - Seattle, WA         [206]           % -                                   "
MESSAGE  " T - Detroit, MI         [313]           & -                                   "
MESSAGE  " U -                                     * -                                   "
MESSAGE  "**************************  ENTER YOUR CHOICE         *************************"
LOCATE 22,48 
GET S0
;
TOP:
FIND S0 "A"
     IF FOUND
        ASSIGN S1 "Atlanta, Georgia  [404]     "
        ASSIGN S2 "XATLANTA.CMD"
        ASSIGN S3 "404"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "B"
     IF FOUND
        ASSIGN S1 "Boston, Massachusetts [617] "
        ASSIGN S2 "XBOSTON.CMD"
        ASSIGN S3 "617"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "C"
     IF FOUND
        ASSIGN S1 "Chicago, Illinois    [312]  "
        ASSIGN S2 "XCHICAGO.CMD"
        ASSIGN S3 "312"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "D"
     IF FOUND
        ASSIGN S1 "Dallas, Texas   [214]       "
        ASSIGN S2 "XDALLAS.CMD"
        ASSIGN S3 "214"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "E"
     IF FOUND
        ASSIGN S1 "Cleveland, Ohio   [216]     "
        ASSIGN S2 "XCLEVELA.CMD"
        ASSIGN S3 "216"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "F"
     IF FOUND
        ASSIGN S1 "San Francisco, California [415]"
        ASSIGN S2 "XFRISCO.CMD"
        ASSIGN S3 "415"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "G"
     IF FOUND
        ASSIGN S1 "Glendale, California [818]  "
        ASSIGN S2 "XGLENDAL.CMD"
        ASSIGN S3 "818"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "H"
     IF FOUND
        ASSIGN S1 "Houston, Texas   [713]      "
        ASSIGN S2 "XHOUSTON.CMD"
        ASSIGN S3 "713"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "I"
     IF FOUND
        ASSIGN S1 "Miami, Florida   [305]      "
        ASSIGN S2 "XMIAMI.CMD"
        ASSIGN S3 "305"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "J"
     IF FOUND
        ASSIGN S1 "San Jose, California  [408] "
        ASSIGN S2 "XSANJOSE.CMD"
        ASSIGN S3 "408"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "K"
     IF FOUND
        ASSIGN S1 "Salt Lake City, Utah  [801] "
        ASSIGN S2 "XSALTLAK.CMD"
        ASSIGN S3 "801"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "L"
     IF FOUND
        ASSIGN S1 "Los Angeles, California [213]"
        ASSIGN S2 "XLA.CMD"
        ASSIGN S3 "213"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "M"
     IF FOUND
        ASSIGN S1 "Milwaukee, Wisconsin  [414] "
        ASSIGN S2 "XMILWAUK.CMD"
        ASSIGN S3 "414"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "N"
     IF FOUND
        ASSIGN S1 "Newark, New Jersey  [201]   "
        ASSIGN S2 "XNEWARK.CMD"
        ASSIGN S3 "201"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "O"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "P"
     IF FOUND
        ASSIGN S1 "Philadelphia, Pennsylvania  [215]"
        ASSIGN S2 "XPHILLY.CMD"
        ASSIGN S3 "215"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "Q"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "R"
     IF FOUND
        ASSIGN S1 "Research Triangle, North Carolina  [919]"
        ASSIGN S2 "XRESEARC.CMD"
        ASSIGN S3 "919"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "S"
     IF FOUND
        ASSIGN S1 "Seattle, Washington  [206]  "
        ASSIGN S2 "XSEATTLE.CMD"
        ASSIGN S3 "206"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "T"
     IF FOUND
        ASSIGN S1 "Detroit, Michigan  [313]    "
        ASSIGN S2 "XDETROIT.CMD"
        ASSIGN S3 "313"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "U"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "V"
     IF FOUND
        ASSIGN S1 "Denver, Colorado  [303]     "
        ASSIGN S2 "XDENVER.CMD"
        ASSIGN S3 "303"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "W"
     IF FOUND
        ASSIGN S1 "Washington, D.C.  [202/301/703]"
        ASSIGN S2 "XDC.CMD"
        ASSIGN S3 "202"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "X"
     IF FOUND
        ASSIGN S1 "Phoenix, Arizona  [602]     "
        ASSIGN S2 "XPHOENIX.CMD"
        ASSIGN S3 "602"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "Y"
     IF FOUND
        ASSIGN S1 "New York, New York  [212]   "
        ASSIGN S2 "XNY.CMD"
        ASSIGN S3 "212"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "Z"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "0"
     IF FOUND
        ASSIGN S1 "Portland, Oregon  [503]     "
        ASSIGN S2 "XPORTLAN.CMD"
        ASSIGN S3 "503"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "1"
     IF FOUND
        ASSIGN S1 "Tampa, Florida  [813]       "
        ASSIGN S2 "XTAMPA.CMD"
        ASSIGN S3 "813"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "2"
     IF FOUND
        ASSIGN S1 "Minneapolis, Minnesota  [612]"
        ASSIGN S2 "XMINNEAP.CMD"
        ASSIGN S3 "612"
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "3"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "4"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "5"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "6"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "7"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "8"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "9"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "@"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "#"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "$"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "%"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "&"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S0 "*"
     IF FOUND
        ASSIGN S1 "                            "
        ASSIGN S2 "           "
        ASSIGN S3 "   "
        GOSUB CKROTARY
     ELSE
     ENDIF
FIND S7 "MORE"                     ; IS A REDIAL NECESSARY?
IF FOUND                           ; YES!
   ASSIGN S7 "    "                ; RESET 'MORE' FLAG
   GOTO TOP                        ; AND GO DO IT AGAIN
ENDIF
MESSAGE "NO CITY REQUESTED"        ; IF WE GOT THIS FAR,
MESSAGE "EXITING TO PROCOMM"       ; THERE'S NOTHING TO DO!
ALARM                              ; BUT TELL THE USER
EXIT                               ; AND QUIT!
;
CKROTARY:
MESSAGE "DIALING"                  ; START DIALING OF PCP CITY
MESSAGE S1                         ; WHICH CITY IS IT?
TRANSMIT "C DIAL"                  ; START TRANSMISSION
TRANSMIT S3                        ; SEND AREA CODE
TRANSMIT "/"
TRANSMIT S5                        ; AND BAUD RATE
TRANSMIT ","
TRANSMIT S6                        ; AND USER ID
TRANSMIT "!"
WAITFOR "="
TRANSMIT S8                        ; AND PASSWORD
TRANSMIT "!"
RGET S9                            ; GET ECHO OF MY TRANSMISSION
RGET S9 80 40                      ; AND PCP'S LINEFEED
RGET S9 40                         ; AND THE REAL THING
PAUSE 1                            ; DISPLAY IT BRIEFLY
FIND S9 "CONNECTED"                ; GOT A CITY?
IF FOUND                           ; YES...
   ALARM
   EXECUTE S2                      ; CHAIN TO APPROPRIATE COMMAND FILE
ELSE                               ; NO!! GO DIAL ANOTHER (OR SAME) CITY...
   MESSAGE S1
   MESSAGE "BUSY -- GOING TO NEXT CITY..."
   ASSIGN S7 "MORE"
   MESSAGE "***********************************************************************"
ENDIF
RETURN
