;   ROUTINE TO EXECUTE A COMMAND BY USING THE AUTO
;   START FACILITY IN THE CP/M (V1.4, 2.0-2.2) .  IT
;   ASSUMES THAT THE CCP IS STILL INTACT (HAS NOT BEEN
;   CRASHED OR OVERLAYED.
CDISC	EQU	4	; CP/M DRIVE BUFFER LOCATION
;
;
TXBUF:	DB YY	; LENGTH OF BUFFER
	DB XX	; COMMAND LENGTH (EXCLUDING 00,0DH)
	DB 'COMMAND'
	DB 00	; NULL
	DB 0DH	; CARRIAGE RETURN
;
;
;
	LHLD	1		; GET JUMP TO BIOS
	LXI	D,-1603H	; OFFSET FOR CP/M 2.X (USE 1503
				; FOR CP/M 1.4X
;
	DAD	D
	SHLD	LDCCP		; SAVE CCP LOCATION
	LXI	H,TXBUF+1	; POINT TO COUNTER
	MOV	A,M		; GET IT
	ORA	A		; IS IT STILL ZERO?
	JZ	REXIT		; YES, SO NO AUTO START
	INR	A		; INCREMENT COUNTER FOR COPY
	INR	A
	INR	A
	MOV	C,A		; GET INTO (B,C)
	MVI	B,0
	PUSH	H		; SAVE POINTER
	LHLD	LDCCP		; GET CCP POINTER
	LXI	D,7		; POINT AT COUNTER LOCATION
	DAD	D
	XCHG			; SAVE AS DESTINATION POINTER (D,E)
	POP	H		; GET BACK SOURCE POINTER
	CALL	MOVE		; COPY CODE INTO CCP BUFFER
	LHLD	LDCCP		; GET POINTER TO CCP
	LXI	D,88H		; OFFSET TO CCP TXBUF POINTER
	DAD	D
	PUSH	H		; SAVE POINTER
	LHLD	LDCCP
	LXI	D,8		; OFFSET TO START OF BUFFER
	DAD	D
	XCHG			; SAVE IN (D,E)
	POP	H		; GET POINTER BACK
	CALL	PTDE		; RESET POINTER VALUE
	LHLD	LDCCP		; GET CCP ADDRESS
	LDA	CDISC		; GET DISC #
	MOV	C,A		; SAVE FOR CCP FUNCTION
	PCHL			; DO AUTO START
;
MOVE:	MOV	A,M	; GET BYTE FROM SOURCE
	STAX	D	; SAVE AT DESTINATION
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVE	; LOOP UNTIL DONE
	RET
;
REXIT:	...	; ROUTINE OR PROGRAM TO GO TO
		; IF COMMAND LENGTH IS ZERO.
;
LDCCP:	DS	2	; BUFFER FOR CCP LOCATION
;
	END
