;-------------------------------------------------
; AUTOCPM.ASM   version 1.0              10/12/81
;
; copyright 1981 by Thom Hogan
;
;              Basically Speaking Press
;              401 Fulton
;              Palo Alto, CA  94301
;
; This program loads and executes HELP.COM
;
;-------------------------------------------------
;
; EQUATES
;
clear      equ     26      ;clear screen
escape     equ     1bh     ;escape character
graph      equ     'g'     ;graphics
nograph    equ     'G'     ;nographics
pbuff      equ     9       ;BDOS print buffer
bdos       equ     5       ;location of BDOS
cr         equ     0dh     ;carriage return
lf         equ     0ah     ;line feed
;
; START OF PROGRAM
;
           org     0100h
;          
           lhld    01
           mvi     l,00
           mov     a,h
           sui     16h
           mov     h,a
           shld    ccp
           lxi     d,logo
           lxi     b,2047
over:      ldax    d
           sui     65
           stax    d
           inx     d
           dcx     b
           mov     a,b
           ora     a
           jnz     over
start:     
           lxi     d,startgr       ;point to startgraphics
           call    print
           lxi     d,logo          ;point to message
           call    print           ;display it
           lxi     d,stopgr        ;point to endofgraphics
           call    print           ;display it
           lxi     d,endmes        ;point to loadmessage
           call    print
           lxi     d,filename      ;point to filename
           lxi     b,10            ;set counter
move:
           lhld    ccp
           mvi     l,07
           call    again           ;move it
           lhld    ccp
           mvi     l,88h
           mvi     a,08h           ;lsb of ccp pointer
           mov     m,a             ;put it in place
           lhld    ccp
           mvi     l,89h
           mov     a,h
           mov     m,a	
           lhld    ccp
           pchl                    ;execute cold start
again:
           ldax    d               ;get byte to move
           mov     m,a             ;move it
           inx     h               ;increment location
           inx     d               ;increment location
           dcx     b               ;decrement counter
           mov     a,b             ;get counter in a
           ora     c               ;check if done
           jnz     again           ;...not done
           ret                     ;...done
print:
           mvi     c,pbuff         ;get proper call in c
           jmp     bdos            ;do it
;
; STORAGE AREA
;
ccp:       ds      2
filename:  db      04,'HELP',0,0,0,0,0,0,0
;                  ^    ^      ^
;            length  command  must be followed by
;        of command  string   zeroes to work properly
;
; note: if command string is longer than 8 characters,
;       you must change "lxi b,10" to "lxi b,length+2"
;    
startgr:   db      clear
           db      escape,graph,'$'
stopgr:    db      escape,nograph,'$'
endmes:    db      cr,lf,lf,lf,9,'Loading HELP & CP/M...',cr,lf,lf,'$'
logo:      db      'YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaaKWWWWWWWWWWWWWWWWWWWWI'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY'
           db      'Iaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaKWWWWWWZaaaaaaaaaaVWWWWW'
           db      'WIaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY'
           db      'YYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaWWWWWWWaaaaaaaaaaaaWWWWW'
           db      'WWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY'
           db      'YYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaWWWWWWWaaaaaaaaaaaaWWWWW'
           db      'WWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY'
           db      'YYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaWWWWWWWaaaaaaaaaaaaWWWWW'
           db      'WWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY'
           db      'YYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaVWWWWWWIaaaaaaaaaaKWWWWW'
           db      'WZaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY'
           db      'Zaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaaVWWWWWWWWWWWWWWWWWWWWZ'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'
           db      'aaaaaaaaaaaaaaaaaaaaaaaaaaaa$'
end
