/****************************************************************
 *   Metal Message System summary command routine.
 *
 *	File:  MESUMM.C  Version 1.10e
 *
 *	Copyright (c) 1984  Tim Gary
 *	Delphi Data Systems
 *	All Rights Reserved.
 *
 ****************************************************************
 *
 *  1.10e  11/01/84 Added ability to do summary of dead msgs.
 *  1.10e  10/30/84 Width stuff changed again.
 *  1.10a   9/01/84 Taken from MS.C for Overlay Metal.
 *
 ****************************************************************/

#include "xpm.h"
#include "hmh.h"
#include "hmconfg.h"
#include "ctype.h"

/***************************************************
 * do a 'quick' or slow summary of the messages... *
 ***************************************************/

ovmain(func,mode)
int func;		/* not used in this overlay, but definition required */
register int mode;
{
register int flag;
register unsigned start;
char temp[MAXLINE+1],sreq;

#ifdef MULTI_USER
 mu_update();		/* get anything new that's happened */
#endif

*temp='\0';
if (!msgcount) return;

do	{	/* if '?' entered, or user is novice.. print this... */
	if (*temp=='?' || (user.parm.expert==POFF && strloc==0))
		{
		send("\nEnter message number to start summary at.\n");
		if (*temp=='?') search_help();
		}
	sprintf(buffer,"\nStarting message (%u-%u) ?",fmsg,lmsg);
	ask(buffer,temp,MAXLINE,UP);
	} while (*temp=='?');

if (*temp=='K')
	{
	sprintf(temp,"%s",temp+1);
	mode|=0x80;
	}

sreq=msearch(temp);		/* setup search string if called for.. */
if (!strcmp(temp,"0")) *temp='1';	/* make 0 same as 1 */
if (isdigit(*temp))		/* number entered.. check if valid */
  {
  if ((start=atoi(temp))>lmsg || start<1)
		{
		send("\n[Invalid message number]");
		return;
		}
  }
  else if (sreq==FALSE) return;		/* no #, see if search req */
	 else start=1;			/* yep.. start at first msg */

	if ((summary=open(SUMMARY,F_RD | F_UNLOCK))==NULL)
		return;
	setarec(summary,1);		/* skip count */
	novhelp();			/* help a local novice */
	do flag=msgheader(summary,start,mode);
	 while (!breakkey() && flag!=ERROR);
	close(summary);
	if (flag==ERROR) send("\n[End Msgs]\n");
}


/* End of File */
