/*******************************************************/
/*											*/
/*	This is the program that will call the functions	*/
/*	in the sample.asm module.  If you try to assemble */
/*	and compile this program, you will need the 		*/
/*	Miscrosoft Macro Assembler and the Lattice C		*/
/*	compiler.  No special switches were used during	*/
/*	assembly or compilation.  					*/
/*											*/
/*******************************************************/
/*											*/
/*		Written	December 1, 1987				*/
/*											*/
/*		Author	David Midkiff					*/
/*				D. M. Software And Systems		*/
/*											*/
/*******************************************************/

#include "stdio.h"
#include "dos.h"
#include "sample.h"

/* <S>Global Variable Declarations */
/* PAGE */

char *notstring = " NOT " ;

/* These are the machine name strings */
char *pcname[] = {
	"Non-IBM" ,
	"IBM PC-AT or compatible" ,
	"IBM PC-JR or compatible" ,
	"IBM PC-XT or IBM Portable or compatible" ,
	"IBM PC or compatible"
	} ;
	
char *space = " " ;

/*<s>ISCOLOR()*/
/*page*/

/*****************************************************************/
/*													*/
/*	ISCOLOR() - Determine if the equipment flag has the correct	*/
/*			  values for a color display adapter.			*/
/*													*/
/*****************************************************************/

int iscolor( flag )
    int flag ;
{

	return ( (flag&0x0030) == 0x0030 ) ;
	
}	/* end of iscolor() */

/*<s>MAIN()*/
/*Page*/

/*****************************************************************/
/*													*/
/*	MAIN() - Main line to decode the byte in the machine ID and	*/
/*		    equipment bytes from the BIOS.					*/
/*													*/
/*****************************************************************/

void main()
{

	int equipflag ;			/* Equipment flag word from BIOS */
	int systemtype ;			/* Machine ID byte */

	systemtype = machine() ;
	printf( "\nSystem is a %s.  (ID is 0x%04X)" , ((systemtype >= 0x00FC)&&(systemtype <= 0x00FF)) ? pcname[systemtype-0x00FB] : pcname[0] , systemtype ) ;

	equipflag = equip() ;
	printf( "\nEquipment flag word is 0x%04X" , equipflag ) ;
	
	/* WARNING --- THIS IS NOT THE CORRECT WAY TO TEST FOR AN 80x87 !!! */
	if( systemtype == 0x00FC )
		printf( "\nThere is%sa 80287 installed." , ((equipflag&0x02)==2) ? space : notstring ) ;
	else
		printf( "\nThere is%sa 8087 installed." , ((equipflag&0x02)==2) ? space : notstring ) ;

	printf( "\nThere is a %s display adapter." , (iscolor(equipflag)==1) ? "monochrome" : "color" ) ;

	printf( "\nThere are %d diskette drives." , ( equipflag & 0x00C0 ) >> 5 ) ;
	
	printf( "\nThere are %d serial ports." , ( equipflag & 0x0300 ) >> 8 ) ;
	
	printf( "\nThere are %d parallel ports." , (equipflag & 0xC000 ) >> 14 ) ;

	exit( 0 ) ;
	
}	/* end of main() */

/*************************/
/*					*/
/*	END OF SAMPLE.C	*/
/*					*/
/*************************/
