/**************************************************************************
 *
 *	Global variable definitions for Metal/Z-Msg
 *
 *
 *	FILE: MEGLOB.H
 *
 *		    Copyright (c) 1984,1985,1986  Tim Gary
 *			    All rights reserved.
 *
 **************************************************************************
 *
 * 1.50xx 08/04/86  Question/phone stuff added..
 * 1.50xx 07/04/86  Added mask to built-in commands for selective use..
 * 1.50xx 04/10/86  Added INITPARMS to O structure..
 * 1.50xx 04/08/86  Change user type structure..  flags move to one byte.
 * 1.50xx 03/08/86  Group structure stuff added..
 * 1.50xx 03/01/86  Added msg->group for tagged read, mail read, groups....
 * 1.40xx 02/28/86  Global unsigned define for msg_reply(xx,xx),
 *		   msg[].reply gone
 * 1.40xx 02/04/86  Add definitions for user hash functions..
 * 1.40xx 01/28/86  Put back city/state field in users structure...
 * 1.40xx 01/25/86  More minor changes..
 * 1.40xx 01/19/86  Changes in users file format, and O structure (files)
 * 1.31a  10/13/85  Release version.
 * 1.31xx 08/16/85  This file created from parts of HMH.H
 *
 *************************************************************************/

/*************************************************************************
 * NOTE: If INITGLOB is set, then the variables will be defined as
 *	 non-externals, and will be initialized.
 *************************************************************************/

unsigned xtou();		/* ascii hex to unsigned */
int atoi();			/* to make sure it's pulled in */
char *asctime(),*ascdate();	/* from internal date/time to ascii */
FILE *open_hash(),*lopen();
unsigned hash_fn(),msg_reply();

/* Global character array for various routines */

#ifdef INITGLOB
char buffer[257]="Metal Message System (TM) and Z-MSG (TM) Copyright (c) 1984,1985,1986 by Tim Gary  All rights reserved.\n";
#else
extern char buffer[257];
#endif	/* INITGLOB */

char glbstr[MAXLINE+2];	/* global string used with ask(), etc.. and ';' */

char last_time[2],last_date[3];

#ifdef INITGLOB
char print_flag=OFF;	/* flag for print mode */
char echo_flag=ON;	/* flag for "half-dup" non echo.. */
int strloc=0;		/* current position into glbstr */
int globalch='\0';	/* global char */
char sepstr='\0';	/* if !=0 then this acts same as ';' */
#else
extern char print_flag;	/* flag for print mode */
extern char echo_flag;	/* flag for "half-dup" non echo.. */
extern int strloc,globalch;
extern char sepstr;
#endif /* INITGLOB */


/****************************************
 * message base variable definitions	*
 ****************************************/

struct msg_ind {
	unsigned number;	/* message number	*/
	unsigned seek;		/* seek pointer to message header */
	unsigned parent;	/* parent msg.. original msg in rep. series */
	    char group;  	/* group code */
	    char flags;		/* tagged, mail, top 5bits info into summary */
	} *msg;	/* POINTER NOW */

unsigned fmsg,lmsg;	/* first/last active msg numbers	*/
int mindex;		/* index into above msg array		*/


/*****************************************
 * Groups structure, and begining pointer 
 *****************************************/

struct _group	{
	unsigned read_flags;	/* bitmap for who can read this		*/
	char	*name;		/* pointer to group name (malloc'd too)	*/
	} *group;		/* up subgroups (malloc this to N_GROUPS) */

int n_groups;			/* number of groups */

/**********************************************************************
 * message structure definition, new format with unencoded #'s, etc.. *
 **********************************************************************/

#ifndef CONFIG
typedef struct	{
	unsigned number;		/* message # */
	unsigned seek;			/* cp/m record, seek loc of msg */
	unsigned parent;		/* parent message #, if any	*/
	char	group;			/* group code */
	char	place_holder; /* --------------- */
	char	receiver[NAMELEN+1];	/* who's msg to?	*/
	char	sender[NAMELEN+1];	/* who's msg from (first name)	*/
	char	status;			/* private/normal, etc.. */
	int	lines;			/* # of lines in message */
	char	date_entr[3];		/* date message entered */
	char	time_entr[2];		/* time message entered */
	char	date_read[3];		/* date read by first receiver */
	char	time_read[2];		/* time read by first receiver */
	char	topic[TOPICLEN+1];	/* subject of message	*/
/*    ----vvvvvvvvv------------- */
	char	nada[29];	/* temp filler because of size change */
	} msg_record;	/* new type */

/**************************************************************************
 * and now, the external, globally known, and loved, one and only msg var *
 **************************************************************************/

msg_record message;	/* Message variable that can be, and is, read	*/
			/* directly from the message/summary file	*/

/* these next three are for the read messages overlay */
char prevsender[NAMELEN+2];
unsigned prevmsg;		/* previous message #, for reply */
#ifdef INITGLOB
char status=DEADMSG;		/* current message status	 */
#else
char status;
#endif

int msgcount;		/* # of active messages		*/
int privmsgs;		/* # of private messages	*/
unsigned nextmsg;	/* next message number		*/
unsigned totalmsgs;	/* total active and killed msgs allowed	*/

unsigned callnum;	/* caller number NOW UNSIGNED!	*/
char date[3];		/* todays date			*/
char time[2];		/* time				*/

char nothing[6];	/* place to put BYE parms if inactive */

/***********************
 * global BYE pointers *
 ***********************/

char *bye,*maxuser,*maxdrive,*tout,*nulls;

#endif /* CONFIG */

/***********************************************************************
 * global height var, so routines aren't dependent on user.parm.height *
 ***********************************************************************/

#ifdef INITGLOB
char height=24;	/* terminal height for putchar.. assume 24 char screen */
#else
extern char height;
#endif

/****************
 * global files	*
 ****************/

FILE *users;		/* users file			*/
FILE *summary;		/* summary file for messages	*/
FILE *messages;		/* message base file		*/

/**************************
 * user type parameters.. *
 **************************/

typedef	struct	{
	char type;	/* the character that gets this type 		*/
	char maxuser;	/* Max CP/M user number this guy gets, 0=nocpm	*/
	char maxdrive;	/* Max drive avail.. 				*/
	char timeout;	/* # of mins before no-typing timeout, 0=twit	*/
	char privflags;	/* This replaces the above 4.. bit mapped flags	*/
	char minutes;	/* minutes allowed on system (Metal/MBYE)	*/
	unsigned flags;	/* special flags for Z3 commands file		*/
	char sysseg[5][14];	/* 8 zcpr3 system segments to load	*/
	unsigned regs[10];	/* z3 reg settings.. (hi=if set, low=value) */
	char sysnum;	/* system file number to put lastcaller things in */
	char path[16];	/* DU form path... for z3			*/
	} u_types;

u_types *get_tp();	/* declare this */

/*********************************************************
 * Make this a type, so that it can be defined elsewhere *
 *********************************************************/

typedef struct	{
	unsigned number;	/* seek pos. in mem, next bucket in file */
	char	file_info;	/* bit info for users file routines */
	char	name[NAMELEN+1];	/* namelen=26..+1 */
	char	pass[PASSLEN+1];	/* passlen=8...+1 */
	char	city[CITYLEN+1];	/* citylen=26..+1 */
	char	date[3];	/* last date */
	char	time[2];	/* last time */
	unsigned lastread;	/* high message # at last login */
	char	status;		/* status character		*/
	char	login;		/* login method, message sys/os/other */
	char	flags;		/* expert (2 bits), bell, rp + other toggles */
	char	nulls;		/* number of nulls		*/
	char	width;		/* width of user display	*/
	char	height;		/* height of user display	*/
	char	minutes;	/* minutes on system today	*/
	unsigned tot_hours;	/* total hours on system so far   */
	char	tot_mins;	/* remainder mins on system total */
	unsigned calls;		/* number of calls made to system */
	unsigned uploads;	/* number of files uploaded	*/
	unsigned downloads;	/* number of files downloaded	*/
	unsigned group_flags;	/* groups user can read flags	*/
	char	tcap[8];	/* space padded Z3 tcap name	*/
        unsigned info_link;	/* record location of more info link */
        char    phone[13];	/* 12 chars (aaa-ppp-nnnn) + \0 */

	char	nada[14];  /* temp placeholder */

	/* the following variables are not saved in the file */
	u_types	*type_ptr;	/* pointer to type based on status..*/
	} usr;

usr user;	/* user variable */


#ifndef HMLIB
struct cmdtype {	/* command structure definition  */
	unsigned mask;		/* commands mask for selective use */
	char	*abbr;		/* abbreviation 	 */
	char	*full;		/* the rest of the thing */
	int	(*func)();	/* pointer to function   */
	int	value;		/* call the routine with this value */
	int	ovname;		/* overlay name if used  */
	};
#endif

#define	BYE	(O.byecom)	/* COM file run when complete exit of sys */
#define OS	(O.oscom)	/* COM file when exit to OS */

/****************************************************
 * All Options are contained in one large structure *
 ****************************************************/

struct options	{
	char	zippo[10];		/* mark start of options	*/
	char	cfg_vers[10];		/* config file format version	*/
	u_types	user_types[11];		/* User types table		*/
	char	DSTATUS;		/* default user status (login init) */
	char	PRIVATE;		/* private system flag		*/
	   char	PRIVPASS[PASSLEN+1];	/* private system password	*/
	char	file_locs[21][5];	/* file locations		*/
	char	oscom[18];		/* COM file to run when entering OS */
	char	byecom[18];		/* COM file to run when leaving sys */
	char	MAXTRIES;		/* Max # of logon attempts	*/
	int	MAXMSGS;		/* Max # of ACTIVE msgs allowed	*/
	char	MAXMSGLINE;		/* Max length of msg line	*/
	int	MLINES;			/* Max # of lines		*/
	int	MAXTOTMSGS;		/* Max total active + dead msgs */
	char	RTC;			/* using clock???		*/
	char	ASKNULLS;		/* if bye asks for nulls	*/
	char	ZCPR;			/* version of ZCPR if used	*/
	   char *SECURELOC;		/* location of zcpr wheel (1&2)	*/
	char	*id_loc;		/* console id # value pointer	*/
	char	INIT_G_FLAGS;		/* init group flags for new user*/
	char	INITLENGTH;		/* initial terminal length	*/
	unsigned INITPARMS;		/* initial user parms		*/
	char	QUESTION[MAXLINE];	/* question for phone field */
	char	WHERE[81];		/* location of site		*/
	char	PRTLOG;			/* if using printer for log	*/
	char	STATUSLINE;		/* you have status line???	*/
	   char	TO25[16];		/* up to 15 chars to get there	*/
	   char	FROM25[16];		/* to get back to last position	*/
	   unsigned OSTAT;		/* Terminal output stat port	*/
	   unsigned ODATA;		/* Terminal data port		*/
	   char	OSMASK;			/* output status mask		*/
	char	SONAME[NAMELEN+1];	/* sysop's name			*/
	char	SOPASS[PASSLEN+1];	/* sysop password		*/
	char	BBSNAME[50];		/* Make of bbs.. Metal or Z-Msg	*/
	char	VERSION[35];		/* "Version xx.xxxx"		*/
	char	ALIASRET[20];		/* Alias ret cmd line..		*/
	char	Z3MSG;			/* z3 msg area offset.. 0x48	*/
/* zappo to end this madness */
	char	zappo[10];		/* "KABOOM!!!"	EOO flag	*/
	};

#ifdef INITGLOB
#include "MEINITO.H"	/* options variable init */
#else
	struct options O;
#endif

/* global variables needing saving */

#ifndef HMLIB
#ifndef CONFIG
#ifdef Z3

/* Z3 command line buffer pointer below */

struct cmd_line {
	char *next_char;	/* Pointer to next char in buffer */
	char buf_size;		/* length of buffer (unused)	  */
	char char_cnt;		/* character count		  */
	char buffer[250];	/* buffer area..		  */
	} ;	/* command line pointer structure */

struct envptr {
	char	jmp[3];		/* skip over initial JMP instruction */
	char	id[5];		/* Id, usually Z3ENV		*/
	char	class;		/* 1=external, 2 internal	*/
	char	*expath;
	char	expaths;
	char	*rcp;
	char	rcps;
	char	*iop;
	char	iops;
	char	*fcp;
	char	fcps;
	char	*ndir;
	char	ndirs;
	struct cmd_line *cl;	/* command line pointer			*/
	char	cls;		/* # of bytes in cl			*/
	char	*env;		/* ptr to external environment desc.	*/
	char	envs;
/*	char	*shstk;	*/	/* shell stack				*/
/*	char	shstks;	*/	/* # of (shsize) stack entries		*/
/*	char	shsize;	*/	/* size of shell stack entry		*/
   char t1[4];
	char	*msg;		/* message buffer			*/
/*	char	*extfcb;
	char	*extstk;
 */
   char t2[4];
	char	quiet;
	char	*wheel;		/* secure mode wheel		*/
	char	speed;		/* speed in mhz			*/
	char	maxdisk;
	char	maxuser;

	} *z3env;

/* This header structure variable protects globals when doing an alias */

struct g_prot {
	char n0;		/* jmp */
	char *obdos;
	char msgsys[7];		/* "MSGSYS",0 */
	char *g_vars;		/* pointer to global variables */
	struct	{
		char jmp;
		char *addr;
		} bt[6];
	char swap;		/* push h */
	char n1;		/* lxi h  */
	char *prot_bdos;
	char n2;		/* shld 6 */
	char *n3;
	char n6;		/* pop h */
	char n7;		/* ret */
	struct	{
		char call;
		char *addr;
		char jmp;
		char *swapbdos;
		} abt[6];
	} g_h
#ifdef INITGLOB
	      = {
		0xc3,0000,"MSGSYS",0000,
			{ 0xc3,0000,
			  0xc3,0000,
			  0xc3,0000,
			  0xc3,0000,
			  0xc3,0000,
			  0xc3,0000 },
		0xe5,0x21,0000,0x22,0006,0xe1,0xc9,
			{ 0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000 }
		}
#endif	/* MAIN */
;

struct g_prot *z3_hp;	/* loc to put this at */

struct g_save {
	char	*msg;
	char	glbstr[MAXLINE+2];
	int	strloc;
	int	globalchar;
	char	print_flag;	/* flag for print mode */
	char	echo_flag;	/* flag for "half-dup" non echo.. */
	char	sepstr;
	unsigned fmsg,lmsg;
	int	mindex;
	int	msgcount;
	int	privmsgs;
	unsigned nextmsg,totalmsgs;
	unsigned callnum;
	char	date[3];
	char	time[2];
	char	height;
	char	last_date[3];
	char	last_time[2];
	struct	cmd_line cmdbuf;  /* place to save current z3 cmd buffer */
	char	sotries;
	int	n_groups;	  /* number of groups	*/
	char	path[24];	  /* allow for 12 path entries */
	};

#endif /* Z3 */
#endif /* NOT-CONFIG */
#endif /* HMLIB */

/* EOF (MEGLOB.H) */


