           TITLE     'Wolfware Sample Program','Binary Type'

;----------------------------------------------;
;                  Binary Type                 ;
;                                              ;
; Displays files to screen as ASCII            ;
; characters.  Once assembled, to display a    ;
; file, type:                                  ;
;                                              ;
; BTYPE [filespec]                             ;
;                                              ;
; There is no translation of any codes, all    ;
; are displayed as characters.  The number of  ;
; bytes to display are determined by the size  ;
; of the file in the directory. Does not       ;
; support path names.                          ;
;----------------------------------------------;

           PROC      FAR
FCB        EQU       5CH            ;formated FCB location
SEG_SIZE   EQU       WORD [6]       ;bytes in segement

           MOV       DX,FCB         ;FCB
           CALL      OPEN           ;open file
           PUSH      DX

;----- calculate available space

           MOV       AX,SEG_SIZE    ;bytes in segement
           SUB       AX,OFFSET BUFFER + 100H ;space for program and stack
           MOV       READ_SIZE,AX   ;save bytes to read

;----- get active page and columns per line

           MOV       AH,15          ;get video state function
           INT       10H            ;execute

           MOV       COL_SIZE,AH    ;save columns
           MOV       ACT_PAGE,BH    ;save page

;----- display file

MORE       MOV       BX,OFFSET BUFFER ;put after program
           MOV       CX,READ_SIZE   ;bytes to read
           MOV       BP,SP
           MOV       DX,[BP]        ;FCB location from stack
           CALL      READ           ;read into buffer

           PUSHF
           MOV       SI,BX          ;source
           CALL      DISPLAY        ;display bytes to screen
           POPF
           JZ        MORE           ;jump if more to read

;----- finished, close file

DONE       POP       DX
           CALL      CLOSE          ;close file
           INT       20H            ;exit

;----- data

READ_SIZE  DW        ?              ;bytes to read
COL_SIZE   DB        ?              ;number of columns in a line
ACT_PAGE   DB        ?              ;active screen page

;----------------------------------------------;
;                    DISPLAY                   ;
; Display CX bytes at SI.                      ;
;----------------------------------------------;

DISPLAY    PROC      NEAR
           OR        CX,CX          ;check if zero bytes
           JZ        NOBTD          ;jump if so

BTDLOOP    LODSB                    ;load next byte

           PUSH      CX
           PUSH      SI
           CALL      DISPLAY_CHAR   ;display
           CALL      INC_CURSOR     ;move cursor
           POP       SI
           POP       CX

           LOOP      BTDLOOP
NOBTD      RET
           ENDP                     ;DISPLAY

;----------------------------------------------;
;                 DISPLAY_CHAR                 ;
; Display character in AL.                     ;
;----------------------------------------------;

DISPLAY_CHAR PROC     NEAR
           MOV       BH,ACT_PAGE    ;active screen page
           MOV       CX,1           ;one character
           MOV       AH,10          ;character display function
           INT       10H            ;execute
           RET
           ENDP                     ;DISPLAY_CHAR

;----------------------------------------------;
;                   INC_CURSOR                 ;
; Increment cursor. Switch to new line if at   ;
; end of line.                                 ;
;----------------------------------------------;

INC_CURSOR PROC      NEAR
           MOV       BH,ACT_PAGE    ;page
           MOV       AH,3           ;read cursor position function
           INT       10H            ;execute

           INC       DL
           CMP       DL,COL_SIZE    ;check if on last column
           JE        NEWLINE        ;if to far then jump

;----- move cursor right one

           MOV       AH,2           ;move cursor function
           INT       10H            ;execute
           RET

;----- new line

NEWLINE    MOV       BL,15          ;forground color if graphics (?)
           MOV       AX,0E0DH       ;CR with teletype function
           INT       10H            ;execute
           MOV       AX,0E0AH       ;LF with teletype function
           INT       10H            ;execute
           RET
           ENDP                     ;INC_CURSOR

;----------------------------------------------;
;                     OPEN                     ;
; Open file using the FCB at DX.  Print error  ;
; message and exit program if can't open file. ;
;----------------------------------------------;

OPEN       PROC      NEAR
           MOV       AH,0FH         ;open file function
           INT       21H            ;execute

           OR        AL,AL          ;check if error
           JNZ       BTERROR        ;jump if so

           MOV       BX,DX
           MOV       WORD [BX+0EH],1 ;record size one
           MOV       WORD [BX+21H],0 ;record number (low) zero
           MOV       WORD [BX+23H],0 ;record number (high) zero
           RET

;----- couldn't open file, error

BTERROR    MOV       DX,OFFSET EMESS ;error message location
           MOV       AH,9           ;string display function
           INT       21H            ;execute
           INT       20H            ;exit

;----- error message

EMESS      DB        'File not found or error in parameter',13,10,'$'
           ENDP                     ;OPEN

;----------------------------------------------;
;                     READ                     ;
; Read CX bytes to BX using FCB in DX. ZF=1 if ;
; there is more in file and CX returns the     ;
; number of bytes read.                        ;
;----------------------------------------------;

READ       PROC      NEAR

;----- set DTA

           PUSH      DX
           MOV       DX,BX          ;DTA location
           MOV       AH,1AH         ;set DTA function
           INT       21H            ;execute
           POP       DX

;----- read bytes

           MOV       AH,27H         ;read random block function
           INT       21H            ;execute
           OR        AL,AL          ;set ZF
           RET
           ENDP                     ;READ

;----------------------------------------------;
;                      CLOSE                   ;
; Close file using FCB at DX.                  ;
;----------------------------------------------;

CLOSE      PROC      NEAR
           MOV       AH,10H         ;close fiel function
           INT       21H            ;execute
           RET
           ENDP

BUFFER     LABEL     BYTE
           ENDP

