type    {This must be at the beginning of the program using FILEMENU}
   longstring=string[50];

{USAGE:
   create a string variable at least 8 characters long.  Then, whenever you
   want the user to select a filename from the menu, use the function
   FILEMENU.  For example, if you have a string variable named XSTR, you
   would have the statement XSTR:=FILEMENU('*.*') somewhere in your program.
   This would cause a list of all the disk files to be displayed on the screen
   without extensions.  The user then uses the arrow keys to point to a
   filename, and presses ENTER.  The name of the file selected (without the
   extension) is returned to the variable XSTR.

   The parameter passed to the FILEMENU function is a wildcard string that
   limits the files that are displayed.  For example, if you only want to
   display .COM files, use XSTR:=FILEMENU('*.com').  If you want to use every
   file on the disk, use XSTR:=FILEMENU('*.*').                               }


function filemenu(files:longstring):longstring;
TYPE
    pathtype  = STRING[62];
    drivetype = STRING[2];
    rtype     = RECORD
                      ax,bx,cx,dx,bp,si,di,ds,es,flags:INTEGER
                END;
    kbdtype=string[2];
VAR
   origdta,DTA:array[0..120] of byte;
   max,pos,delta,j:integer;
   xstr:kbdtype;

function inkey : kbdtype;
   var
      a     : string[2];
      ch    : char;
   begin
      if keypressed then
         begin
            read(kbd,ch);
            a := ch;
            if keypressed and (ch = #27) then
               begin
                  read(kbd,ch);
                  a := concat(a,ch);
               end;
         end
      else
         begin
            a[1]:=#0; a[2]:=#0; a:='';
         end;
      inkey := a;
   end;

procedure setdta;
   var
      reg:rtype;
   begin
      reg.ax:=$1A00;
      reg.ds:=seg(dta[0]);
      reg.dx:=ofs(dta[0]);
      intr($21,reg);
   end;

FUNCTION findfirst(w:pathtype):pathtype;
VAR
   reg: rtype;
   i  : INTEGER;
   x:char;

BEGIN
  reg.ax:=$4E00;
  reg.ds:=Seg(w[1]);
  reg.dx:=Ofs(w[1]);
  reg.cx:=0;
  dta:=origdta;
  Intr($21,reg);
  if origdta[30]=0 then
     origdta:=dta;
  w:='';
  for i:=30 to 43 do
     w:=concat(w,chr(dta[i]));
  i:=1;
  while (i<13) and (w[i]<>#0) do
     i:=i+1;
  w[0]:=chr(i);
  findfirst:=w;
END;

FUNCTION findnext:pathtype;
VAR
   w  : pathtype;
   reg: rtype;
   i  : INTEGER;
   x:char;

BEGIN
  reg.ax:=$4F00;
  Intr($21,reg);
  if reg.ax <>18 then
    begin
      w:='';
      for i:=30 to 43 do
        w:=concat(w,chr(dta[i]));
      i:=1;
      while (i<13) and (w[i]<>#0) do
        i:=i+1;
      w[0]:=chr(i);
      findnext:=w;
    end
  else
    findnext:='!!!!';
END;

procedure displaydir;
   var
      x:pathtype;
   begin
      max:=0;
      setdta;
      for j:=0 to 43 do
         origdta[j]:=0;
      x:='         ';
      x:=findfirst(files);
      x:=findfirst(files);
      while x<>'!!!!' do
         begin
            j:=1;
            while (x[j]<>'.') and (j<9) do
               j:=j+1;
            x[0]:=chr(j-1);
            while length(x)<8 do
               x:=concat(x,' ');
            write(x:10);
            max:=max+1;
            x:=findnext;
         end;
   end;

procedure cursor;
   var
      i,addr:integer;
   begin
      addr:=1+pos*20;
      i:=addr;
      while i<addr+20 do
        begin
          mem[$b800:i]:=mem[$b800:i] xor 127;
          i:=i+2;
        end;
   end;

function readname:longstring;
   var
      x:pathtype;
   begin
      max:=0;
      x:='         ';
      x:=findfirst('files');
      x:=findfirst('files');
      while max<pos do
         begin
            max:=max+1;
            x:=findnext;
         end;
      j:=1;
      while (x[j]<>'.') and (j<9) do
         j:=j+1;
      x[0]:=chr(j-1);
      readname:=x;
   end;

begin
   xstr[1]:=#0; xstr[2]:=#0;
   clrscr;
   gotoxy(1,1);
   displaydir;
   pos:=0; cursor;
   repeat
      xstr:=inkey;
      delta:=0;
      if xstr[1]=#27 then
          case xstr[2] of
            'H':delta:=-8;
            'K':delta:=-1;
            'M':delta:=1;
            'P':delta:=8;
          end;
      if delta<>0 then
        begin
          cursor;
          pos:=pos+delta;
          if (pos=-1) and (delta=-1) then pos:=max-1;
          if (pos=max) and (delta=1) then pos:=0;
          if pos>=max then pos:=pos mod 8;
          if pos<0 then pos:=max+((pos-((max) mod 8)) mod 8);
          if pos=max then pos:=pos-8;
          cursor;
          xstr[1]:=#0; xstr[2]:=#0;
        end;
   until xstr[1]=#13;
   cursor;
   filemenu:=readname;
end;

