ECHO OFF
CLS
REM ----------file ARC.BAT-------------------------------------------
REM
REM INSTRUCTIONS
REM ------------
REM
REM REQUIRED:
REM
REM     1. Existence of directories C:\ARC and C:\TEMP
REM     2. Use of PKPAK or PKARC archive utility
REM     3. Files to archive must reside in C:\TEMP
REM
REM To archive a group of files into a template, just type
REM
REM ARC template
REM
REM where "template" represents the name of the template (a file
REM ending with extension ".arc").  Do not type the extension ".arc",
REM as ARC.BAT takes care of that.  (Also, do not type "REM ", as
REM this is a batch file's "REMark" line.)
REM
REM This batch routine assumes that directories C:\ARC and C:\TEMP
REM already exist.  C:\ARC should contain only archive templates.
REM C:\TEMP is your "TEMPorary" directory, in which you must copy all
REM files to be archived before running ARC.BAT.  No other files
REM whatsoever should reside in C:\TEMP.  Naturally, if you prefer to
REM use some other drive and/or directory, change "C:" to the desired
REM drive--likewise "\ARC" and "\TEMP".
REM
REM I use the "M" switch with PKPAK, which "moves" all files into the
REM created template, thereby clearing C:\TEMP for your next archive
REM session.  Therefore, "copy" files to be archived to C:\TEMP,
REM rather than "move" them...so in case anything goes wrong, you'll
REM still have the original files.
REM
REM This program is set up to use PKPAK (to archive). If you use
REM PKARC, replace "PKPAK" with "PKARC" everywhere it appears in the
REM batch routine (which begins 7 lines down).
REM
REM Also assumed is that your archiving programs (such as PKPAK and
REM PKUNPAK) reside in "C:\PUBLIC".  If you use another location,
REM change "c:\public" to the correct directory.
REM
REM
REM **********Begin ARC.BAT**************************************
ECHO ARCHIVE (compress) Files
ECHO ------------------------
ECHO .
ECHO YOU TYPED:  "ARC %1"
ECHO .
ECHO There should be no ".arc" as part of the template name.
ECHO If not correct, press CTRL-C to abort.  Otherwise,
PAUSE
CLS
DIR C:\ARC /W/P
ECHO ------------------------------------------------------------
ECHO !!  %1.arc should NOT be listed  !!
ECHO .
ECHO Directories "C:\ARC" and "C:\TEMP" must already exist, before
ECHO running this batch routine.  %1.ARC should not yet exist.
ECHO .
PAUSE
CLS
ECHO LISTING FILES TO ARCHIVE TO %1.ARC
ECHO ----------------------------------------
ECHO .
PAUSE
CLS
DIR C:\TEMP /P
ECHO -----------------------------------------------------------------
ECHO !! ONLY FILES TO ARCHIVE TO %1.ARC SHOULD BE LISTED !!
ECHO .
ECHO READY TO 'ARC' C:\TEMP\*.* TO "%1.ARC"
ECHO              [ctrl-c]=abort
PAUSE
CLS

C:\PUBLIC\PKPAK m C:\ARC\%1 C:\TEMP\*.*

REM If your archiving programs (such as "pkpak" and "pkunpak") reside
REM in a directory other than "c:\public", change it to the correct
REM location.
REM "PKPAK" uses the "m" switch, which "moves" all files to be
REM archived into the template.  This way, subdirectory C:\TEMP
REM is cleared for next archive.
REM ! Do not change the "m" to uppercase, as future versions of
REM PKPAK will only work with lowercase switches !

CLS
DIR C:\ARC\%1.ARC
ECHO -----------------------------------------------------------------
ECHO "%1.arc" SHOULD be listed.
ECHO .
ECHO ARCHIVING COMPLETE
ECHO .
PAUSE
CLS
REM **********End ARC.BAT****************************************
