** Program: Maker.prg
** Purpose: Write Make files to be used with MAKE Utility
** Version: Clipper Summer 87
** Author:  Calvin Harkins
**          Red River Software
**          Route 3 Box 399
**          Madill, OK 73446

SET ECHO OFF
SET CONFIRM ON
CLEAR
DECLARE OBJ[10]             && DECLARE ARRAY FOR OBJ FILES
DECLARE PRG[100]            && DECLARE ARRAY FOR PRG FILES

AFILL(OBJ,SPACE(8))         && FILL ARRAYS WITH BLANKS
AFILL(PRG,SPACE(8))

STORE "ENTER NAME OF PRIMARY OBJ FILE FIRST" TO statement1
@ 2, CENTER(statement1) SAY statement1

******                  GET OBJ FILES                             ******

FOR x = 1 TO 9
    @ 5, 26 TO  19, 54  DOUBLE
    @ x + 6, 28 SAY "ENTER OBJ FILE: " GET OBJ[x]
    READ
    IF OBJ[x] = " "
        x = 11
    ENDIF
NEXT x

******                  GET PRG FILES                          ******

CLEAR SCREEN
STORE 10 TO pos
STORE 1 TO x
DO WHILE x < 10 .AND. OBJ[x] > " "
    @ 3,32 TO 6, 48 DOUBLE
    @ 4, CENTER(OBJ[x]) SAY OBJ[x]
    STORE 1 TO y
    DO WHILE y < 10
        @ 8, 22 TO  22, 60 DOUBLE
        STORE SPACE(8) TO NAME
        @ pos + y, 24 SAY "ENTER DEPENDANT PRG FILE: " GET NAME
        READ
        IF NAME = " "
            y = 11
        ENDIF
        STORE NAME TO PRG[DEKA(x,y)]
        y = y + 1
    ENDDO
    CLEAR SCREEN
    x = x + 1
ENDDO

******                      WRITE MAKE FILE                          *****

TEMP = TRIM(OBJ[1])+".MAK"
SET CONSOLE OFF
SET ALTERNATE TO &TEMP
SET ALTERNATE ON
STORE 1 TO x
DO WHILE x < 10 .AND. OBJ[x] > " "
    line =  TRIM(OBJ[x]) + ".OBJ" + " : "    && DEFINE OBJ FILE
    STORE 1 TO y
    DO WHILE y < 10 .AND. PRG[DEKA(x,y)] > " "
       line =  line + TRIM(PRG[DEKA(x,y)]) + ".PRG "   && DEFINE PRG FILES
        y = y + 1
    ENDDO
    ? TRIM(line)                                && PRINT THE FILE LINE
    ? "CLIPPER @" + TRIM(OBJ[x])                && PRINT THE COMMAND LINE
x = x + 1
ENDDO

****       THIS SECTION CAN BE CHANGED FOR DIFFERENT LINKERS       ****

line = TRIM(OBJ[1]) + ".EXE : "        && DEFINE THE EXE FILE
x = 1
DO WHILE x < 10 .AND. OBJ[x] > " "
    line = line + TRIM(OBJ[x]) + ".OBJ "  && DEFINE THE OBJ FILES NEEDED
    x = x + 1
ENDDO
? TRIM(line)                              && DEFINE THE LINKER
line = "TLINK"
x = 1
DO WHILE x < 10 .AND. OBJ[x] > " "
     line = line + SPACE(1) + TRIM(OBJ[x])    && DEFINE THE FILES TO LINK
     x = x + 1
ENDDO
line = line + ",,,\CLIPPER\CLIPPER \CLIPPER\EXTEND "  && DEFINE THE LIBRARIES
? TRIM(line)                                && PRINT THE LINKER COMMAND
****                                                         ****
SET ALTERNATE OFF
SET ALTERNATE TO

******                  WRITE CLIP FILES                        ******

x = 1
DO WHILE x < 10 .AND. OBJ[x] > " "
    STORE TRIM(OBJ[x]) + ".CLP" TO TEMP     && NAME CLIP FILE
    SET ALTERNATE TO &TEMP
    SET ALTERNATE ON
    y = 1
    DO WHILE y < 10
        ? PRG[DEKA(x,y)]                    && PRINT PRG FILES
    y = y + 1
    ENDDO
SET ALTERNATE OFF
SET ALTERNATE TO
x = x + 1
ENDDO
SET CONSOLE ON
QUIT
********************************************************************
FUNCTION DEKA
** CALCULATES POSITION OF ARRAY
PARAMETERS x, y
spot = ((x*10)-10)+y
RETURN(spot)
*********************************************************************
FUNCTION Center
** CALCULATES COLUMN TO CENTER STRING
PARAMETER str_to_ctr
     IF LEN(str_to_ctr) < 80
       ctr_col = INT(40-LEN(str_to_ctr)/2)
     ELSE
       tr_col = 0 && string is wider than screen, return col 0
     ENDIF
RETURN(ctr_col)


********************


                                                                                                         
