

con_num_list( [H|T] ) :- rnum( H ), con_num_list( T ).
con_num_list( [] ).


/* To multiply a row by a column: */

mat_mult( [H1|T1], [H2|T2], res ) :-
	mat_mult1( [H1|T1], [H2|T2], 0, res ).

mat_mult1( [H1|T1], [H2|T2], sum, res ) :-
	sum is sum + H1 * H2,
	mat_mult1( T1, T2, sum, res ).

mat_mult1( [], [], sum, res ) :- res = sum.


/* To get the nth element of a list: 
   Let us assume a matrix in the form of a list of columns: 

[ L1, L2.....]
*/


listel( N, [H|T], X ) :- 
	N > 0, 
	N is N - 1,
	listel( N, T, X ).

listel( N, [H|_], X ) :- X = H.

/* Below, X, Y are the "coordinates".
   L is the complex list representing the array.
   element is the returned value. */

matrix_el( X, Y, L, element ) :-

/* First get the row, represented as an element "rowel" in list L */

	listel( X, L, rowel ),

/* And now the value contained within the row. */
	listel( Y, rowel, element ).
