/* Makes new atoms, one at a time. Do not expect a repeat solution. 
You must ask each time you want an atom. It starts with some root,
and appends an incrementing number onto it. 

Ask: ?-gensym( student, X ).      get: X = student1.
     ?-gensym( student, X ).      get: X = student2.
     ?-gensym( student, X ).      get: X = student3.

	and ad infinitum. */

gensym( Root, Atom ) :-
	get_num( Root, Num ),
	name( Root, Name1 ),
	integer_name( Num, Name2 ),
	append( Name1, Name2, Name ),
	name( Atom, Name ).

get_num( Root, Num ) :-
	retract( current_num( Root, Num1 )), !,
	Num is Num1 + 1,
	asserta( current_num( Root, Num)).

get_num( Root, 1 ) :- asserta( current_num( Root, 1 )).

integer_name( Int, List ) :- integer_name( Int, [], List ).
integer_name( I, Sofar, [C|Sofar] ) :-
	I < 10, !, C is I + 48.
integer_name( I, Sofar, List ) :-
	Tophalf is I/10,
	Bothalf is I mod 10,
	C is Bothalf + 48,
	integer_name( Tophalf, [C|Sofar], List ).


append( [], L, L ).
append( [Z|L1], L2, [Z|L3] ) :- append( L1, L2, L3 ).

printstring( [] ).
printstring( [] ).
printstring( [H|T] ) :- put( H ), printstring( T ).

