#define C105

/*
 *	Header file.....
 *	xPM.H: VERY small i/o package (cpmio.c) header file...
 *		includes console and file i/o
 *	Objective was to make a SIMPLE, efficient, WORKING! I/O package to
 *	use in the Metal Message system.
 *
 *			Copyright (c) 1984,1985  Tim Gary
 *			     All Rights reserved.
 *
 *
 *  09/02/85    Added _dpb structure for free_space routine..
 *  10/04/84	Full USER area change for read/write ops supported.
 *  10/03/84	Added reset_disk() define for bdos disk system reset.
 *
 *	CP/M and MP/M are registered trademarks of Digital Research.
 *	TurboDOS is a registered trademark of Software 2000, Inc.
 */

#define ERROR -1
#define EOF -1

/****************************************
 * differences from 1.05 and 1.06	*
 ****************************************/

#ifdef C105
#define malloc(a) alloc(a)		/* for name change */
#define movmem(a,b,c) blockmv(b,a,c)	/* name and order change */
#define setusr(a) bdos(32,a)		/* everything change */
#define setmem(a,b,c) clear(a,b,c)	/* name change */
#endif

/* Ways to open files... */

#define F_RD	0	/* open for read (just says not to MAKE file) */
#define F_RW	1	/* open/make file */
#define F_UNLOCK 0x10	/* open in multiuser unlocked mode */
#define F_RO	 0x20	/* open for Read only (multiuser)	*/
#define F_LOCK	 0	/* open in locked mode (   "   )	*/

/* define a xP/M fcb, length of it is 36 bytes	*/

struct fcb {
	char f_drive;		/* drive code 0=current, 1=A, etc...	*/
	char f_name[8];		/* file name, up to 8 chars in length	*/
	char f_type[3];		/* file type (extention), 3 chars long	*/
	char f_ext;		/* curret extent number			*/
	char f_resv[2];		/* internal cp/m use, 0's initially !	*/
	char f_rc;		/* extent record count			*/
	char f_sydx[16];	/* disk map				*/
	char f_cr;		/* current record for r/w		*/
	unsigned f_record;	/* random record number (low 2 bytes)	*/
	char f_overfl;		/* random record number high byte	*/
};


#define _BUFSIZ	128		/* for now use 128 byte buffer		*/

/* this is the buffered file structure... use 'FILE *fil;' in declarations */

typedef struct	{
	struct	fcb _fcb;	/* pointer to fcb (must be first item	*/
	char	_buffer[128];	/* cpm sector buffer..			*/
	char	*_bp;		/* buffer pointer.. to current char	*/
	char	_user;		/* user number file is in		*/
	} FILE;

/* disk parameter block structure..  used for space calculation routines */

#ifdef	XPMIO

struct _dpb {
	unsigned sectors;	/* # of sectors per track */
	char	 blk_shift;	/* block shift factor */
	char	 blk_mask;	/* block mask */
	char	 ext_mask;	/* extent mask */
	unsigned max_alloc;	/* max alloc block # */
	unsigned max_dir;	/* max dir entry number */
	char	 dir1_alloc;	/* bit map for blocks used by dir */
	char	 dir2_alloc;	/* (cont) */
	unsigned disk_change;	/* disk change flag */
	unsigned track_off;	/* track offset to start */
	};

#endif

#define bufloc(fd) ((fd)->_buffer)	/* pointer to begin of buffer..	*/
#define gchar(fd) (*(fd)->_bp++)    /* get next char from buffer, increment */
#define pchar(fd,ch) (*(fd)->_bp++=ch)	/* put char in buffer, increment*/
#define setbuf(fd,pos) ((fd)->_bp=fd->_buffer+pos)  /* set buffer pointer */
#define	getbuf(fd) ((fd)->_bp - (fd)->_buffer)	/* offset pos of _bp	*/
#define eobuf(f) (getbuf(f)>=_BUFSIZ)	/* end of buffer indicater...	*/

#define	setarec(fd,pos) ((fd)->_bp=(fd)->_buffer,(fd)->_fcb.f_record=pos)      /* set absolute record*/
#define setrrec(fd,offset) ((fd)->_bp=(fd)->_buffer,(fd)->_fcb.f_record+=offset)      /* set rel rec */
#define getrec(fd) ((fd)->_fcb.f_record)	/* like tell function */

#define toeof(fd) bdos(35,fd)	/* seek to end of xP/M file */

#define reset_disk(nada) bdos(13,nada)	/* reset disk system for disk change */

