;AVAIL.ASM
;6.12.85
;4.29.85
;
;Get space available on default drive
;
;----------------------------------------------------------
;		constants and messages

bpsec   	dw      512                     ;bytes per sector
secpcl  	dw      8
bpc     	dw      4096                    ;bytes per cluster
sectors 	dw      20740-1                 ;sectors on the disk (net of reserved)
clustrs 	dw      2586                    ;FAT clusters on the disk

avail_msg	db	cr,lf,'avail: ',eos

;----------------------------------------------------------
;		data

clavail dw      0                       ;clusters available

;----------------------------------------------------------
;		main code

AVAIL		proc	near

get_disk_space:
	        mov     ah,36H                  ;get disk space call
	        mov     dl,0                    ;default drive  
        	int     21H
		jnc	gd2
		push	ax			;save error code
		mov	dx,offset avail_msg
		mov	ah,9h
		int	21h
		pop	ax
		call	errmsg
		stc
		ret
	gd2:    mov     clavail,bx              ;available clusters
	        mov     clustrs,dx              ;clusters per drive
	        mov     bpsec,cx                ;bytes per sector
	        mov     secpcl,ax               ;sectors per cluster
	        mul     cx                      ;bytes per cluster in AX
	        mov     bpc,ax                  ;save for later computation

		clc
	        ret

avail		endp
