100 REM  *********************************************************************
110 REM  *                                                                   *
120 REM  *                        REHASH.BAS                                 *
130 REM  *                                                                   *
140 REM  *          Program to sort and rehash the PBBS Users File           *
150 REM  *                                                                   *
160 REM  *            Written October 15/86 by Ian Cottrell                  *
170 REM  *                                     Sysop, ICBBS                  *
180 REM  *                                     Ottawa, Ontario, Canada       *
190 REM  *                                     613-996-9774                  *
200 REM  *                                                                   *
210 REM  *                   Version 1.1  October 21/86 - IC                 *
220 REM  *                       - don't hash file - let PBBSMNT do it       *
230 REM  *                                                                   *
240 REM  *                   Version 1.2  October 27/86 - IC                 *
250 REM  *                       - simplified Qsort subroutine               *
260 REM  *                                                                   *
270 REM  *********************************************************************
280 VER$="1.2":DAIT$="October 27/86"
290 DIM NME1$(500),NME2$(500),REC(500),STACK(20)
300 BEL$=CHR$(7)
310 CLS$=CHR$(26): REM  Clear screen code
320 USERS=500: REM  Set to maximum number of users allowed (from PBBSHDR)
330 PRINT CLS$ SPC(13) "---==={ PBBS User List Sort & Re-Hash Program }===---"
340 PRINT SPC(30) "(by Ian Cottrell)":PRINT
350 PRINT TAB((65-LEN(VER$)-LEN(DAIT$))/2) "BETA Version " VER$ " " DAIT$:PRINT
360 NAME "USERS.PBS" AS "USERS.BAK"
370 OPEN "R",#1,"USERS.BAK",100
380 FIELD #1, 1 AS FRF$,30 AS N$,20 AS L$,10 AS PW$,12 AS PH$,2 AS NOL$,

    3 AS LOD$,1 AS LEV$,1 AS MAIL$,1 AS DU$,1 AS NU$,1 AS BR$,2 AS UPLDS$,

    2 AS DWNLDS$,2 AS UMAP$,2 AS DMAP$,1 AS TCODE$,1 AS LTOS$,2 AS HMSG$,

    5 AS NUSED$
390 REM  Key to FIELD statement for USERS.BAK and USERS.PBS
400 REM  USERS.BAK                                         USERS.PBS
410 REM    FRF$    = record free flag (0=record not used)   = FRF1$
420 REM    N$      = name of user                           = N1$
430 REM    L$      = City, Prov/State of user               = L1$
440 REM    PW$     = password                               = PW1$
450 REM    PH$     = phone number                           = PH1$
460 REM    NOL$    = number of logons                       = NOL1$
470 REM    LOD$    = last date on system                    = LOD1$
480 REM    LEV$    = user level (0-9)                       = LEV1$
490 REM    MAIL$   = mail waiting flag (0=no mail)          = MAIL1$
500 REM    DU$     = initial drive/user                     = DU1$
510 REM    NU$     = number of nulls needed                 = NU1$
520 REM    BR$     = last baud rate used                    = BR1$
530 REM    UPLDS$  = number of uploads                      = UPLD1$
540 REM    DWNLDS$ = number of downloads                    = DNLD1$
550 REM    UMAP$   = user area map                          = UMAP1$
560 REM    DMAP$   = drive map                              = DMAP1$
570 REM    TCODE$  = terminal code                          = TCODE1$
580 REM    LTOS$   = time on system last time               = LTOS1$
590 REM    HMSG$   = high messsage read                     = HMSG1$
600 REM    NUSED$  = not used                               = NUSED1$
610 COUNT=0
620 PRINT:PRINT "Please wait, reading current data...":PRINT
630 FOR C=1 TO USERS
640	IF INKEY$=CHR$(3) THEN PRINT "<ABORTED>":STOP
650	GET #1,C
660	IF ASC(FRF$)=0 THEN 800
670	COUNT=COUNT+1
680	FOR X=30 TO 1 STEP -1
690	    IF MID$(N$,X,1)<>CHR$(0) THEN DIV=X:X=1
700	NEXT X
710	NME$=LEFT$(N$,DIV)
720	FOR X=1 TO LEN(NME$)
730	    IF MID$(NME$,X,1)=" " THEN DIV=X:X=LEN(NME$)
740	NEXT X
750	NME1$(COUNT)=LEFT$(NME$,DIV-1):NME2$(COUNT)=RIGHT$(NME$,LEN(NME$)-DIV)
760	REC(COUNT)=C
770	PRINT "Record #: ";:PRINT USING "###";C;
780	PRINT "   User count: ";:PRINT USING "###";COUNT;
790	PRINT CHR$(13);
800 NEXT C
810 PRINT:PRINT
820 GOSUB 1120
830 HASH=INT(USERS/26):FL$=""
840 OPEN "R",#2,"USERS.PBS",100
850 FIELD #2,100 AS INIT$
860 PRINT "Initializing new USER.PBS file...":PRINT
870 LSET INIT$=STRING$(100,CHR$(0))
880 FOR LOOP=1 TO USERS
890     PUT #2,LOOP
900 NEXT LOOP
910 CLOSE#2
920 OPEN "R",#2,"USERS.PBS",100
930 FIELD #2,1 AS FRF1$,30 AS N1$,20 AS L1$,10 AS PW1$,12 AS PH1$,

    2 AS NOL1$,3 AS LOD1$,1 AS LEV1$,1 AS MAIL1$,1 AS DU1$,1 AS NU1$,

    1 AS BR1$,2 AS UPLD1$,2 AS DNLD1$,2 AS UMAP1$,2 AS DMAP1$,

    1 AS TCODE1$,1 AS LTOS1$,2 AS HMSG1$,5 AS NUSED1$
940 PRINT "Writing new USER.PBS file..."
950 FOR LOOP=1 TO COUNT
960	GET #1,REC(LOOP)
970     LSET FRF1$=FRF$:LSET N1$=N$:LSET L1$=L$:LSET PW1$=PW$
980     LSET PH1$=PH$:LSET NOL1$=NOL$:LSET LOD1$=LOD$:LSET LEV1$=LEV$
990     LSET MAIL1$=MAIL$:LSET DU1$=DU$:LSET NU1$=NU$:LSET BR1$=BR$
1000     LSET UPLD1$=UPLDS$:LSET DNLD1$=DWNLDS$:LSET UMAP1$=UMAP$
1010     LSET DMAP1$=DMAP$:LSET TCODE1$=TCODE$:LSET LTOS1$=LTOS$
1020     LSET HMSG1$=HMSG$:LSET NUSED1$=NUSED$
1030	PUT #2,LOOP
1040 NEXT LOOP
1050 CLOSE
1060 PRINT BEL$:FOR DEL=1 TO 400:NEXT DEL:PRINT BEL$:FOR DEL=1 TO 200:NEXT DEL
1070 PRINT "<<  BE SURE TO VERIFY USERS.PBS BEFORE DESTROYING USERS.BAK  >>"
1080 PRINT "<<     YOU MUST NOW USE PBBSMNT TO REHASH THE USERS FILE     >>"
1090 PRINT "<<  DO NOT ATTEMPT TO USE USERS.PBS UNTIL THIS HAS BEEN DONE >>"
1100 PRINT BEL$:FOR DEL=1 TO 200:NEXT DEL:PRINT BEL$
1110 END
1120 REM  Sort names using QSORT
1130 PRINT "Sorting user list by last name...":PRINT
1140 S=1:STACK(S)=1:STACK(S+1)=COUNT
1150 WHILE S>0
1160	L=STACK(S):R=STACK(S+1):S=S-2
1170	WHILE L<R
1180	    I=L:J=R:X$=NME2$((L+R)/2)
1190	    WHILE I<=J
1200	        WHILE NME2$(I)<X$
1210	            I=I+1
1220	        WEND
1230	        WHILE X$<NME2$(J)
1240	            J=J-1
1250	        WEND
1260	        IF I<=J THEN SWAP NME2$(I),NME2$(J):SWAP NME1$(I),NME1$(J):

                 SWAP REC(I),REC(J):I=I+1:J=J-1
1270	    WEND
1280	    IF I<R THEN S=S+2:STACK(S)=I:STACK(S+1)=R
1290	    R=J
1300	WEND
1310 WEND
1320 RETURN
I+1:J=J-1
1270	    WEND
1280	    IF I<R THEN S=S+2:STACK(S)=I:STACK(S+1)