#include <stdio.h>
#include <fcntl.h>
typedef struct
{
	char *cmdname;
	int (*func)();
} builtin;

char *str_lower();

extern int result;

/*lint -e15 -e532 */
extern int cmds(),ls(), cp(), rm(), do_prog(),pushd(),popd(),drive(), ver(),
		more(),fgrep(),scr_clear(),set(),ch_mod(),cat(),echo(),  y(),t(),dump(),
		last(),invalid(),mv(),md(),touch(),cd(),pwd(),rd(),hist(),my_exit();

/*lint +e15 +e532 */
/*lint +fva -e715 -e533 */
int my_exit(argc,argv)
	char *argv[];
{
	restore_switch();
	exit(result);
}
/*lint -fva +e715 +e533 */

int ver()
{
	extern char *version;
	write(2,version,strlen(version));
	write(2,"\r\n",2);
	return 0;
}

extern builtin commands[];
extern unsigned numcmds;
char *histerr = "no history";
unsigned j,hiscount;
char *history[] = {NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
					 NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};

unsigned histsize = (sizeof(history)/sizeof(char *));

int cmds()
{
	char *current;
	register int i,j,col;
	col = 1;
	for (i = 0; i < numcmds; i++)
	{
		current = commands[i].cmdname;
		write(1,current,j = strlen(current));
		for (;j < 16;j++)
			write(1," ",1);
		if (col == 4)
		{
			col = 1;
			crlf();
		}
		else
			++col;
	}
	crlf();
	return 0;
}

int findcmd(cmdbuf)
	char *cmdbuf;
{
	register unsigned low,high,mid;
	char localbuf[256];
	int cond; char c;
	strcpy(localbuf,cmdbuf);
	cmdbuf = str_lower(localbuf);
	low = 0;
	high = numcmds - 1;
	while (low <= high)
	{
		mid = (low+high) / 2;
		if	( ( cond =  strncmp( cmdbuf,
								 commands[mid].cmdname,
								 strlen(commands[mid].cmdname) ) ) < 0 )
				high = mid - 1;
		else if (cond > 0)
				low = mid + 1;
		else
		{
			if ( ' ' == (c = cmdbuf[strlen(commands[mid].cmdname)]) ||
			     '\0' == c)
			{
				/* kludge to allow for program invocations like d:command */
				if (cmdbuf[1] == ':')
					if (cmdbuf[2] == '\0')
						return (int)mid;
					else
						return -1;
				return (int)mid;
			}
			return -1;
		}
	}
	return -1;
}

int hist()
{
	register int i;
	char localbuf[256];
	if (j < histsize)
		i = 0;
	else
		i = (int)j - (int)histsize + 1;
	for (;i <= j; i++)
	{
		sprintf(localbuf,"%d : %s\r\n",i,history[i % histsize]);
		write(1,localbuf,strlen(localbuf));
	}
	return 0;
}

int last()
{
	printf("return code of last command %d\n",result);
	return result;
}
