/***************************************************************************
 *                                                                         *
 * LZH Processing Functions                                                *
 * These routines process archive files with the LZH extension.            *
 **************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "fff.h"
#include "lzh.h"

int Match (char *Str, char *Pat);
void PrtVerbose (char *Path, char *Name, DOS_FILE_TIME *Time, DOS_FILE_DATE *Date,
				 long Size);
static int GetEntry (FILE *LzhFile, LZH_HEADER *LzhDir);
void ChkPage (void);
int  SearchQ (char *Str);

extern char Pattern[66];

static char *Name;

/***********************************************************************
 * DoLzh is the main routine used to process an entire LZH file.       *
 ***********************************************************************/

 void
DoLzh (char *Path) {
	extern int Level; extern int TotalMatch, VerboseSwt, CaseSwt, Spaced, PageSwt;
	extern char V_Name[14], V_Path[65];
	extern ARC_TYPE ArcType;
	extern int Lnno; extern int S[6][3];

	FILE *LzhFile;
	int Status, Printed;
	LZH_HEADER LzhHead;
	char *p;

	Printed = 0;
	if ( (LzhFile = fopen(Path, "rb")) == NULL) perror(Path);
	else {
		while ( (Status = GetEntry(LzhFile, &LzhHead)) > 0 ) {
			if ( (p = strrchr(Name, '\\')) != NULL) ++p;
			else p = Name;
			++S[ArcType][1];
			if ( SearchQ(p) ) {
				++S[ArcType][2];
				++TotalMatch;
				if (PageSwt) ChkPage();
				strcpy(V_Name, p);
				strcpy(V_Path, Path);
				if (CaseSwt == ON) {
					strlwr(V_Name);
					strlwr(V_Path);
					}
				if (VerboseSwt) {
					if (!Printed) {
						if (!Spaced) {
							if (PageSwt) ChkPage();
							printf("\n");
							++Lnno;
							}
						if (PageSwt) ChkPage();
						printf("%s\n", V_Path);
						++Lnno;
						Printed = 1;
						}
					fputs("* ", stdout);
					PrtVerbose("", V_Name, &LzhHead.Time, &LzhHead.Date,
								LzhHead.OriginalSize);
					}
				else {
					fputs(V_Path, stdout);
					fputs("--> (", stdout);
					fputs(V_Name, stdout);
					puts(")");
					}
				++Lnno;
				}
			}
		free(Name);
		if (Status < 0) printf("%s\n", Path);
		fclose(LzhFile);
		}
	if (Printed) {
		if (PageSwt) ChkPage();
		printf("\n");
		++Lnno;
		Spaced = 1;
		}
	}

/***********************************************************************
 * GetEntry reads and verifys the next entry in the distributed        *
 * directory of an LZH file.                                           *
 ***********************************************************************/

 static int
GetEntry (FILE *LzhFile, LZH_HEADER *LzhDir) {
	size_t Len;

	if ( (Len = fread(LzhDir, 1, sizeof(LZH_HEADER), LzhFile)) < 2) {
		if ( (Len != 1) || (LzhDir->HeadSize != 0X00) ) {
			printf("Couldn't read header: ");
			return(-1);
			}
		return(0);
		}

	if ( (Name = malloc(LzhDir->FileNameLength + 1)) == NULL) {
		printf("Insufficient memory for file name: ");
		return(-1);
		}
	fread(Name, 1, LzhDir->FileNameLength, LzhFile);
	Name[LzhDir->FileNameLength] = '\0';

	fseek(LzhFile, sizeof(unsigned) + LzhDir->CompressedSize, SEEK_CUR);
	return(1);
	}
