/*
       PCIO.C
       6/22/87 D.A. Knapp
       updated 6/26/87 for Turbo C

     These functions are a subset of the screen i/o functions contained
     in the DeSmet C file pcio.a.  They have been written in Turbo C 
     with inline assembler.

   The functions are:
      scr_rowcol(row,col)       move the cursor to row,column
            int row,col;

      scr_curpos(&row,&col)     get the current cursor position
            int row,col;

      char scr_sinp()           returns the character under the cursor

      scr_clr()                 clear the screen and reset colors

      scr_color(fcolor,bcolor)  clear the screen and set default colors
            int fcolor,bcolor;

      scr_clrl()                clear from the cursor to the end of line

      scr_scrup(numLines,fromRow,fromCol,toRow,toCol)
            char numLines,fromRow,fromCol,toRow,toCol;
                                scroll a portion of the screen  (can also
                                be used to clear a portion of the screen
                                by setting numLines=0)

      scr_aputs(string,attr)    put a character string with attributes to
            char *string,attr;  the screen

*/
       
#include <stdio.h>
#include <dos.h>

char color_scr;         /* global variable of default screen color */

void scr_rowcol(row,col)
	int row,col;
{
	asm mov	ah,2
	asm mov	al,0
	asm mov	dh,row
	asm mov dl,col
	asm mov bh,0
	asm int 10h
}

void scr_curpos(rowp,colp)
	int *rowp,*colp;
{
	asm mov ah,3
	asm mov al,0
	asm mov bl,0
	asm int 10h
	*rowp = _DH;
	*colp = _DL;
	return;
}

char scr_sinp()
{
	asm mov ah,8
	asm mov bh,0
	asm int 10h
	return _AL;
}
	
void scr_clr()
{
	asm mov ah,6
	asm mov al,0
	asm mov	cx,0
	asm mov	dh,25
	asm mov dl,80
	asm mov	bh,7
	asm int 10h
	color_scr = 7;
}

void scr_clrl()
{
	asm mov	ah,3
	asm mov	al,0
	asm mov	bh,0
	asm int	10h			/* get current cursor position	*/
	asm mov	ah,6
	asm mov	al,0
	asm mov	cx,dx
	asm mov	dl,80
	asm mov	bh,color_scr
	asm int 10h
}

void scr_color(fcolor,bcolor)
	int fcolor,bcolor;
{
	color_scr = ((fcolor + ((bcolor << 4) & 0xF0)) & 0xFF);
	asm mov	ah,6
	asm mov	al,0
	asm mov	cx,0
	asm mov	dh,25
	asm mov	dl,0
	asm mov	bh,color_scr
	asm int 10h
}

void scr_scrup(numLines,fromRow,fromCol,toRow,toCol)
	char numLines,fromRow,fromCol,toRow,toCol;
{
	asm mov	ah,6
	asm mov	al,numLines
	asm mov	ch,fromRow
	asm mov	cl,fromCol
	asm mov	dh,toRow
	asm mov	dl,toCol
	asm mov	bh,color_scr
	asm int 10h
}


void scr_aputs(string,attr)
	char *string,attr;
{
	char *str;
	str = string;
	asm mov	bh,0
	asm mov ah,3
	asm int 10h
	asm mov	cx,1
	start:
		_AL = *str;
		asm cmp al,0
		asm je exit
		asm cmp	al,10
		asm je linefeed
		asm mov ah,9
		asm mov bl,attr
		asm int 10h
		asm inc dl
		asm mov	ah,2
		asm jmp	next
	linefeed:
		asm mov al,13
		asm mov ah,14
	next:
		asm int 10h
		str++;
		asm jmp start
	exit:	
}
