/* disktest.c - test raw disk i/O */
#include "stdio.h"
#include "ctype.h"

#define ASIZE  25000		/* size of area for a buffer */

long seqio() , randio() ;
char *align() ;
int dno , nstart , i , nit ;
char *pbuf ;

int clu , free , tot , bps ;	/* disk space variables */
long totsec ;			/* put total sectors here */

main(argc,argv)
 int argc ;
 char *argv[] ;
 {
    char area[ ASIZE ] ;

    /* ensure that the buffer does not cross a 64K address boundary */
    pbuf = align(area,ASIZE/2) ;  

    printf(" drive number (0=a , 1=b ...) \n") ;
    scanf("%d",&dno) ;

    clu = getspac(dno+1,&free,&tot,&bps) ;
    if( clu == 0xffff )
      { printf(" invalid drive number \n");
        exit(10) ;
      }
    totsec = clu * (long) tot ;
    printf(" total number of sectors = %ld \n",totsec) ;

    nstart = 0 ;  nit = 20 ;
    printf(" Sequential Reads \n");
    doseq(1) ;			/* run some Sequential Read tests*/
    doseq(8) ;
    doseq(16) ;
    doseq(24) ;
				/* now run some random read tests */
    nit = 40 ;
    printf(" Random Reads - %2d sector \n",1);
    dorand(1, 0.1 ) ;
    dorand(1, 0.33 ) ;
    dorand(1, 0.5 ) ;
    dorand(1, 0.9 ) ;
    printf(" Random Reads - %2d sector \n",8);
    nit = 20 ;
    dorand(8, 0.1 ) ;
    dorand(8, 0.33 ) ;
    dorand(8, 0.5 ) ;
    dorand(8, 0.9 ) ;
 }

int doseq(nseg)
 int nseg ;
 {
   long t ;

   t = seqio(dno,nseg,nstart,pbuf,nit) ;
   printf(" %2d sectors          - ", nseg ) ;
   printf("  %4.3f Sec/read \n",  t / (18.2*nit) ) ;
 }



int dorand(nseg,frac)
 int nseg ;
 float frac ;
 {
   long t ;
   int offset ;

   offset = totsec * frac ;
   t = randio(dno,nseg,nstart,pbuf,nit,offset) ;
   printf(" %5.2f width seeks   - ", frac) ;
   printf("  %4.3f Sec/read \n",  t / (18.2*nit) ) ;
 }
   
