/* IN -- indent-formats a structured assembly source file */

/*
V 1.0 --
  This version compiled under DeSmet v2.4
  
THIS PROGRAM IS PUBLIC DOMAIN
 and may be freely used, modified, and distributed.
 
 If you find it useful and would like to express your appreciation,
 DON'T send me a contribution!  Just support your local bulletin
 boards with courtesy, enthusiasm and good free software.
 That's what it's all about, after all!
 
 Davidson Corry
 4610 SW Lander
 Seattle, WA  98116
 206 / 935-0244
*/
#include <stdio.h>

#undef loop
#define loop for(;;)

/* statement types */
#define COMMENT 0
#define NORMAL 1
#define OPENIF 2
#define MIDIF 3
#define CLOSEIF 4
#define OPENLOOP 5
#define MIDLOOP 6
#define CLOSELOOP 7

#define MAXLINSZ 255
#define MAXDEPTH 255

#define BELL 7

char cmtchar, iline[MAXLINSZ], work[MAXLINSZ], remark[MAXLINSZ], srcfil[20], k, *p;
int comment, lincount, nest_level, depth, tabcount, ld[MAXDEPTH], id[MAXDEPTH];
FILE *src, *dst;

char *tabs = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
char *index(), *pointcomment();

main(argc,argv)
int argc;
char *argv[];
	{

	if (argc <= 1)
		{
		fputs("Usage: IN SOURCE\n",stderr);
		fputs("  Indents SOURCE.A structured-assembly sourcefile",stderr);
		exit(1);
		}

	strcpy(srcfil,argv[1]);
	if ( (p=index(srcfil,'.')) == NULL)
		strcat(srcfil,".A");
	if ( (src=fopen(srcfil,"r")) == NULL)
		{
		fprintf(stderr,"?Cannot open %s",srcfil);
		exit(1);
		}
	if ( (dst=fopen("MACINDNT.FIL","w")) == NULL)
		{
		fprintf(stderr,"?Cannot create MACINDNT.FIL");
		exit(1);
		}

	depth=0;
	ld[0]=0;
	id[0]=0;
	comment=FALSE;
	lincount=0;

	while ( fgets(work,MAXLINSZ,src) != NULL)
		{
		if (lincount && !(lincount % 20))
			fprintf(stderr,"\r%d",lincount);
		p=work;
		while (*p)
			{
			if (*p=='\'')
				while (*++p!='\'')
					;
			else if (*p=='\"')
				while (*++p!='\"')
					;
			else if (*p==';')
				break;
			else
				*p = toupper(*p);
			++p;
			}
		p=work;
		if (*p=='\f')
			continue; /* ignore form feeds */
		if (*p=='\n')
			{
			fputs(work,dst);
			lincount++;
			continue;
			}
		while (*p == ' ' || *p == '\t')
			p++; /* p->first nonblank in workstring */
		if (leads(p,".COMMENT"))
			{
			p += 8;
			while (isspace(*p))
				p++;
			cmtchar=*p++;
			comment=TRUE;
			}

		if (comment)
			sendcomment(work);
		else
			pretab(p); /* instruction line, tab in */

		lincount++;
		if (comment)
			if (index(p,cmtchar))
				{
				comment=FALSE;
				}
		}
	fclose(src);
	fclose(dst);
	fprintf(stderr,"\r%d lines formatted",lincount);
	if (ld[depth]+id[depth])
		{
		fprintf(stderr,"\007 -- text ends at nest level %d",ld[depth]+id[depth]);
		exit(1);
		}
	unlink(srcfil);
	if ( (rename("MACINDNT.FIL",srcfil)) == ERR)
		{
		fprintf(stderr,"Cannot rename MACINDNT.FIL to %s",srcfil);
		exit(1);
		}
	}

char *instr(object,key)
/* find occurence of string KEY in string OBJECT --
returns pointer to (KEY within OBJECT), or NULL if not found */
char *object,*key;
	{
	register char *q,*r;

	while (*object)
		{
		for ( q=key, r=object; *q && *r == *q; ++r, ++q )
			;
		if (!*q)
			return(object);
		++object;
		}
	return(NULL);
	}

pretab(p)
char *p;
	{
	int y,x;

	while (isspace(*p))
		p++;
	if (p==pointcomment(p)) { sendcomment(p); return; }
	strcpy(iline,tabs+39-inset(p));
	if (depth<0)
		{
		fprintf(stderr,"Degenerate loop ending on line %d",++lincount);
		exit(1);
		}
	strcat(iline,p);
	if (p = pointcomment(iline) )
		{
		strcpy(remark,p);
		*p = '\0';
		while (isspace(*--p))
			*p = '\0';
		do 
			{
			strcat(iline,"\t");
			} while (tabbed_length(iline)<40);
		strcat(iline,remark);
		}
	if (tabbed_length(iline)<95)
		{
		fputs(iline,dst);
		return;
		}
	if (p = pointcomment(iline) )
		{
		strcpy(remark,p);
		*p = '\0';
		}
	if (tabbed_length(iline)>95)
		{
		for (p = iline; isspace(*p); ++p)
			;
		if (strncmp(p,"DB\t",3)==0)
			{
			p = instr(p+strlen(p)/4,"\',")+1;
			if (p==1) goto too_long;
			strcpy(work,p+1);
			strcpy(p,"\n\tDB\t");
			strcat(p,work);
			}
		else if (strncmp(p,"DW\t",3)==0)
			{
			p = instr(p+strlen(p)/4,"\',")+1;
			if (p==1) goto too_long;
			strcpy(work,p+1);
			strcpy(p,"\n\tDW\t");
			strcat(p,work);
			}
		else
			{
too_long:
			fprintf(stderr,"\r(%d) \007Source line too long:\n%s",++lincount,work);
			exit(1);
			}
		}
	fprintf(dst,"%s\n",iline);
	sendcomment(remark);
	}

inset(p)
char *p;
	{
	switch (stype(p))
		{
	case COMMENT:
		return(-1);
	case NORMAL:
		return(ld[depth]+id[depth]);
	case OPENIF:
		return(ld[depth]+id[depth]++);
	case MIDIF:
		return(ld[depth]+id[depth]-1);
	case CLOSEIF:
		return(ld[depth]+(--id[depth]));
	case OPENLOOP:
		depth++;
		ld[depth] = ld[depth-1]+id[depth-1]+1;
		id[depth] = 0;
		return(ld[depth]-1);
	case MIDLOOP:
		return(ld[depth]-1);
	case CLOSELOOP:
		return(ld[depth--]-1);
		}
	}

stype(p)
char *p;
	{
	char k,*q,*r;
	if (*p=='\n')
		return(COMMENT);
	if (*p==';')
		{
		if (*(p+1)=='\n')
			{
			*p++='\n';
			*p='\0';
			return(COMMENT);
			}
		else
			return(NORMAL);
		}
	q=p;
	while (!isspace(*q))
		q++;
	while (isspace(*q))
		q++;
	if (leads(q,"MACRO")||leads(q,"SET")||leads(q,"EQU")||
		leads(q,"SEGMENT")||leads(q,"DW")||leads(q,"DB")||
		leads(q,"DD")||leads(q,"LABEL")||leads(q,"ENDS")||
		leads(q,"ENDP")||leads(q,"PROC"))
		return(COMMENT);
	q=p;
	while (*q)
		{
		if (*q==' ' || *q=='\t')
			break;
		if (*q==':')
			{
			k = *++q;
			if (k==':')
				k = *++q; /* skip double colon */
			if (k=='\n')
				return(COMMENT); /* bare labels at left margin */
			*q='\0';
			r=p;
			while (isspace(*r))
				r++;
			fprintf(dst,"%s\n",r); /* dump the label on its own line */
			*q=k;
			while (p<q)
				*p++ = ' ';
			while (*p==' '||*p=='\t')
				p++; /* skip blanks */
			if (*p=='\n')
				return(COMMENT);
			break; /* and continue the scan */
			}
		q++;
		}
	if ( leads(p,".LOOP") || leads(p,".WHILE") || leads(p,".REPEAT") )
		return(OPENLOOP);
	else if ( leads(p,".LEND") || leads(p,".WEND") || leads(p,".UNTIL") )
		return(CLOSELOOP);
	else if ( leads(p,".CNTNU") || leads(p,".BREAK") )
		return(MIDLOOP);
	else if ( leads(p,".IF") )
		return(OPENIF);
	else if ( leads(p,".ENDIF") )
		return(CLOSEIF);
	else if (leads(p,".ELSE") || leads(p,".ELSEIF") )
		return(MIDIF);
	else
		return(NORMAL);
	}

leads(p,kywrd)
char *p,*kywrd;
	{
	while (*kywrd)
		if (toupper(*p++) != *kywrd++)
			return(FALSE);
	if (isspace(*p) || *p=='\0')
		return(TRUE);
	return(FALSE);
	}

char *pointcomment(s)
char *s;
	{
	for ( ; *s ; ++s)
		{
		if (*s==';')
			return(s);
		else if (*s=='\'')
			{
			if (!(s=index(s+1,'\'')))
				return(NULL);
			}
		else if (*s=='\"')
			{
			if (!(s=index(s+1,'\"')))
				return(NULL);
			}
		}
	return(NULL);
	}

sendcomment(s)
char *s;
	{
	if (tabbed_length(s)>=95)
		{
		p = index(s+strlen(s)/2,' ');
		if (!p)
			p = s+strlen(s)/2;
		strcpy(remark,p);
		strcpy(p,"\n;");
		strcat(p,remark);
		}
	fputs(s,dst);
	}

tabbed_length(s)
char *s;
	{
	int i;

	for (i = 0; *s; ++s)
		{
		if (*s=='\t')
			i = ( (i+8)/8 ) * 8;
		else
			++i;
		}
	return(i);
	}

